/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import main.LoginCore;
import main.Oscar;
import uiutil.ChangeListener;
import uiutil.ChoiceUI;
import uiutil.PasswordField;
import uiutil.PropertySheet;
import uiutil.Spacer;
import uiutil.TransparentPanel;
import util.JUtil;
import util.KeyBindings;

public class LoginPasswordProps
extends PropertySheet
implements KeyListener {
    private LoginCore login;
    private ChangeListener changeListener;
    private Label saveTitle;
    private Label nicknameLabel;
    private TextField nicknameField;
    private Label passwordLabel;
    private PasswordField passwordField;
    private Label changeTitle;
    private Label oldPasswordLabel;
    private PasswordField oldPasswordField;
    private Label newPasswordLabel;
    private PasswordField newPasswordField;
    private Label dupPasswordLabel;
    private PasswordField dupPasswordField;
    private Label emailTitle;
    private Label newEmailLabel;
    private TextField newEmailField;
    private KeyBindings config;
    private boolean changed = false;

    public LoginPasswordProps(LoginCore loginCore, ChangeListener changeListener) {
        this.login = loginCore;
        this.changeListener = changeListener;
        this.config = Oscar.config.getKeyBindingsOrAdd(LoginCore.LOGIN_KEY);
        this.setBackground(Oscar.backgroundColor);
        this.setLayout(new BorderLayout());
        this.add("North", new Spacer());
        this.add("East", new Spacer());
        this.add("West", new Spacer());
        TransparentPanel transparentPanel = new TransparentPanel();
        this.add("Center", transparentPanel);
        transparentPanel.setLayout(new GridLayout(0, 1));
        this.saveTitle = new Label("Save this nickname and password:", 0);
        transparentPanel.add(this.saveTitle);
        TransparentPanel transparentPanel2 = new TransparentPanel();
        transparentPanel.add(transparentPanel2);
        transparentPanel2.setLayout(new FlowLayout(2, 0, 0));
        this.nicknameLabel = new Label("Nickname: ", 2);
        transparentPanel2.add(this.nicknameLabel);
        this.nicknameField = new TextField(10);
        transparentPanel2.add(this.nicknameField);
        this.nicknameField.addKeyListener(this);
        transparentPanel2 = new TransparentPanel();
        transparentPanel.add(transparentPanel2);
        transparentPanel2.setLayout(new FlowLayout(2, 0, 0));
        this.passwordLabel = new Label("Password: ", 2);
        transparentPanel2.add(this.passwordLabel);
        this.passwordField = new PasswordField(10);
        transparentPanel2.add(this.passwordField);
        this.passwordField.setEchoChar('*');
        this.passwordField.addKeyListener(this);
        this.changeTitle = new Label("Change your password: ", 0);
        transparentPanel.add(this.changeTitle);
        transparentPanel2 = new TransparentPanel();
        transparentPanel.add(transparentPanel2);
        transparentPanel2.setLayout(new FlowLayout(2, 0, 0));
        this.oldPasswordLabel = new Label("Enter Old Password: ", 2);
        transparentPanel2.add(this.oldPasswordLabel);
        this.oldPasswordField = new PasswordField(10);
        transparentPanel2.add(this.oldPasswordField);
        this.oldPasswordField.setEchoChar('*');
        this.oldPasswordField.addKeyListener(this);
        transparentPanel2 = new TransparentPanel();
        transparentPanel.add(transparentPanel2);
        transparentPanel2.setLayout(new FlowLayout(2, 0, 0));
        this.newPasswordLabel = new Label("Enter New Password: ", 2);
        transparentPanel2.add(this.newPasswordLabel);
        this.newPasswordField = new PasswordField(10);
        transparentPanel2.add(this.newPasswordField);
        this.newPasswordField.setEchoChar('*');
        this.newPasswordField.addKeyListener(this);
        transparentPanel2 = new TransparentPanel();
        transparentPanel.add(transparentPanel2);
        transparentPanel2.setLayout(new FlowLayout(2, 0, 0));
        this.dupPasswordLabel = new Label("Enter again to confirm: ", 2);
        transparentPanel2.add(this.dupPasswordLabel);
        this.dupPasswordField = new PasswordField(10);
        transparentPanel2.add(this.dupPasswordField);
        this.dupPasswordField.setEchoChar('*');
        this.dupPasswordField.addKeyListener(this);
        this.emailTitle = new Label("Change your email address: ", 0);
        transparentPanel.add(this.emailTitle);
        transparentPanel2 = new TransparentPanel();
        transparentPanel.add(transparentPanel2);
        transparentPanel2.setLayout(new FlowLayout(2, 0, 0));
        this.newEmailLabel = new Label("New Email Address: ", 2);
        transparentPanel2.add(this.newEmailLabel);
        this.newEmailField = new TextField(10);
        transparentPanel2.add(this.newEmailField);
        this.changeTitle.setEnabled(false);
        this.oldPasswordLabel.setEnabled(false);
        this.newPasswordLabel.setEnabled(false);
        this.dupPasswordLabel.setEnabled(false);
        this.oldPasswordField.setEditable(false);
        this.newPasswordField.setEditable(false);
        this.dupPasswordField.setEditable(false);
        this.emailTitle.setEnabled(false);
        this.newEmailLabel.setEnabled(false);
        this.newEmailField.setEnabled(false);
        this.newEmailField.setEditable(false);
        this.setValues();
    }

    public boolean changed() {
        return this.changed;
    }

    public boolean help() {
        ChoiceUI.newChoiceUI("Login Password Help", "This folder is where you change your password, save your name and password for automatic login and change your email address. Type the new information into the appropriate text fields. When you change your password, you'll need to supply your old password. You must be connected to the service in order to change your password or email address. If you are not connected, these fields will be disabled.");
        return true;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            Component component = keyEvent.getComponent();
            if (component == this.nicknameField) {
                this.passwordField.requestFocus();
            } else if (component == this.passwordField) {
                this.oldPasswordField.requestFocus();
            } else if (component == this.newPasswordField) {
                this.dupPasswordField.requestFocus();
            } else if (component == this.dupPasswordField) {
                this.nicknameField.requestFocus();
            }
        }
        this.setChanged(true);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void removeNotify() {
        this.removeAll();
        this.login = null;
        this.changeListener = null;
        this.saveTitle = null;
        this.nicknameLabel = null;
        this.nicknameField = null;
        this.passwordLabel = null;
        this.passwordField = null;
        this.changeTitle = null;
        this.oldPasswordLabel = null;
        this.oldPasswordField = null;
        this.newPasswordLabel = null;
        this.newPasswordField = null;
        this.dupPasswordLabel = null;
        this.dupPasswordField = null;
        this.emailTitle = null;
        this.newEmailLabel = null;
        this.newEmailField = null;
        this.setLayout(null);
        super.removeNotify();
    }

    public boolean save() {
        String string = this.nicknameField.getText();
        if (string != null && string.length() > 0) {
            this.config.setValue(LoginCore.NICKNAME_KEY, string);
        } else {
            this.config.deleteKey(LoginCore.NICKNAME_KEY);
        }
        String string2 = this.passwordField.getPassword();
        if (string2 != null && string2.length() > 0) {
            JUtil.putPassword(this.config, string2, LoginCore.PASSWORD_KEY);
        } else {
            this.config.deleteKey(LoginCore.PASSWORD_KEY);
        }
        this.login.setNameAndPassword(string, string2);
        this.setChanged(false);
        return true;
    }

    private void setChanged(boolean bl) {
        this.changed = bl;
        if (bl) {
            this.changeListener.setChanged(true);
        }
    }

    public void setValues() {
        String string = this.config.getValue(LoginCore.NICKNAME_KEY);
        String string2 = JUtil.getPassword(this.config, LoginCore.PASSWORD_KEY);
        if (string != null) {
            ((TextComponent)this.nicknameField).setText(string);
        }
        if (string2 != null) {
            this.passwordField.setPassword(string2);
        }
        this.setChanged(false);
    }
}

