/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.DispatcherListener;
import snac.IcbmListener;
import snac.Listener;
import snac.SNACHeader;
import snac.SnacHandler;
import snac.SnacIcbmCookie;
import snac.SnacIcbmMissedCall;
import snac.SnacNickname;
import snac.SnacNicknameWinfo;
import snac.SnacTlv;
import snac.TLV;
import uiutil.ErrorMgr;
import util.JUtil;
import util.Log;
import util.OutputBuffer;

public class IcbmHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public IcbmHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(4, 1, this);
    }

    public void addParameters(FLAPSock fLAPSock, IcbmListener icbmListener, Object object, int n, byte[] byArray, int n2, int n3, int n4, long l) {
        Log.log(MODULE, Log.DB1, "writing icbmAddParameters SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.d.writeShort(n);
            if (byArray.length < 4) {
                throw new IOException("write underflow");
            }
            if (byArray.length > 4) {
                throw new IOException("write overflow");
            }
            outputBuffer.d.write(byArray, 0, byArray.length);
            outputBuffer.d.writeShort(n2);
            outputBuffer.d.writeShort(n3);
            outputBuffer.d.writeShort(n4);
            outputBuffer.d.writeInt((int)l);
            this.dispatcher.queueOutput(fLAPSock, icbmListener, object, 4, 2, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmAddParameters " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void deleteParameters(FLAPSock fLAPSock, IcbmListener icbmListener, Object object, int n) {
        Log.log(MODULE, Log.DB1, "writing icbmDeleteParameters SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.d.writeShort(n);
            this.dispatcher.queueOutput(fLAPSock, icbmListener, object, 4, 3, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmDeleteParameters " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void parameterQuery(FLAPSock fLAPSock, IcbmListener icbmListener, Object object) {
        Log.log(MODULE, Log.DB1, "writing icbmParameterQuery SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            this.dispatcher.queueOutput(fLAPSock, icbmListener, object, 4, 4, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmParameterQuery " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeParameterReply(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got icbmParameterReply SNAC");
        IcbmListener icbmListener = (IcbmListener)listener;
        try {
            int n = dataInputStream.readUnsignedShort();
            int n2 = dataInputStream.available();
            if (n2 < 4) {
                throw new IOException("read underflow");
            }
            byte[] byArray = new byte[4];
            dataInputStream.read(byArray, 0, 4);
            int n3 = dataInputStream.readUnsignedShort();
            int n4 = dataInputStream.readUnsignedShort();
            int n5 = dataInputStream.readUnsignedShort();
            long l = JUtil.readU32(dataInputStream);
            int n6 = this.initHandledState();
            if (icbmListener != null) {
                n6 = this.updateHandledState(n6, icbmListener.icbmParameterReply(fLAPSock, object, sNACHeader.reqID, n6, n, byArray, n3, n4, n5, l));
            }
            int n7 = 0;
            while (vector != null) {
                if (n7 >= vector.size()) return;
                if (!this.proceed(n6)) {
                    return;
                }
                IcbmListener icbmListener2 = (IcbmListener)vector.elementAt(n7);
                if (icbmListener2 != icbmListener) {
                    n6 = this.updateHandledState(n6, icbmListener2.icbmParameterReply(fLAPSock, object, sNACHeader.reqID, n6, n, byArray, n3, n4, n5, l));
                }
                ++n7;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmParameterReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void channelMsgTohost(FLAPSock fLAPSock, IcbmListener icbmListener, Object object, SnacIcbmCookie snacIcbmCookie, int n, SnacNickname snacNickname, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing icbmChannelMsgTohost SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            snacIcbmCookie.write(outputBuffer.d);
            outputBuffer.d.writeShort(n);
            snacNickname.write(outputBuffer.d);
            int n2 = 0;
            while (n2 < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n2)).write(outputBuffer.d);
                ++n2;
            }
            this.dispatcher.queueOutput(fLAPSock, icbmListener, object, 4, 6, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmChannelMsgTohost " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeChannelMsgToclient(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got icbmChannelMsgToclient SNAC");
        IcbmListener icbmListener = (IcbmListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                SnacNicknameWinfo snacNicknameWinfo;
                int n3;
                SnacIcbmCookie snacIcbmCookie;
                block7: {
                    snacIcbmCookie = new SnacIcbmCookie(dataInputStream);
                    n3 = dataInputStream.readUnsignedShort();
                    snacNicknameWinfo = new SnacNicknameWinfo(dataInputStream);
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (icbmListener != null) {
                        n2 = this.updateHandledState(n2, icbmListener.icbmChannelMsgToclient(fLAPSock, object, sNACHeader.reqID, n2, snacIcbmCookie, n3, snacNicknameWinfo, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    IcbmListener icbmListener2;
                    if ((icbmListener2 = (IcbmListener)vector.elementAt(n)) != icbmListener) {
                        n2 = this.updateHandledState(n2, icbmListener2.icbmChannelMsgToclient(fLAPSock, object, sNACHeader.reqID, n2, snacIcbmCookie, n3, snacNicknameWinfo, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmChannelMsgToclient " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void evilRequest(FLAPSock fLAPSock, IcbmListener icbmListener, Object object, int n, SnacNickname snacNickname) {
        Log.log(MODULE, Log.DB1, "writing icbmEvilRequest SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.d.writeShort(n);
            snacNickname.write(outputBuffer.d);
            this.dispatcher.queueOutput(fLAPSock, icbmListener, object, 4, 8, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmEvilRequest " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeEvilReply(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got icbmEvilReply SNAC");
        IcbmListener icbmListener = (IcbmListener)listener;
        try {
            int n = dataInputStream.readUnsignedShort();
            int n2 = dataInputStream.readUnsignedShort();
            int n3 = this.initHandledState();
            if (icbmListener != null) {
                n3 = this.updateHandledState(n3, icbmListener.icbmEvilReply(fLAPSock, object, sNACHeader.reqID, n3, n, n2));
            }
            int n4 = 0;
            while (vector != null) {
                if (n4 >= vector.size()) return;
                if (!this.proceed(n3)) {
                    return;
                }
                IcbmListener icbmListener2 = (IcbmListener)vector.elementAt(n4);
                if (icbmListener2 != icbmListener) {
                    n3 = this.updateHandledState(n3, icbmListener2.icbmEvilReply(fLAPSock, object, sNACHeader.reqID, n3, n, n2));
                }
                ++n4;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmEvilReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeMissedCalls(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got icbmMissedCalls SNAC");
        IcbmListener icbmListener = (IcbmListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacIcbmMissedCall> vector2;
                block7: {
                    vector2 = new Vector<SnacIcbmMissedCall>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacIcbmMissedCall(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (icbmListener != null) {
                        n2 = this.updateHandledState(n2, icbmListener.icbmMissedCalls(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    IcbmListener icbmListener2;
                    if ((icbmListener2 = (IcbmListener)vector.elementAt(n)) != icbmListener) {
                        n2 = this.updateHandledState(n2, icbmListener2.icbmMissedCalls(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmMissedCalls " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void clientErr(FLAPSock fLAPSock, IcbmListener icbmListener, Object object, SnacIcbmCookie snacIcbmCookie, int n, SnacNickname snacNickname, int n2, byte[] byArray) {
        Log.log(MODULE, Log.DB1, "writing icbmClientErr SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            snacIcbmCookie.write(outputBuffer.d);
            outputBuffer.d.writeShort(n);
            snacNickname.write(outputBuffer.d);
            outputBuffer.d.writeShort(n2);
            if (byArray.length < 0) {
                throw new IOException("write underflow");
            }
            if (byArray.length > 8192) {
                throw new IOException("write overflow");
            }
            outputBuffer.d.write(byArray, 0, byArray.length);
            this.dispatcher.queueOutput(fLAPSock, icbmListener, object, 4, 11, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmClientErr " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeClientErr(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got icbmClientErr SNAC");
        IcbmListener icbmListener = (IcbmListener)listener;
        try {
            SnacIcbmCookie snacIcbmCookie = new SnacIcbmCookie(dataInputStream);
            int n = dataInputStream.readUnsignedShort();
            SnacNickname snacNickname = new SnacNickname(dataInputStream);
            int n2 = dataInputStream.readUnsignedShort();
            int n3 = dataInputStream.available();
            if (n3 > 8192) {
                throw new IOException("read overflow");
            }
            if (n3 < 0) {
                throw new IOException("read underflow");
            }
            byte[] byArray = new byte[n3];
            if (n3 > 0) {
                dataInputStream.read(byArray, 0, n3);
            }
            int n4 = this.initHandledState();
            if (icbmListener != null) {
                n4 = this.updateHandledState(n4, icbmListener.icbmClientErr(fLAPSock, object, sNACHeader.reqID, n4, snacIcbmCookie, n, snacNickname, n2, byArray));
            }
            int n5 = 0;
            while (vector != null) {
                if (n5 >= vector.size()) return;
                if (!this.proceed(n4)) {
                    return;
                }
                IcbmListener icbmListener2 = (IcbmListener)vector.elementAt(n5);
                if (icbmListener2 != icbmListener) {
                    n4 = this.updateHandledState(n4, icbmListener2.icbmClientErr(fLAPSock, object, sNACHeader.reqID, n4, snacIcbmCookie, n, snacNickname, n2, byArray));
                }
                ++n5;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmClientErr " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeHostAck(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got icbmHostAck SNAC");
        IcbmListener icbmListener = (IcbmListener)listener;
        try {
            SnacIcbmCookie snacIcbmCookie = new SnacIcbmCookie(dataInputStream);
            int n = dataInputStream.readUnsignedShort();
            SnacNickname snacNickname = new SnacNickname(dataInputStream);
            int n2 = this.initHandledState();
            if (icbmListener != null) {
                n2 = this.updateHandledState(n2, icbmListener.icbmHostAck(fLAPSock, object, sNACHeader.reqID, n2, snacIcbmCookie, n, snacNickname));
            }
            int n3 = 0;
            while (vector != null) {
                if (n3 >= vector.size()) return;
                if (!this.proceed(n2)) {
                    return;
                }
                IcbmListener icbmListener2 = (IcbmListener)vector.elementAt(n3);
                if (icbmListener2 != icbmListener) {
                    n2 = this.updateHandledState(n2, icbmListener2.icbmHostAck(fLAPSock, object, sNACHeader.reqID, n2, snacIcbmCookie, n, snacNickname));
                }
                ++n3;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmHostAck " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 5) {
            this.decodeParameterReply(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 7) {
            this.decodeChannelMsgToclient(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 9) {
            this.decodeEvilReply(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 10) {
            this.decodeMissedCalls(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 11) {
            this.decodeClientErr(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 12) {
            this.decodeHostAck(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("Icbm", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

