/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.DispatcherListener;
import snac.IcbmHostListener;
import snac.Listener;
import snac.SNACHeader;
import snac.SnacHandler;
import snac.SnacIcbmCookie;
import snac.SnacIcbmMissedCall;
import snac.SnacNickname;
import snac.SnacNicknameWinfo;
import snac.SnacTlv;
import snac.TLV;
import uiutil.ErrorMgr;
import util.JUtil;
import util.Log;
import util.OutputBuffer;

public class IcbmHostHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public IcbmHostHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(4, 1, this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeAddParameters(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got icbmAddParameters SNAC");
        IcbmHostListener icbmHostListener = (IcbmHostListener)listener;
        try {
            int n = dataInputStream.readUnsignedShort();
            int n2 = dataInputStream.available();
            if (n2 < 4) {
                throw new IOException("read underflow");
            }
            byte[] byArray = new byte[4];
            dataInputStream.read(byArray, 0, 4);
            int n3 = dataInputStream.readUnsignedShort();
            int n4 = dataInputStream.readUnsignedShort();
            int n5 = dataInputStream.readUnsignedShort();
            long l = JUtil.readU32(dataInputStream);
            int n6 = this.initHandledState();
            if (icbmHostListener != null) {
                n6 = this.updateHandledState(n6, icbmHostListener.icbmAddParameters(fLAPSock, object, sNACHeader.reqID, n6, n, byArray, n3, n4, n5, l));
            }
            int n7 = 0;
            while (vector != null) {
                if (n7 >= vector.size()) return;
                if (!this.proceed(n6)) {
                    return;
                }
                IcbmHostListener icbmHostListener2 = (IcbmHostListener)vector.elementAt(n7);
                if (icbmHostListener2 != icbmHostListener) {
                    n6 = this.updateHandledState(n6, icbmHostListener2.icbmAddParameters(fLAPSock, object, sNACHeader.reqID, n6, n, byArray, n3, n4, n5, l));
                }
                ++n7;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmAddParameters " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeDeleteParameters(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got icbmDeleteParameters SNAC");
        IcbmHostListener icbmHostListener = (IcbmHostListener)listener;
        try {
            int n = dataInputStream.readUnsignedShort();
            int n2 = this.initHandledState();
            if (icbmHostListener != null) {
                n2 = this.updateHandledState(n2, icbmHostListener.icbmDeleteParameters(fLAPSock, object, sNACHeader.reqID, n2, n));
            }
            int n3 = 0;
            while (vector != null) {
                if (n3 >= vector.size()) return;
                if (!this.proceed(n2)) {
                    return;
                }
                IcbmHostListener icbmHostListener2 = (IcbmHostListener)vector.elementAt(n3);
                if (icbmHostListener2 != icbmHostListener) {
                    n2 = this.updateHandledState(n2, icbmHostListener2.icbmDeleteParameters(fLAPSock, object, sNACHeader.reqID, n2, n));
                }
                ++n3;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmDeleteParameters " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    private void decodeParameterQuery(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got icbmParameterQuery SNAC");
        IcbmHostListener icbmHostListener = (IcbmHostListener)listener;
        int n = this.initHandledState();
        if (icbmHostListener != null) {
            n = this.updateHandledState(n, icbmHostListener.icbmParameterQuery(fLAPSock, object, sNACHeader.reqID, n));
        }
        int n2 = 0;
        while (vector != null && n2 < vector.size() && this.proceed(n)) {
            IcbmHostListener icbmHostListener2 = (IcbmHostListener)vector.elementAt(n2);
            if (icbmHostListener2 != icbmHostListener) {
                n = this.updateHandledState(n, icbmHostListener2.icbmParameterQuery(fLAPSock, object, sNACHeader.reqID, n));
            }
            ++n2;
        }
    }

    public void parameterReply(FLAPSock fLAPSock, IcbmHostListener icbmHostListener, Object object, int n, byte[] byArray, int n2, int n3, int n4, long l) {
        Log.log(MODULE, Log.DB1, "writing icbmParameterReply SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.d.writeShort(n);
            if (byArray.length < 4) {
                throw new IOException("write underflow");
            }
            if (byArray.length > 4) {
                throw new IOException("write overflow");
            }
            outputBuffer.d.write(byArray, 0, byArray.length);
            outputBuffer.d.writeShort(n2);
            outputBuffer.d.writeShort(n3);
            outputBuffer.d.writeShort(n4);
            outputBuffer.d.writeInt((int)l);
            this.dispatcher.queueOutput(fLAPSock, icbmHostListener, object, 4, 5, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmParameterReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeChannelMsgTohost(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got icbmChannelMsgTohost SNAC");
        IcbmHostListener icbmHostListener = (IcbmHostListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                SnacNickname snacNickname;
                int n3;
                SnacIcbmCookie snacIcbmCookie;
                block7: {
                    snacIcbmCookie = new SnacIcbmCookie(dataInputStream);
                    n3 = dataInputStream.readUnsignedShort();
                    snacNickname = new SnacNickname(dataInputStream);
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (icbmHostListener != null) {
                        n2 = this.updateHandledState(n2, icbmHostListener.icbmChannelMsgTohost(fLAPSock, object, sNACHeader.reqID, n2, snacIcbmCookie, n3, snacNickname, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    IcbmHostListener icbmHostListener2;
                    if ((icbmHostListener2 = (IcbmHostListener)vector.elementAt(n)) != icbmHostListener) {
                        n2 = this.updateHandledState(n2, icbmHostListener2.icbmChannelMsgTohost(fLAPSock, object, sNACHeader.reqID, n2, snacIcbmCookie, n3, snacNickname, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmChannelMsgTohost " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void channelMsgToclient(FLAPSock fLAPSock, IcbmHostListener icbmHostListener, Object object, SnacIcbmCookie snacIcbmCookie, int n, SnacNicknameWinfo snacNicknameWinfo, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing icbmChannelMsgToclient SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            snacIcbmCookie.write(outputBuffer.d);
            outputBuffer.d.writeShort(n);
            snacNicknameWinfo.write(outputBuffer.d);
            int n2 = 0;
            while (n2 < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n2)).write(outputBuffer.d);
                ++n2;
            }
            this.dispatcher.queueOutput(fLAPSock, icbmHostListener, object, 4, 7, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmChannelMsgToclient " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeEvilRequest(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got icbmEvilRequest SNAC");
        IcbmHostListener icbmHostListener = (IcbmHostListener)listener;
        try {
            int n = dataInputStream.readUnsignedShort();
            SnacNickname snacNickname = new SnacNickname(dataInputStream);
            int n2 = this.initHandledState();
            if (icbmHostListener != null) {
                n2 = this.updateHandledState(n2, icbmHostListener.icbmEvilRequest(fLAPSock, object, sNACHeader.reqID, n2, n, snacNickname));
            }
            int n3 = 0;
            while (vector != null) {
                if (n3 >= vector.size()) return;
                if (!this.proceed(n2)) {
                    return;
                }
                IcbmHostListener icbmHostListener2 = (IcbmHostListener)vector.elementAt(n3);
                if (icbmHostListener2 != icbmHostListener) {
                    n2 = this.updateHandledState(n2, icbmHostListener2.icbmEvilRequest(fLAPSock, object, sNACHeader.reqID, n2, n, snacNickname));
                }
                ++n3;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmEvilRequest " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void evilReply(FLAPSock fLAPSock, IcbmHostListener icbmHostListener, Object object, int n, int n2) {
        Log.log(MODULE, Log.DB1, "writing icbmEvilReply SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.d.writeShort(n);
            outputBuffer.d.writeShort(n2);
            this.dispatcher.queueOutput(fLAPSock, icbmHostListener, object, 4, 9, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmEvilReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void missedCalls(FLAPSock fLAPSock, IcbmHostListener icbmHostListener, Object object, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing icbmMissedCalls SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < vector.size()) {
                ((SnacIcbmMissedCall)vector.elementAt(n)).write(outputBuffer.d);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, icbmHostListener, object, 4, 10, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmMissedCalls " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void clientErr(FLAPSock fLAPSock, IcbmHostListener icbmHostListener, Object object, SnacIcbmCookie snacIcbmCookie, int n, SnacNickname snacNickname, int n2, byte[] byArray) {
        Log.log(MODULE, Log.DB1, "writing icbmClientErr SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            snacIcbmCookie.write(outputBuffer.d);
            outputBuffer.d.writeShort(n);
            snacNickname.write(outputBuffer.d);
            outputBuffer.d.writeShort(n2);
            if (byArray.length < 0) {
                throw new IOException("write underflow");
            }
            if (byArray.length > 8192) {
                throw new IOException("write overflow");
            }
            outputBuffer.d.write(byArray, 0, byArray.length);
            this.dispatcher.queueOutput(fLAPSock, icbmHostListener, object, 4, 11, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmClientErr " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeClientErr(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got icbmClientErr SNAC");
        IcbmHostListener icbmHostListener = (IcbmHostListener)listener;
        try {
            SnacIcbmCookie snacIcbmCookie = new SnacIcbmCookie(dataInputStream);
            int n = dataInputStream.readUnsignedShort();
            SnacNickname snacNickname = new SnacNickname(dataInputStream);
            int n2 = dataInputStream.readUnsignedShort();
            int n3 = dataInputStream.available();
            if (n3 > 8192) {
                throw new IOException("read overflow");
            }
            if (n3 < 0) {
                throw new IOException("read underflow");
            }
            byte[] byArray = new byte[n3];
            if (n3 > 0) {
                dataInputStream.read(byArray, 0, n3);
            }
            int n4 = this.initHandledState();
            if (icbmHostListener != null) {
                n4 = this.updateHandledState(n4, icbmHostListener.icbmClientErr(fLAPSock, object, sNACHeader.reqID, n4, snacIcbmCookie, n, snacNickname, n2, byArray));
            }
            int n5 = 0;
            while (vector != null) {
                if (n5 >= vector.size()) return;
                if (!this.proceed(n4)) {
                    return;
                }
                IcbmHostListener icbmHostListener2 = (IcbmHostListener)vector.elementAt(n5);
                if (icbmHostListener2 != icbmHostListener) {
                    n4 = this.updateHandledState(n4, icbmHostListener2.icbmClientErr(fLAPSock, object, sNACHeader.reqID, n4, snacIcbmCookie, n, snacNickname, n2, byArray));
                }
                ++n5;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmClientErr " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void hostAck(FLAPSock fLAPSock, IcbmHostListener icbmHostListener, Object object, SnacIcbmCookie snacIcbmCookie, int n, SnacNickname snacNickname) {
        Log.log(MODULE, Log.DB1, "writing icbmHostAck SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            snacIcbmCookie.write(outputBuffer.d);
            outputBuffer.d.writeShort(n);
            snacNickname.write(outputBuffer.d);
            this.dispatcher.queueOutput(fLAPSock, icbmHostListener, object, 4, 12, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Icbm", "got IOException in icbmHostAck " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 2) {
            this.decodeAddParameters(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 3) {
            this.decodeDeleteParameters(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 4) {
            this.decodeParameterQuery(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 6) {
            this.decodeChannelMsgTohost(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 8) {
            this.decodeEvilRequest(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 11) {
            this.decodeClientErr(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("Icbm", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

