/*
 * Decompiled with CFR 0.152.
 */
package snac;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import snac.ReqID;
import snac.TLV;
import util.Log;
import util.OutputBuffer;

public class SNACHeader {
    private static final String MODULE = "SNAC";
    public static int SNAC_HEADER_LEN = 10;
    public int family;
    public int subtype;
    public byte[] flags;
    public ReqID reqID;
    public TLV tlv;

    public SNACHeader(DataInputStream dataInputStream) throws IOException {
        this.family = dataInputStream.readShort();
        this.subtype = dataInputStream.readShort();
        this.flags = new byte[2];
        dataInputStream.read(this.flags, 0, 2);
        this.reqID = new ReqID(dataInputStream);
        if ((this.flags[1] & 0xFFFFFF80) != 0) {
            short s = dataInputStream.readShort();
            TLV tLV = new TLV();
            tLV.readTlvVector(dataInputStream, s);
        }
        Log.log(MODULE, Log.DB1, "read " + this.toString());
    }

    public SNACHeader(int n, int n2, ReqID reqID, TLV tLV) {
        this.family = n;
        this.subtype = n2;
        this.flags = new byte[2];
        this.flags[0] = 0;
        this.flags[1] = tLV != null ? -128 : 0;
        this.reqID = reqID;
        this.tlv = tLV;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.family);
        dataOutputStream.writeShort(this.subtype);
        dataOutputStream.write(this.flags, 0, 2);
        if (this.reqID != null) {
            this.reqID.write(dataOutputStream);
        }
        if (this.tlv != null) {
            this.tlv.writeTlvVector(dataOutputStream);
        }
        Log.log(MODULE, Log.DB1, "wrote " + this.toString());
    }

    public byte[] bytes() throws IOException {
        OutputBuffer outputBuffer = new OutputBuffer(SNAC_HEADER_LEN);
        this.write(outputBuffer.d);
        return outputBuffer.bytes();
    }

    public String toString() {
        String string = "no ReqID";
        if (this.reqID != null) {
            string = this.reqID.toString();
        }
        int n = (this.flags[1] << 8) + this.flags[0];
        String string2 = "no TLV elements";
        if (this.tlv != null) {
            string2 = this.tlv.size() + " TLV elements";
        }
        return "SNACHeader: family " + this.family + " subtype " + this.subtype + " flags " + Integer.toHexString(n) + " " + string + " " + string2;
    }
}

