/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.DispatcherListener;
import snac.Listener;
import snac.SNACHeader;
import snac.ServiceHostListener;
import snac.SnacHandler;
import snac.SnacNicknameWinfo;
import snac.SnacRateClassMembers;
import snac.SnacRateParameters;
import snac.SnacTlv;
import snac.SnacVersion;
import snac.TLV;
import uiutil.ErrorMgr;
import util.JUtil;
import util.Log;
import util.OutputBuffer;

public class ServiceHostHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public ServiceHostHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(1, 1, this);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeClientOnline(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got serviceClientOnline SNAC");
        ServiceHostListener serviceHostListener = (ServiceHostListener)listener;
        try {
            block8: {
                int n;
                int n2;
                Vector<SnacVersion> vector2;
                block7: {
                    vector2 = new Vector<SnacVersion>();
                    while (dataInputStream.available() > 0) {
                        vector2.addElement(new SnacVersion(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (serviceHostListener != null) {
                        n2 = this.updateHandledState(n2, serviceHostListener.serviceClientOnline(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    ServiceHostListener serviceHostListener2;
                    if ((serviceHostListener2 = (ServiceHostListener)vector.elementAt(n)) != serviceHostListener) {
                        n2 = this.updateHandledState(n2, serviceHostListener2.serviceClientOnline(fLAPSock, object, sNACHeader.reqID, n2, vector2));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceClientOnline " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void hostOnline(FLAPSock fLAPSock, ServiceHostListener serviceHostListener, Object object, int[] nArray) {
        Log.log(MODULE, Log.DB1, "writing serviceHostOnline SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            if (nArray.length * 2 < 0) {
                throw new IOException("write underflow");
            }
            if (nArray.length * 2 > 8192) {
                throw new IOException("write overflow");
            }
            int n = 0;
            while (n < nArray.length) {
                outputBuffer.d.writeShort(nArray[n]);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, serviceHostListener, object, 1, 3, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceHostOnline " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeServiceRequest(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got serviceServiceRequest SNAC");
        ServiceHostListener serviceHostListener = (ServiceHostListener)listener;
        try {
            block8: {
                int n;
                int n2;
                TLV tLV;
                int n3;
                block7: {
                    n3 = dataInputStream.readUnsignedShort();
                    tLV = new TLV();
                    while (dataInputStream.available() > 0) {
                        tLV.addElement(new SnacTlv(dataInputStream));
                    }
                    n2 = this.initHandledState();
                    if (serviceHostListener != null) {
                        n2 = this.updateHandledState(n2, serviceHostListener.serviceServiceRequest(fLAPSock, object, sNACHeader.reqID, n2, n3, tLV));
                    }
                    n = 0;
                    if (!true) break block7;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                    if (!this.proceed(n2)) break block8;
                }
                do {
                    ServiceHostListener serviceHostListener2;
                    if ((serviceHostListener2 = (ServiceHostListener)vector.elementAt(n)) != serviceHostListener) {
                        n2 = this.updateHandledState(n2, serviceHostListener2.serviceServiceRequest(fLAPSock, object, sNACHeader.reqID, n2, n3, tLV));
                    }
                    ++n;
                    if (vector == null) return;
                    if (n >= vector.size()) return;
                } while (this.proceed(n2));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceServiceRequest " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void serviceResponse(FLAPSock fLAPSock, ServiceHostListener serviceHostListener, Object object, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing serviceServiceResponse SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n)).write(outputBuffer.d);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, serviceHostListener, object, 1, 5, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceServiceResponse " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    private void decodeRateParamsQuery(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got serviceRateParamsQuery SNAC");
        ServiceHostListener serviceHostListener = (ServiceHostListener)listener;
        int n = this.initHandledState();
        if (serviceHostListener != null) {
            n = this.updateHandledState(n, serviceHostListener.serviceRateParamsQuery(fLAPSock, object, sNACHeader.reqID, n));
        }
        int n2 = 0;
        while (vector != null && n2 < vector.size() && this.proceed(n)) {
            ServiceHostListener serviceHostListener2 = (ServiceHostListener)vector.elementAt(n2);
            if (serviceHostListener2 != serviceHostListener) {
                n = this.updateHandledState(n, serviceHostListener2.serviceRateParamsQuery(fLAPSock, object, sNACHeader.reqID, n));
            }
            ++n2;
        }
    }

    public void rateParamsReply(FLAPSock fLAPSock, ServiceHostListener serviceHostListener, Object object, int n, Vector vector, Vector vector2) {
        Log.log(MODULE, Log.DB1, "writing serviceRateParamsReply SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.d.writeShort(n);
            int n2 = 0;
            while (n2 < n && n2 < vector.size()) {
                ((SnacRateParameters)vector.elementAt(n2)).write(outputBuffer.d);
                ++n2;
            }
            n2 = 0;
            while (n2 < n && n2 < vector2.size()) {
                ((SnacRateClassMembers)vector2.elementAt(n2)).write(outputBuffer.d);
                ++n2;
            }
            this.dispatcher.queueOutput(fLAPSock, serviceHostListener, object, 1, 7, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceRateParamsReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeRateAddParamSub(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got serviceRateAddParamSub SNAC");
        ServiceHostListener serviceHostListener = (ServiceHostListener)listener;
        try {
            block10: {
                int n;
                int n2;
                int[] nArray;
                block9: {
                    int n3 = dataInputStream.available();
                    if (n3 > 8192) {
                        throw new IOException("read overflow");
                    }
                    if (n3 / 2 < 0) {
                        throw new IOException("read underflow");
                    }
                    nArray = new int[n3 / 2];
                    n2 = 0;
                    while (n2 < n3 / 2) {
                        nArray[n2] = dataInputStream.readUnsignedShort();
                        ++n2;
                    }
                    n = this.initHandledState();
                    if (serviceHostListener != null) {
                        n = this.updateHandledState(n, serviceHostListener.serviceRateAddParamSub(fLAPSock, object, sNACHeader.reqID, n, nArray));
                    }
                    n2 = 0;
                    if (!true) break block9;
                    if (vector == null) return;
                    if (n2 >= vector.size()) return;
                    if (!this.proceed(n)) break block10;
                }
                do {
                    ServiceHostListener serviceHostListener2;
                    if ((serviceHostListener2 = (ServiceHostListener)vector.elementAt(n2)) != serviceHostListener) {
                        n = this.updateHandledState(n, serviceHostListener2.serviceRateAddParamSub(fLAPSock, object, sNACHeader.reqID, n, nArray));
                    }
                    ++n2;
                    if (vector == null) return;
                    if (n2 >= vector.size()) return;
                } while (this.proceed(n));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceRateAddParamSub " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeRateDelParamSub(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got serviceRateDelParamSub SNAC");
        ServiceHostListener serviceHostListener = (ServiceHostListener)listener;
        try {
            block10: {
                int n;
                int n2;
                int[] nArray;
                block9: {
                    int n3 = dataInputStream.available();
                    if (n3 > 8192) {
                        throw new IOException("read overflow");
                    }
                    if (n3 / 2 < 0) {
                        throw new IOException("read underflow");
                    }
                    nArray = new int[n3 / 2];
                    n2 = 0;
                    while (n2 < n3 / 2) {
                        nArray[n2] = dataInputStream.readUnsignedShort();
                        ++n2;
                    }
                    n = this.initHandledState();
                    if (serviceHostListener != null) {
                        n = this.updateHandledState(n, serviceHostListener.serviceRateDelParamSub(fLAPSock, object, sNACHeader.reqID, n, nArray));
                    }
                    n2 = 0;
                    if (!true) break block9;
                    if (vector == null) return;
                    if (n2 >= vector.size()) return;
                    if (!this.proceed(n)) break block10;
                }
                do {
                    ServiceHostListener serviceHostListener2;
                    if ((serviceHostListener2 = (ServiceHostListener)vector.elementAt(n2)) != serviceHostListener) {
                        n = this.updateHandledState(n, serviceHostListener2.serviceRateDelParamSub(fLAPSock, object, sNACHeader.reqID, n, nArray));
                    }
                    ++n2;
                    if (vector == null) return;
                    if (n2 >= vector.size()) return;
                } while (this.proceed(n));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceRateDelParamSub " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void rateParamChange(FLAPSock fLAPSock, ServiceHostListener serviceHostListener, Object object, int n, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing serviceRateParamChange SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.d.writeShort(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                ((SnacRateParameters)vector.elementAt(n2)).write(outputBuffer.d);
                ++n2;
            }
            this.dispatcher.queueOutput(fLAPSock, serviceHostListener, object, 1, 10, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceRateParamChange " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void pause(FLAPSock fLAPSock, ServiceHostListener serviceHostListener, Object object, int[] nArray) {
        Log.log(MODULE, Log.DB1, "writing servicePause SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            if (nArray.length * 2 < 0) {
                throw new IOException("write underflow");
            }
            if (nArray.length * 2 > 8192) {
                throw new IOException("write overflow");
            }
            int n = 0;
            while (n < nArray.length) {
                outputBuffer.d.writeShort(nArray[n]);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, serviceHostListener, object, 1, 11, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in servicePause " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodePauseAck(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got servicePauseAck SNAC");
        ServiceHostListener serviceHostListener = (ServiceHostListener)listener;
        try {
            block10: {
                int n;
                int n2;
                int[] nArray;
                block9: {
                    int n3 = dataInputStream.available();
                    if (n3 > 8192) {
                        throw new IOException("read overflow");
                    }
                    if (n3 / 2 < 0) {
                        throw new IOException("read underflow");
                    }
                    nArray = new int[n3 / 2];
                    n2 = 0;
                    while (n2 < n3 / 2) {
                        nArray[n2] = dataInputStream.readUnsignedShort();
                        ++n2;
                    }
                    n = this.initHandledState();
                    if (serviceHostListener != null) {
                        n = this.updateHandledState(n, serviceHostListener.servicePauseAck(fLAPSock, object, sNACHeader.reqID, n, nArray));
                    }
                    n2 = 0;
                    if (!true) break block9;
                    if (vector == null) return;
                    if (n2 >= vector.size()) return;
                    if (!this.proceed(n)) break block10;
                }
                do {
                    ServiceHostListener serviceHostListener2;
                    if ((serviceHostListener2 = (ServiceHostListener)vector.elementAt(n2)) != serviceHostListener) {
                        n = this.updateHandledState(n, serviceHostListener2.servicePauseAck(fLAPSock, object, sNACHeader.reqID, n, nArray));
                    }
                    ++n2;
                    if (vector == null) return;
                    if (n2 >= vector.size()) return;
                } while (this.proceed(n));
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in servicePauseAck " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void resume(FLAPSock fLAPSock, ServiceHostListener serviceHostListener, Object object, int[] nArray) {
        Log.log(MODULE, Log.DB1, "writing serviceResume SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            if (nArray.length * 2 < 0) {
                throw new IOException("write underflow");
            }
            if (nArray.length * 2 > 8192) {
                throw new IOException("write overflow");
            }
            int n = 0;
            while (n < nArray.length) {
                outputBuffer.d.writeShort(nArray[n]);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, serviceHostListener, object, 1, 13, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceResume " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    private void decodeNickInfoQuery(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got serviceNickInfoQuery SNAC");
        ServiceHostListener serviceHostListener = (ServiceHostListener)listener;
        int n = this.initHandledState();
        if (serviceHostListener != null) {
            n = this.updateHandledState(n, serviceHostListener.serviceNickInfoQuery(fLAPSock, object, sNACHeader.reqID, n));
        }
        int n2 = 0;
        while (vector != null && n2 < vector.size() && this.proceed(n)) {
            ServiceHostListener serviceHostListener2 = (ServiceHostListener)vector.elementAt(n2);
            if (serviceHostListener2 != serviceHostListener) {
                n = this.updateHandledState(n, serviceHostListener2.serviceNickInfoQuery(fLAPSock, object, sNACHeader.reqID, n));
            }
            ++n2;
        }
    }

    public void nickInfoReply(FLAPSock fLAPSock, ServiceHostListener serviceHostListener, Object object, SnacNicknameWinfo snacNicknameWinfo) {
        Log.log(MODULE, Log.DB1, "writing serviceNickInfoReply SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            snacNicknameWinfo.write(outputBuffer.d);
            this.dispatcher.queueOutput(fLAPSock, serviceHostListener, object, 1, 15, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceNickInfoReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void evilNotification(FLAPSock fLAPSock, ServiceHostListener serviceHostListener, Object object, int n, Vector vector) {
        Log.log(MODULE, Log.DB1, "writing serviceEvilNotification SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.d.writeShort(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                ((SnacNicknameWinfo)vector.elementAt(n2)).write(outputBuffer.d);
                ++n2;
            }
            this.dispatcher.queueOutput(fLAPSock, serviceHostListener, object, 1, 16, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceEvilNotification " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeIdleNotification(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got serviceIdleNotification SNAC");
        ServiceHostListener serviceHostListener = (ServiceHostListener)listener;
        try {
            long l = JUtil.readU32(dataInputStream);
            int n = this.initHandledState();
            if (serviceHostListener != null) {
                n = this.updateHandledState(n, serviceHostListener.serviceIdleNotification(fLAPSock, object, sNACHeader.reqID, n, l));
            }
            int n2 = 0;
            while (vector != null) {
                if (n2 >= vector.size()) return;
                if (!this.proceed(n)) {
                    return;
                }
                ServiceHostListener serviceHostListener2 = (ServiceHostListener)vector.elementAt(n2);
                if (serviceHostListener2 != serviceHostListener) {
                    n = this.updateHandledState(n, serviceHostListener2.serviceIdleNotification(fLAPSock, object, sNACHeader.reqID, n, l));
                }
                ++n2;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceIdleNotification " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void migrateGroups(FLAPSock fLAPSock, ServiceHostListener serviceHostListener, Object object, int n, int[] nArray, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing serviceMigrateGroups SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.d.writeShort(n);
            if (nArray.length * 2 < n) {
                throw new IOException("write underflow");
            }
            if (nArray.length * 2 > n) {
                throw new IOException("write overflow");
            }
            int n2 = 0;
            while (n2 < nArray.length) {
                outputBuffer.d.writeShort(nArray[n2]);
                ++n2;
            }
            n2 = 0;
            while (n2 < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n2)).write(outputBuffer.d);
                ++n2;
            }
            this.dispatcher.queueOutput(fLAPSock, serviceHostListener, object, 1, 18, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceMigrateGroups " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void motd(FLAPSock fLAPSock, ServiceHostListener serviceHostListener, Object object, int n, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing serviceMotd SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            outputBuffer.d.writeShort(n);
            int n2 = 0;
            while (n2 < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n2)).write(outputBuffer.d);
                ++n2;
            }
            this.dispatcher.queueOutput(fLAPSock, serviceHostListener, object, 1, 19, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceMotd " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeSetPrivacyFlags(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got serviceSetPrivacyFlags SNAC");
        ServiceHostListener serviceHostListener = (ServiceHostListener)listener;
        try {
            int n = dataInputStream.available();
            if (n < 4) {
                throw new IOException("read underflow");
            }
            byte[] byArray = new byte[4];
            dataInputStream.read(byArray, 0, 4);
            int n2 = this.initHandledState();
            if (serviceHostListener != null) {
                n2 = this.updateHandledState(n2, serviceHostListener.serviceSetPrivacyFlags(fLAPSock, object, sNACHeader.reqID, n2, byArray));
            }
            int n3 = 0;
            while (vector != null) {
                if (n3 >= vector.size()) return;
                if (!this.proceed(n2)) {
                    return;
                }
                ServiceHostListener serviceHostListener2 = (ServiceHostListener)vector.elementAt(n3);
                if (serviceHostListener2 != serviceHostListener) {
                    n2 = this.updateHandledState(n2, serviceHostListener2.serviceSetPrivacyFlags(fLAPSock, object, sNACHeader.reqID, n2, byArray));
                }
                ++n3;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceSetPrivacyFlags " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void wellKnownUrls(FLAPSock fLAPSock, ServiceHostListener serviceHostListener, Object object, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing serviceWellKnownUrls SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n)).write(outputBuffer.d);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, serviceHostListener, object, 1, 21, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceWellKnownUrls " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void noop(FLAPSock fLAPSock, ServiceHostListener serviceHostListener, Object object) {
        Log.log(MODULE, Log.DB1, "writing serviceNoop SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            this.dispatcher.queueOutput(fLAPSock, serviceHostListener, object, 1, 22, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("Service", "got IOException in serviceNoop " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    private void decodeNoop(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got serviceNoop SNAC");
        ServiceHostListener serviceHostListener = (ServiceHostListener)listener;
        int n = this.initHandledState();
        if (serviceHostListener != null) {
            n = this.updateHandledState(n, serviceHostListener.serviceNoop(fLAPSock, object, sNACHeader.reqID, n));
        }
        int n2 = 0;
        while (vector != null && n2 < vector.size() && this.proceed(n)) {
            ServiceHostListener serviceHostListener2 = (ServiceHostListener)vector.elementAt(n2);
            if (serviceHostListener2 != serviceHostListener) {
                n = this.updateHandledState(n, serviceHostListener2.serviceNoop(fLAPSock, object, sNACHeader.reqID, n));
            }
            ++n2;
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 2) {
            this.decodeClientOnline(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 4) {
            this.decodeServiceRequest(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 6) {
            this.decodeRateParamsQuery(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 8) {
            this.decodeRateAddParamSub(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 9) {
            this.decodeRateDelParamSub(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 12) {
            this.decodePauseAck(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 14) {
            this.decodeNickInfoQuery(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 17) {
            this.decodeIdleNotification(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 20) {
            this.decodeSetPrivacyFlags(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 22) {
            this.decodeNoop(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("Service", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

