/*
 * Decompiled with CFR 0.152.
 */
package snac;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import snac.SnacConstants;
import snac.SnacTlv;
import snac.TLV;

public class SnacTlvBlock
implements SnacConstants {
    private static final String MODULE = "SNAC";
    public int tlvElements;
    public TLV tlv;

    public SnacTlvBlock(int n, TLV tLV) {
        this.tlvElements = n;
        this.tlv = tLV;
    }

    SnacTlvBlock(DataInputStream dataInputStream) throws IOException {
        this.tlvElements = dataInputStream.readUnsignedShort();
        this.tlv = new TLV();
        int n = 0;
        while (n < this.tlvElements && dataInputStream.available() > 0) {
            this.tlv.addElement(new SnacTlv(dataInputStream));
            ++n;
        }
        if (n < this.tlvElements) {
            throw new IOException("read underflow");
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.tlvElements);
        int n = 0;
        while (n < this.tlvElements && n < this.tlv.size()) {
            ((SnacTlv)this.tlv.elementAt(n)).write(dataOutputStream);
            ++n;
        }
    }
}

