/*
 * Decompiled with CFR 0.152.
 */
package snac;

import flap.FLAPSock;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;
import snac.DispatcherListener;
import snac.Listener;
import snac.SNACHeader;
import snac.SnacHandler;
import snac.SnacTlv;
import snac.TLV;
import snac.UserLookupHostListener;
import uiutil.ErrorMgr;
import util.Log;
import util.OutputBuffer;

public class UserLookupHostHandler
extends SnacHandler {
    private static final String MODULE = "SNAC";

    public UserLookupHostHandler(DispatcherListener dispatcherListener) {
        this.dispatcher = dispatcherListener;
        dispatcherListener.registerSNACHandler(10, 1, this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decodeFindBYEmail(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        Log.log(MODULE, Log.DB1, "got userLookupFindBYEmail SNAC");
        UserLookupHostListener userLookupHostListener = (UserLookupHostListener)listener;
        try {
            int n = dataInputStream.available();
            if (n > 8192) {
                throw new IOException("read overflow");
            }
            if (n < 0) {
                throw new IOException("read underflow");
            }
            byte[] byArray = new byte[n];
            if (n > 0) {
                dataInputStream.read(byArray, 0, n);
            }
            int n2 = this.initHandledState();
            if (userLookupHostListener != null) {
                n2 = this.updateHandledState(n2, userLookupHostListener.userLookupFindBYEmail(fLAPSock, object, sNACHeader.reqID, n2, byArray));
            }
            int n3 = 0;
            while (vector != null) {
                if (n3 >= vector.size()) return;
                if (!this.proceed(n2)) {
                    return;
                }
                UserLookupHostListener userLookupHostListener2 = (UserLookupHostListener)vector.elementAt(n3);
                if (userLookupHostListener2 != userLookupHostListener) {
                    n2 = this.updateHandledState(n2, userLookupHostListener2.userLookupFindBYEmail(fLAPSock, object, sNACHeader.reqID, n2, byArray));
                }
                ++n3;
            }
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("UserLookup", "got IOException in userLookupFindBYEmail " + iOException.getMessage(), iOException);
            fLAPSock.close("problems reading from server", 23);
        }
    }

    public void findReply(FLAPSock fLAPSock, UserLookupHostListener userLookupHostListener, Object object, TLV tLV) {
        Log.log(MODULE, Log.DB1, "writing userLookupFindReply SNAC");
        OutputBuffer outputBuffer = new OutputBuffer(100);
        try {
            int n = 0;
            while (n < tLV.size()) {
                ((SnacTlv)tLV.elementAt(n)).write(outputBuffer.d);
                ++n;
            }
            this.dispatcher.queueOutput(fLAPSock, userLookupHostListener, object, 10, 3, null, outputBuffer.bytes());
            return;
        }
        catch (IOException iOException) {
            ErrorMgr.warn("UserLookup", "got IOException in userLookupFindReply " + iOException.getMessage(), iOException);
            fLAPSock.close("problems writing to server", 28);
            return;
        }
    }

    public void decodeSNAC(FLAPSock fLAPSock, SNACHeader sNACHeader, DataInputStream dataInputStream, Listener listener, Object object, Vector vector) throws IOException {
        if (sNACHeader.subtype == 1) {
            this.decodeSnacError(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        if (sNACHeader.subtype == 2) {
            this.decodeFindBYEmail(fLAPSock, sNACHeader, dataInputStream, listener, object, vector);
            return;
        }
        ErrorMgr.warn("UserLookup", " got unrecognized SNAC " + sNACHeader + " ignoring");
        fLAPSock.close("server sending bad data", 23);
    }
}

