/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import uiutil.ImageContainer;
import util.Timer;
import util.TimerListener;

public class IconMeter
extends Component
implements TimerListener {
    private static int ICON_UPDATE_EVENT;
    private Image[] images;
    private boolean on = true;
    private int index;
    private boolean blink = false;
    private Dimension size;
    private ImageContainer container;

    public void destroy() {
        this.images = null;
        this.size = null;
        this.container = null;
    }

    public IconMeter(String string, Image[] imageArray) {
        this.setName(string);
        this.images = imageArray;
        if (imageArray != null && imageArray[0] != null) {
            this.size = new Dimension(imageArray[0].getWidth(this), imageArray[0].getHeight(this));
        }
    }

    public Dimension getMinimumSize() {
        return this.size;
    }

    public Dimension getPreferredSize() {
        return this.size;
    }

    public void paint(Graphics graphics) {
        if (this.on) {
            graphics.drawImage(this.images[this.index], (this.size.width - this.images[this.index].getWidth(this)) / 2, (this.size.height - this.images[this.index].getHeight(this)) / 2, this);
            return;
        }
        graphics.drawImage(this.images[0], 0, 0, this);
    }

    public void timerEvent(String string, int n, Object object) {
        if (n == ICON_UPDATE_EVENT) {
            if (this.blink) {
                if (this.on) {
                    Timer.createEvent("IconMeterUpdater", this, ICON_UPDATE_EVENT, null, 1600);
                } else {
                    Timer.createEvent("IconMeterUpdater", this, ICON_UPDATE_EVENT, null, 800);
                }
            }
            boolean bl = this.on = !this.on;
            if (this.isValid()) {
                this.repaint();
            }
        }
    }

    public void start() {
        if (this.blink) {
            return;
        }
        System.out.println("start setting up timer event for " + this.getName());
        this.blink = true;
        Timer.createEvent("IconMeterUpdater", this, ICON_UPDATE_EVENT, null, 1600);
    }

    public void stop() {
        this.blink = false;
    }

    public void set(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n >= this.images.length) {
            n = this.images.length - 1;
        }
        this.index = n;
        if (this.isValid()) {
            this.repaint();
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + " " + this.getName();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

