/*
 * Decompiled with CFR 0.152.
 */
package uiutil;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Vector;
import uiutil.Item;
import uiutil.RowItem;
import uiutil.ScrollList;

public class ItemRow {
    private Vector rowItemList;
    int size;
    private String name;
    int rowNumber;
    private RowItem rowItem;
    int width;
    private int height;
    boolean selected;
    private Color background;
    private Color foreground;
    private int VG = 0;
    private int imageAlignPos;
    private ScrollList slref;
    private boolean visible = true;
    private boolean isDim = false;

    public ItemRow() {
        this.rowItemList = null;
    }

    public ItemRow(String string, Vector vector, Color color, Color color2) {
        this.updateRowItems(string, vector, color, color2);
        this.imageAlignPos = 0;
    }

    public void destroy() {
        if (this.rowItemList != null) {
            int n = 0;
            while (n < this.rowItemList.size()) {
                RowItem rowItem = (RowItem)this.rowItemList.elementAt(n);
                rowItem.destroy();
                ++n;
            }
            this.rowItemList.removeAllElements();
        }
        this.rowItemList = null;
        this.name = null;
        if (this.rowItem != null) {
            this.rowItem.destroy();
        }
        this.rowItem = null;
        this.background = null;
        this.foreground = null;
        this.slref = null;
    }

    public void setSLRef(ScrollList scrollList) {
        this.slref = scrollList;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void updateRowItems(String string, Vector vector, Color color, Color color2) {
        RowItem rowItem;
        int n;
        if (this.rowItemList != null) {
            this.size = this.rowItemList.size();
            n = 0;
            while (n < this.size) {
                rowItem = (RowItem)this.rowItemList.elementAt(n);
                if (rowItem != null) {
                    rowItem.destroy();
                }
                ++n;
            }
            this.rowItemList.removeAllElements();
        }
        this.size = vector.size();
        this.name = string;
        this.rowItemList = new Vector(this.size);
        this.height = 0;
        int n2 = 0;
        while (n2 < this.size) {
            rowItem = (RowItem)vector.elementAt(n2);
            this.rowItemList.addElement(rowItem);
            n = rowItem.getHeight();
            if (n > this.height) {
                this.height = n;
            }
            ++n2;
        }
        this.height += this.VG;
        this.setColors(color2, color);
    }

    public int getHeight() {
        return this.height;
    }

    public void updateHeight(int n) {
        this.height = n;
    }

    public String getName() {
        return this.name;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    void setColors(Color color, Color color2) {
        this.background = color2;
        if (this.isDim) {
            return;
        }
        this.foreground = color;
    }

    void setColors(Color color, Color color2, Color color3, boolean bl) {
        this.isDim = bl;
        this.foreground = bl ? color3 : color;
        this.background = color2;
    }

    public Vector getNormalList() {
        int n = this.rowItemList.size();
        Vector<Object> vector = new Vector<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            this.rowItem = (RowItem)this.rowItemList.elementAt(n2);
            Item item = this.rowItem.getNormal();
            if (item.isString()) {
                vector.addElement(item.getString());
            } else {
                vector.addElement(item.getImage());
            }
            ++n2;
        }
        return vector;
    }

    public Vector getSelectedList() {
        int n = this.rowItemList.size();
        Vector<Object> vector = new Vector<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            this.rowItem = (RowItem)this.rowItemList.elementAt(n2);
            Item item = this.rowItem.getClicked();
            if (item.isString()) {
                vector.addElement(item.getString());
            } else {
                vector.addElement(item.getImage());
            }
            ++n2;
        }
        return vector;
    }

    public void paint(Component component, Graphics graphics, int n) {
        if (graphics == null) {
            return;
        }
        if (!this.visible) {
            return;
        }
        int n2 = 2;
        int n3 = n * this.height;
        this.rowNumber = n;
        if (this.selected) {
            graphics.setColor(this.foreground);
        } else {
            graphics.setColor(this.background);
        }
        graphics.fillRect(0, n3, this.width, this.height);
        Vector vector = this.rowItemList;
        synchronized (vector) {
            this.size = this.rowItemList.size();
            int n4 = 0;
            while (n4 < this.size) {
                int n5 = n2 + 2;
                this.rowItem = (RowItem)this.rowItemList.elementAt(n4);
                if (n4 == 2) {
                    this.imageAlignPos = this.slref.getAlignPos();
                    if (this.imageAlignPos < n5) {
                        this.imageAlignPos = n5;
                        this.slref.setAlignPos(this.name, n5);
                    }
                    n2 = this.rowItem.drawIt(component, graphics, this.imageAlignPos, n3, this.height, this.foreground, this.background, this.selected);
                } else {
                    n2 = this.rowItem.drawIt(component, graphics, n5, n3, this.height, this.foreground, this.background, this.selected);
                }
                ++n4;
            }
            return;
        }
    }

    public boolean within(int n, int n2) {
        if (!this.visible) {
            return false;
        }
        int n3 = this.height + this.VG;
        int n4 = n3 + this.VG;
        return n2 >= this.rowNumber * n3 && n2 <= (this.rowNumber + 1) * n4;
    }

    public void toggle() {
        if (this.selected) {
            this.deselect();
            return;
        }
        this.select();
    }

    public void deselect() {
        this.selected = false;
    }

    public void select() {
        this.selected = true;
    }
}

