/*
 * Decompiled with CFR 0.152.
 */
package rath.jmsn.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import rath.jmsn.MainFrame;
import rath.jmsn.ToolBox;
import rath.jmsn.ui.DefaultDialog;
import rath.jmsn.util.Msg;
import rath.msnm.LocalCopy;

public class FontDialog
extends DefaultDialog
implements ToolBox,
ActionListener {
    private JLabel preview = null;
    private JTextField fontNameField = null;
    private JTextField fontSizeField = null;
    private JList fontName = null;
    private DefaultListModel fontNameModel = null;
    private JList fontSize = null;
    private DefaultListModel fontSizeModel = null;
    private JCheckBox italic = null;
    private JCheckBox bold = null;
    private JCheckBox underline = null;
    private JCheckBox strikethrough = null;
    private JCheckBox isRandomColor = null;
    private JButton fontColor = null;
    private static final String DEFAULT_FONT_NAME = "\uad74\ub9bc\uccb4";
    private static final int DEFAULT_FONT_SIZE = 12;

    public FontDialog(Frame owner) {
        super(owner);
        this.setTitle(Msg.get("title.changefont"));
        this.createComponents();
        this.loadProperties();
    }

    private void createComponents() {
        this.setSize(340, 250);
        JPanel panel = (JPanel)this.getContentPane();
        this.preview = new JLabel(Msg.get("label.fontpreviewstring"));
        this.preview.setPreferredSize(new Dimension(100, 50));
        TitledBorder tb = new TitledBorder(new EtchedBorder(), Msg.get("label.fontpreview"));
        tb.setTitleFont(ToolBox.FONT);
        this.preview.setBorder(tb);
        this.preview.setAlignmentX(0.0f);
        JPanel centerPanel = new JPanel(new BorderLayout());
        JPanel fontNamePanel = new JPanel(new BorderLayout());
        tb = new TitledBorder(new EtchedBorder(), Msg.get("label.font"));
        tb.setTitleFont(ToolBox.FONT);
        fontNamePanel.setBorder(tb);
        fontNamePanel.setPreferredSize(new Dimension(165, 15));
        this.fontNameField = new JTextField();
        this.fontNameField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontDialog.this.fontNameChangeFromField();
            }
        });
        this.fontNameModel = new DefaultListModel();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontList = ge.getAvailableFontFamilyNames();
        int i = 0;
        while (i < fontList.length) {
            this.fontNameModel.addElement(fontList[i]);
            ++i;
        }
        this.fontName = new JList(this.fontNameModel);
        this.fontName.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                FontDialog.this.fontNameChangeFromList();
            }
        });
        this.fontName.setFont(ToolBox.FONT);
        fontNamePanel.add((Component)this.fontNameField, "North");
        fontNamePanel.add((Component)new JScrollPane(this.fontName), "Center");
        JPanel fontSizePanel = new JPanel(new BorderLayout());
        tb = new TitledBorder(new EtchedBorder(), Msg.get("label.fontsize"));
        tb.setTitleFont(ToolBox.FONT);
        fontSizePanel.setBorder(tb);
        this.fontSizeField = new JTextField();
        this.fontSizeField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontDialog.this.fontSizeChangeFromField();
            }
        });
        this.fontSizeModel = new DefaultListModel();
        int i2 = 9;
        while (i2 <= 16) {
            this.fontSizeModel.addElement(String.valueOf(i2));
            ++i2;
        }
        this.fontSize = new JList(this.fontSizeModel);
        this.fontSize.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                FontDialog.this.fontSizeChangeFromList();
            }
        });
        this.fontSize.setFont(ToolBox.FONT);
        fontSizePanel.add((Component)this.fontSizeField, "North");
        fontSizePanel.add((Component)new JScrollPane(this.fontSize), "Center");
        JPanel fpPanel = new JPanel();
        tb = new TitledBorder(new EtchedBorder(), Msg.get("label.fontproperties"));
        tb.setTitleFont(ToolBox.FONT);
        fpPanel.setBorder(tb);
        fpPanel.setLayout(new GridLayout(6, 1));
        fpPanel.setPreferredSize(new Dimension(110, 15));
        this.bold = new JCheckBox(Msg.get("label.fontbold"));
        this.bold.setFont(ToolBox.FONT);
        this.bold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontDialog.this.setBold();
            }
        });
        this.italic = new JCheckBox(Msg.get("label.fontitalic"));
        this.italic.setFont(ToolBox.FONT);
        this.italic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontDialog.this.setItalic();
            }
        });
        this.underline = new JCheckBox(Msg.get("label.fontunderline"));
        this.underline.setFont(ToolBox.FONT);
        this.underline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontDialog.this.setUnderline();
            }
        });
        this.strikethrough = new JCheckBox(Msg.get("label.fontstrikethrough"));
        this.strikethrough.setFont(ToolBox.FONT);
        this.strikethrough.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontDialog.this.setStrikethrough();
            }
        });
        this.isRandomColor = new JCheckBox(Msg.get("label.israndomcolor"));
        this.isRandomColor.setFont(ToolBox.FONT);
        this.isRandomColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontDialog.this.setRandomColor();
            }
        });
        this.fontColor = new JButton();
        this.fontColor.setBorder(null);
        this.fontColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontDialog.this.setColor();
            }
        });
        fpPanel.add(this.bold);
        fpPanel.add(this.italic);
        fpPanel.add(this.underline);
        fpPanel.add(this.strikethrough);
        fpPanel.add(this.isRandomColor);
        fpPanel.add(this.fontColor);
        centerPanel.add((Component)fontNamePanel, "Center");
        centerPanel.add((Component)fpPanel, "East");
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 10, 4));
        JButton okButton = new JButton(Msg.get("button.ok"));
        okButton.setFont(ToolBox.FONT);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontDialog.this.dispose();
                FontDialog.this.processChange();
            }
        });
        JButton cancelButton = new JButton(Msg.get("button.cancel"));
        cancelButton.setFont(ToolBox.FONT);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FontDialog.this.dispose();
            }
        });
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        panel.add((Component)this.preview, "North");
        panel.add((Component)centerPanel, "Center");
        panel.add((Component)buttonPanel, "South");
    }

    public void actionPerformed(ActionEvent e) {
    }

    protected void setRandomColor() {
        this.fontColor.setEnabled(!this.isRandomColor.isSelected());
    }

    protected void setColor() {
        Color c = JColorChooser.showDialog(this, Msg.get("label.choosefontcolor"), this.fontColor.getBackground());
        this.fontColor.setBackground(c);
        this.preview.setForeground(c);
    }

    protected void setBold() {
        int i = this.italic.isSelected() ? 2 : 0;
        Font font = this.preview.getFont();
        this.preview.setFont(this.bold.isSelected() ? font.deriveFont(1 + i) : font.deriveFont(0 + i));
    }

    protected void setItalic() {
        int b = this.bold.isSelected() ? 1 : 0;
        Font font = this.preview.getFont();
        this.preview.setFont(this.italic.isSelected() ? font.deriveFont(2 + b) : font.deriveFont(0 + b));
    }

    protected void setUnderline() {
    }

    protected void setStrikethrough() {
    }

    protected void fontNameChangeFromField() {
        String fn = this.fontNameField.getText();
        if (this.fontNameModel.contains(fn)) {
            int idx = this.fontNameModel.indexOf(fn);
            this.fontName.setSelectedIndex(idx);
            this.preview.setFont(new Font(fn, this.preview.getFont().getStyle(), Integer.parseInt(this.fontSize.getSelectedValue().toString())));
        } else {
            JOptionPane.showMessageDialog(this, "\uc785\ub825\ud558\uc2e0 \uae00\uaf34\uc740 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
    }

    protected void fontNameChangeFromList() {
        String fn = this.fontName.getSelectedValue().toString();
        this.fontNameField.setText(fn);
        try {
            this.preview.setFont(new Font(fn, this.preview.getFont().getStyle(), Integer.parseInt(this.fontSize.getSelectedValue().toString())));
        }
        catch (NumberFormatException e) {
            this.preview.setFont(new Font(fn, this.preview.getFont().getStyle(), 12));
        }
    }

    protected void fontSizeChangeFromField() {
        block4: {
            String fs = this.fontSizeField.getText();
            try {
                int iFs = Integer.parseInt(fs);
                if (iFs > 16 || iFs < 9) {
                    JOptionPane.showMessageDialog(this, "\uae00\uc790\ud06c\uae30\ub294 9~16 \uc0ac\uc774\uc5b4\uc57c \ud569\ub2c8\ub2e4.");
                    break block4;
                }
                if (this.fontSizeModel.indexOf(fs) != -1) {
                    int idx = this.fontSizeModel.indexOf(fs);
                    this.fontSize.setSelectedIndex(idx);
                    this.preview.setFont(this.preview.getFont().deriveFont(Float.parseFloat(fs)));
                    break block4;
                }
                this.fontSize.clearSelection();
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "\uae00\uc790\ud06c\uae30\ub294 9~16 \uc0ac\uc774\uc5b4\uc57c \ud569\ub2c8\ub2e4.");
            }
        }
    }

    protected void fontSizeChangeFromList() {
        String fs = this.fontSize.getSelectedValue().toString();
        this.fontSizeField.setText(fs);
        this.preview.setFont(this.preview.getFont().deriveFont(Float.parseFloat(fs)));
    }

    protected void loadProperties() {
        LocalCopy local = MainFrame.LOCALCOPY;
        String fn = local.getProperty("font.name", DEFAULT_FONT_NAME);
        String fs = local.getProperty("font.size", Integer.toString(12));
        boolean ir = local.getPropertyBoolean("font.israndomcolor", true);
        int red = 0;
        int green = 0;
        int blue = 0;
        try {
            red = Integer.parseInt(local.getProperty("font.red"));
            green = Integer.parseInt(local.getProperty("font.green"));
            blue = Integer.parseInt(local.getProperty("font.blue"));
        }
        catch (NumberFormatException e) {
            blue = 0;
            green = 0;
            red = 0;
        }
        boolean b = local.getPropertyBoolean("font.isBold", false);
        boolean i = local.getPropertyBoolean("font.isItalic", false);
        boolean s = local.getPropertyBoolean("font.isStrikeThrough", false);
        boolean u = local.getPropertyBoolean("font.isUnderline", false);
        try {
            int iFs = Integer.parseInt(fs);
            if (iFs > 16 || iFs < 9) {
                this.preview.setFont(this.preview.getFont().deriveFont(12));
            } else if (this.fontSizeModel.indexOf(fs) != -1) {
                int idx = this.fontSizeModel.indexOf(fs);
                this.fontSize.setSelectedIndex(idx);
                this.preview.setFont(this.preview.getFont().deriveFont(Float.parseFloat(fs)));
            } else {
                this.fontSize.clearSelection();
            }
        }
        catch (NumberFormatException e) {
            this.preview.setFont(this.preview.getFont().deriveFont(12));
        }
        if (this.fontNameModel.contains(fn)) {
            int idx = this.fontNameModel.indexOf(fn);
            this.fontName.setSelectedIndex(idx);
            this.preview.setFont(new Font(fn, 0, Integer.parseInt(this.fontSize.getSelectedValue().toString())));
        } else {
            this.preview.setFont(new Font(DEFAULT_FONT_NAME, 0, Integer.parseInt(this.fontSize.getSelectedValue().toString())));
        }
        this.bold.setSelected(b);
        this.setBold();
        this.underline.setSelected(u);
        this.strikethrough.setSelected(s);
        this.isRandomColor.setSelected(ir);
        if (ir) {
            this.fontColor.setEnabled(false);
        }
        this.italic.setSelected(i);
        this.setItalic();
        Color c = new Color(red, green, blue);
        this.fontColor.setBackground(c);
        this.preview.setForeground(c);
    }

    protected void saveProperties() {
        LocalCopy local = MainFrame.LOCALCOPY;
        try {
            boolean ir = this.isRandomColor.isSelected();
            local.setProperty("font.israndomcolor", String.valueOf(ir));
            Color c = this.fontColor.getBackground();
            local.setProperty("font.red", String.valueOf(c.getRed()));
            local.setProperty("font.green", String.valueOf(c.getGreen()));
            local.setProperty("font.blue", String.valueOf(c.getBlue()));
            local.setProperty("font.size", String.valueOf(this.fontSize.getSelectedValue()));
            local.setProperty("font.name", this.fontName.isSelectionEmpty() ? DEFAULT_FONT_NAME : String.valueOf(this.fontName.getSelectedValue()));
            local.setProperty("font.isBold", String.valueOf(this.bold.isSelected()));
            local.setProperty("font.isItalic", String.valueOf(this.italic.isSelected()));
            local.setProperty("font.isStrikeThrough", String.valueOf(this.strikethrough.isSelected()));
            local.setProperty("font.isUnderline", String.valueOf(this.underline.isSelected()));
            local.storeInformation();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void processChange() {
        this.saveProperties();
    }
}

