/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import borland.jbcl.control.ButtonDialog;
import borland.jbcl.control.FieldControl;
import borland.jbcl.control.TextAreaControl;
import borland.jbcl.model.BasicSingletonContainer;
import borland.jbcl.model.BasicViewManager;
import borland.jbcl.util.ChainedException;
import borland.jbcl.util.ExceptionChain;
import borland.jbcl.view.WrappedTextItemPainter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;

public class ExceptionDialog
extends ButtonDialog
implements ActionListener {
    private FieldControl message = new FieldControl();
    private TextAreaControl details = new TextAreaControl();
    private boolean showDetails = false;
    private int position;
    private Vector exceptionVector;
    private Exception ex;
    private static int showCount;

    private static int makeButtonSet(Exception exception) {
        if (exception instanceof ChainedException && ((ChainedException)((Object)exception)).getExceptionChain() != null) {
            return 897;
        }
        return 513;
    }

    public ExceptionDialog(Frame frame, String string, Exception exception, boolean bl) {
        super(frame, string, bl, null, null, ButtonDialog.buttonSetToButtonDescriptors(ExceptionDialog.makeButtonSet(exception)));
        this.ex = exception;
        this.details.setEditable(false);
        ((Component)this.details).setBackground(SystemColor.window);
        this.details.setPreferredHeight(200);
        this.message.setPreferredHeight(100);
        this.message.setPreferredWidth(400);
        this.message.setModel(new BasicSingletonContainer());
        this.message.setAlignment(1);
        this.message.setViewManager(new BasicViewManager(new WrappedTextItemPainter(null, this.message.getAlignment(), 400), null));
        this.makeExceptionList(exception);
        this.setLayout(new BorderLayout());
        ((Component)this).setBackground(SystemColor.control);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.message, "Center");
        panel.add((Component)this.buttonPanel, "South");
        this.add((Component)panel, "Center");
        this.displayException(0);
        ++showCount;
    }

    public ExceptionDialog(Frame frame, String string, Exception exception) {
        this(frame, string, exception, false);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        super.processActionEvent(actionEvent);
        if (this.result != null) {
            if (this.result.closeDialog) {
                --showCount;
            }
            if (this.result.command.equals("next") && this.position < this.exceptionVector.size() - 1) {
                this.displayException(++this.position);
            }
            if (this.result.command.equals("previous") && this.position > 0) {
                this.displayException(--this.position);
            }
            if (this.result.command.equals("details")) {
                if (!this.showDetails) {
                    this.add((Component)this.details, "South");
                } else {
                    this.remove(this.details);
                }
                this.showDetails = !this.showDetails;
                this.pack();
            }
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.processActionEvent(new ActionEvent(this, 1001, "ok"));
        }
    }

    private void displayException(int n) {
        this.enableButton("previous", this.position > 0);
        this.enableButton("next", this.position < this.exceptionVector.size() - 1);
        Exception exception = (Exception)this.exceptionVector.elementAt(n);
        this.message.setText(exception.getMessage());
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            exception.printStackTrace(printStream);
            printStream.flush();
            this.details.setText(byteArrayOutputStream.toString());
        }
        catch (IOException iOException) {
            this.details.setText(exception.getMessage());
        }
    }

    private void makeExceptionList(Exception exception) {
        this.exceptionVector = new Vector();
        this.exceptionVector.addElement(exception);
        if (exception instanceof ChainedException) {
            for (ExceptionChain exceptionChain = ((ChainedException)((Object)exception)).getExceptionChain(); exceptionChain != null; exceptionChain = exceptionChain.getNext()) {
                exception = exceptionChain.getException();
                this.exceptionVector.addElement(exception);
            }
        }
        this.position = 0;
    }

    public static int getShowCount() {
        return showCount;
    }
}

