/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.control;

import borland.jbcl.layout.PaneLayout;
import borland.jbcl.view.BeanPanel;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class SplitPanel
extends BeanPanel
implements MouseListener,
MouseMotionListener {
    PaneLayout layout = new PaneLayout();
    Canvas paneLayoutDivider = new Canvas();
    Cursor cursor;
    boolean yChanges;
    int xDelta;
    int yDelta;
    private Rectangle dividerRect;
    private Rectangle dividerBounds;
    boolean isSizing = false;
    Component[] enabledComponents;

    public SplitPanel() {
        this.add(this.paneLayoutDivider);
        this.paneLayoutDivider.setVisible(false);
        this.paneLayoutDivider.setEnabled(false);
        this.setDividerColor(Color.black);
        this.layout.setGap(2);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        super.setLayout(this.layout);
    }

    public void setGap(int n) {
        this.layout.setGap(n);
    }

    public int getGap() {
        return this.layout.getGap();
    }

    public void setDividerColor(Color color) {
        this.paneLayoutDivider.setBackground(color);
    }

    public Color getDividerColor() {
        return this.paneLayoutDivider.getBackground();
    }

    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager instanceof PaneLayout) {
            this.layout = (PaneLayout)layoutManager;
            super.setLayout(layoutManager);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() != this) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.dividerRect = this.layout.getDividerRect(n, n2);
        if (this.dividerRect != null) {
            this.dividerBounds = this.layout.getDividerBounds();
            if (this.dividerRect.width > this.dividerRect.height) {
                this.yChanges = true;
                this.yDelta = n2 - this.dividerRect.y;
            } else {
                this.yChanges = false;
                this.xDelta = n - this.dividerRect.x;
            }
            this.isSizing = true;
            Component[] componentArray = this.getComponents();
            this.enabledComponents = new Component[componentArray.length];
            for (int i = 0; i < componentArray.length; ++i) {
                if (!componentArray[i].isEnabled()) continue;
                this.enabledComponents[i] = componentArray[i];
                componentArray[i].setEnabled(false);
            }
            this.paneLayoutDivider.setBounds(this.dividerRect.x, this.dividerRect.y, this.dividerRect.width, this.dividerRect.height);
            this.paneLayoutDivider.setVisible(true);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.paneLayoutDivider.setVisible(false);
        if (this.isSizing) {
            this.isSizing = false;
            for (int i = 0; i < this.enabledComponents.length; ++i) {
                if (this.enabledComponents[i] == null) continue;
                this.enabledComponents[i].setEnabled(true);
            }
        }
        this.validate();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.cursor != null) {
            this.setCursor(this.cursor);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.cursor = this.getCursor();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() != this) {
            return;
        }
        Rectangle rectangle = this.layout.getDividerRect(mouseEvent.getX(), mouseEvent.getY());
        if (rectangle != null) {
            if (rectangle.width > rectangle.height) {
                this.setCursor(Cursor.getPredefinedCursor(8));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(11));
            }
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.isSizing) {
            int n = this.dividerRect.x;
            int n2 = this.dividerRect.y;
            if (this.yChanges) {
                n2 = mouseEvent.getY() - this.yDelta;
                if (n2 < this.dividerBounds.y) {
                    n2 = this.dividerBounds.y;
                } else if (n2 > this.dividerBounds.height + this.dividerBounds.y - 1) {
                    n2 = this.dividerBounds.height + this.dividerBounds.y - 1;
                }
            } else {
                n = mouseEvent.getX() - this.xDelta;
                if (n > this.dividerBounds.width + this.dividerBounds.x - 1) {
                    n = this.dividerBounds.width + this.dividerBounds.x - 1;
                } else if (n < this.dividerBounds.x) {
                    n = this.dividerBounds.x;
                }
            }
            this.layout.dragDivider(n, n2);
            this.dividerRect.x = n;
            this.dividerRect.y = n2;
            this.paneLayoutDivider.setLocation(n, n2);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension.width == 10) {
            dimension.width = 100;
        }
        if (dimension.height == 10) {
            dimension.height = 100;
        }
        return dimension;
    }
}

