/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.dataset;

import borland.jbcl.dataset.DataColumn;
import borland.jbcl.dataset.NullState;
import borland.jbcl.util.Variant;

class ByteColumn
extends DataColumn {
    byte[] vector = new byte[16];

    public ByteColumn(NullState nullState) {
        super(nullState);
        this.vectorLength = this.vector.length;
    }

    final void copy(int n, int n2) {
        this.vector[n2] = this.vector[n];
        if (this.hasNulls) {
            this.nullState.copy(n, n2, this.nullMask);
        }
    }

    protected final void grow(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.vector, 0, byArray, 0, this.vectorLength);
        this.vector = byArray;
        this.vectorLength = this.vector.length;
    }

    final int compare(int n, int n2) {
        if (this.hasNulls && (this.comp = this.nullState.compare(n, n2, this.nullMask)) != 0) {
            return this.comp;
        }
        return this.vector[n] - this.vector[n2];
    }

    final int compareIgnoreCase(int n, int n2) {
        return this.compare(n, n2);
    }

    final void getVariant(int n, Variant variant) {
        if (this.hasNulls && (this.nullState.vector[n] & this.nullMask) != 0) {
            this.nullState.getNull(n, variant, this.nullMask, this.assignedMask);
        } else {
            variant.setByte(this.vector[n]);
        }
    }

    final void setVariant(int n, Variant variant) {
        if (variant.isNull()) {
            this.vector[n] = 127;
            this.setNull(n, variant.getType());
        } else {
            if (this.hasNulls) {
                int n2 = n;
                this.nullState.vector[n2] = (byte)(this.nullState.vector[n2] & ~this.nullMask);
            }
            this.vector[n] = variant.getByte();
        }
    }
}

