/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.util;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class MouseMulticaster
implements MouseListener {
    private transient MouseListener[] listeners;

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.listeners != null) {
            this.dispatch(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.listeners != null) {
            this.dispatch(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.listeners != null) {
            this.dispatch(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.listeners != null) {
            this.dispatch(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.listeners != null) {
            this.dispatch(mouseEvent);
        }
    }

    public final boolean hasListeners() {
        return this.listeners != null;
    }

    public final void dispatch(MouseEvent mouseEvent) {
        MouseListener[] mouseListenerArray = this.listeners;
        if (mouseListenerArray != null) {
            int n = mouseListenerArray.length;
            block7: for (int i = 0; i < n; ++i) {
                switch (mouseEvent.getID()) {
                    case 500: {
                        mouseListenerArray[i].mouseClicked(mouseEvent);
                        continue block7;
                    }
                    case 501: {
                        mouseListenerArray[i].mousePressed(mouseEvent);
                        continue block7;
                    }
                    case 502: {
                        mouseListenerArray[i].mouseReleased(mouseEvent);
                        continue block7;
                    }
                    case 504: {
                        mouseListenerArray[i].mouseEntered(mouseEvent);
                        continue block7;
                    }
                    case 505: {
                        mouseListenerArray[i].mouseExited(mouseEvent);
                    }
                }
            }
        }
    }

    public int find(MouseListener mouseListener) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.length; ++i) {
                if (this.listeners[i] != mouseListener) continue;
                return i;
            }
        }
        return -1;
    }

    public final synchronized void add(MouseListener mouseListener) {
        if (this.find(mouseListener) < 0) {
            MouseListener[] mouseListenerArray;
            if (this.listeners == null) {
                mouseListenerArray = new MouseListener[1];
            } else {
                mouseListenerArray = new MouseListener[this.listeners.length + 1];
                System.arraycopy(this.listeners, 0, mouseListenerArray, 0, this.listeners.length);
            }
            mouseListenerArray[mouseListenerArray.length - 1] = mouseListener;
            this.listeners = mouseListenerArray;
        }
    }

    public final synchronized void remove(MouseListener mouseListener) {
        int n = this.find(mouseListener);
        if (n > -1) {
            if (this.listeners.length == 1) {
                this.listeners = null;
            } else {
                MouseListener[] mouseListenerArray = new MouseListener[this.listeners.length - 1];
                System.arraycopy(this.listeners, 0, mouseListenerArray, 0, n);
                if (n < mouseListenerArray.length) {
                    System.arraycopy(this.listeners, n + 1, mouseListenerArray, n, mouseListenerArray.length - n);
                }
                this.listeners = mouseListenerArray;
            }
        }
    }
}

