/*
 * Decompiled with CFR 0.152.
 */
package borland.jbcl.view;

import borland.jbcl.model.ItemEditSite;
import borland.jbcl.model.ItemEditor;
import borland.jbcl.model.ItemPainter;
import borland.jbcl.model.SingletonModel;
import borland.jbcl.model.SingletonModelEvent;
import borland.jbcl.model.SingletonModelListener;
import borland.jbcl.model.SingletonModelMulticaster;
import borland.jbcl.model.SingletonViewManager;
import borland.jbcl.model.WritableSingletonModel;
import borland.jbcl.util.KeyMulticaster;
import borland.jbcl.view.BeanPanel;
import borland.jbcl.view.BorderItemPainter;
import borland.jbcl.view.SingletonView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;

public class FieldView
extends BeanPanel
implements SingletonView,
SingletonModelListener,
ItemEditSite,
KeyListener,
FocusListener {
    private transient SingletonModel model;
    private transient WritableSingletonModel writeModel;
    private boolean readOnly;
    private transient SingletonViewManager viewManager;
    private BorderItemPainter border = new BorderItemPainter(9);
    private ItemEditor editor;
    private Point editClickPoint;
    private boolean selectable = false;
    private boolean postOnEndEdit = true;
    private boolean autoEdit = true;
    private boolean editInPlace = true;
    private boolean showFocus = true;
    private int state;
    private Insets margins = new Insets(2, 2, 2, 2);
    private int alignment = 33;
    private int preferredHeight = 20;
    private int preferredWidth = 100;
    private boolean endEditFailed = false;
    private transient KeyMulticaster keyMulticaster = new KeyMulticaster();
    private transient SingletonModelMulticaster modelMulticaster = new SingletonModelMulticaster();
    protected boolean postOnFocusLost = true;

    public FieldView() {
        super.setBackground(SystemColor.window);
        super.addKeyListener(this.keyMulticaster);
    }

    public SingletonModel getModel() {
        return this.model;
    }

    public void setModel(SingletonModel singletonModel) {
        this.endEdit();
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = singletonModel;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
        }
        this.writeModel = this.model instanceof WritableSingletonModel ? (WritableSingletonModel)this.model : null;
        this.repaint(100L);
    }

    public WritableSingletonModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void addModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.add(singletonModelListener);
    }

    public void removeModelListener(SingletonModelListener singletonModelListener) {
        this.modelMulticaster.remove(singletonModelListener);
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public void setEditInPlace(boolean bl) {
        this.editInPlace = bl;
    }

    public boolean isEditInPlace() {
        return this.editInPlace;
    }

    public boolean isPostOnEndEdit() {
        return this.postOnEndEdit;
    }

    public void setPostOnEndEdit(boolean bl) {
        this.postOnEndEdit = bl;
    }

    public void setAutoEdit(boolean bl) {
        this.autoEdit = bl;
    }

    public boolean isAutoEdit() {
        return this.autoEdit;
    }

    public boolean isEditing() {
        return this.editor != null;
    }

    public boolean isPostOnFocusLost() {
        return this.postOnFocusLost;
    }

    public void setPostOnFocusLost(boolean bl) {
        this.postOnFocusLost = bl;
    }

    public boolean isShowFocus() {
        return this.showFocus;
    }

    public void setShowFocus(boolean bl) {
        if (this.showFocus != bl) {
            this.showFocus = bl;
            this.repaint(100L);
        }
    }

    public Insets getItemMargins() {
        return this.margins;
    }

    public void setItemMargins(Insets insets) {
        this.margins = insets;
        this.repaint(100L);
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public SingletonViewManager getViewManager() {
        return this.viewManager;
    }

    public void setViewManager(SingletonViewManager singletonViewManager) {
        this.endEdit();
        this.viewManager = singletonViewManager;
        this.repaint();
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean bl) {
        this.selectable = bl;
        if (!this.selectable) {
            this.state &= 0xFFFFFFFC;
            this.repaint(100L);
        }
    }

    public boolean isSelected() {
        return this.selectable && (this.state & 4) != 0;
    }

    public void setSelected(boolean bl) {
        this.state = this.selectable && bl ? (this.state |= 4) : (this.state &= 0xFFFFFFFB);
        this.repaint(100L);
    }

    protected String paramString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(super.paramString()).concat(String.valueOf(",selectable="))).concat(String.valueOf(this.selectable))).concat(String.valueOf(",state="))).concat(String.valueOf(this.state));
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Point getEditClickPoint() {
        return this.editClickPoint;
    }

    public Graphics getSiteGraphics() {
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            graphics.setFont(this.getFont());
        }
        return graphics;
    }

    public void startEdit() {
        if (this.model == null || this.viewManager == null || !this.editInPlace) {
            return;
        }
        Object object = this.model.get();
        this.editor = this.viewManager.getEditor(object, 0);
        if (this.editor != null) {
            Component component = this.editor.getComponent();
            if (component != null) {
                component.setVisible(false);
                this.add(component);
            }
            Rectangle rectangle = this.outerRect();
            this.editor.addKeyListener(this);
            this.editor.addKeyListener(this.keyMulticaster);
            this.editor.startEdit(object, rectangle, this);
            if (component != null) {
                component.addFocusListener(this);
            }
            this.editClickPoint = null;
        }
    }

    public void endEdit() {
        this.endEdit(this.postOnEndEdit);
    }

    public void endEdit(boolean bl) {
        this.endEditFailed = false;
        if (this.editor != null) {
            boolean bl2 = true;
            try {
                if (!bl || (bl2 = this.editor.canPost())) {
                    if (bl && bl2) {
                        this.writeModel.set(this.editor.getValue());
                    }
                    if (bl2 && this.editor != null) {
                        this.editor.endEdit(bl);
                        Component component = this.editor.getComponent();
                        this.editor.removeKeyListener(this);
                        this.editor.removeKeyListener(this.keyMulticaster);
                        if (component != null) {
                            this.remove(component);
                            component.removeFocusListener(this);
                        }
                        this.editClickPoint = null;
                        this.editor = null;
                    }
                }
            }
            catch (Exception exception) {
                this.endEditFailed = true;
            }
        }
    }

    public Rectangle getInnerRect(Graphics graphics) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.border.getPreferredSize(null, graphics, this.state, this);
        Dimension dimension3 = new Dimension(dimension.width - dimension2.width, dimension.height - dimension2.height);
        int n = dimension2.width / 2;
        int n2 = dimension2.height / 2;
        return new Rectangle(n, n2, dimension3.width, dimension3.height);
    }

    private Rectangle outerRect() {
        Dimension dimension = this.getSize();
        return new Rectangle(0, 0, dimension.width, dimension.height);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.getSize();
        Object object = this.model != null ? this.model.get() : null;
        ItemPainter itemPainter = this.getPainter(object);
        Rectangle rectangle = this.getInnerRect(graphics);
        if (itemPainter != null) {
            graphics.setColor(this.getBackground());
            graphics.setFont(this.getFont());
            itemPainter.paint(object, graphics, rectangle, this.state, this);
        } else {
            graphics.setColor(Color.red);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.border.paint(null, graphics, new Rectangle(0, 0, dimension.width, dimension.height), this.state, this);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.editor == null) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.endEdit(true);
                if (this.endEditFailed) break;
                keyEvent.consume();
                this.fireActionEvent();
                break;
            }
            case 27: {
                this.endEdit(false);
                keyEvent.consume();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    protected void processKeyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                if (!keyEvent.isControlDown() || this.editor != null || this.isReadOnly() || !this.writeModel.canSet(true)) break;
                this.startEdit();
                break;
            }
            case 113: {
                if (this.editor != null || this.isReadOnly() || !this.writeModel.canSet(true)) break;
                this.startEdit();
                break;
            }
            case 25: 
            case 229: {
                if (this.editor != null || this.isReadOnly() || !this.writeModel.canSet(true)) break;
                this.startEdit();
            }
        }
    }

    protected void processKeyTyped(KeyEvent keyEvent) {
        Component component;
        char c = keyEvent.getKeyChar();
        if (this.editor != null || !this.autoEdit || keyEvent.isConsumed() || this.isReadOnly() || c == '\u0000' || c == '\t' || c == '\r' || c == '\n' || c == '\u001b' || keyEvent.isAltDown() ^ keyEvent.isControlDown() || !this.writeModel.canSet(true)) {
            return;
        }
        this.startEdit();
        if (this.editor != null && (component = this.editor.getComponent()) != null) {
            component.dispatchEvent(keyEvent);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.state &= 0xFFFFFFFD;
        if (!focusEvent.isTemporary() && this.postOnFocusLost) {
            this.endEdit(this.postOnEndEdit);
        }
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        switch (focusEvent.getID()) {
            case 1004: {
                if (this.showFocus) {
                    this.state |= 2;
                }
                if (this.editor != null && this.editor.getComponent() != null) {
                    this.editor.getComponent().requestFocus();
                }
                this.repaint();
                break;
            }
            case 1005: {
                this.state &= 0xFFFFFFFD;
                this.repaint();
            }
        }
    }

    protected void processMousePressed(MouseEvent mouseEvent) {
        super.processMousePressed(mouseEvent);
        if (!mouseEvent.isMetaDown()) {
            if (this.selectable) {
                this.state = this.isSelected() ? (this.state &= 0xFFFFFFFC) : (this.state |= 4);
            }
            if ((this.state & 2) != 0 && this.editor == null && !this.isReadOnly() && this.writeModel.canSet(true)) {
                this.editClickPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
                this.startEdit();
            } else {
                this.state |= 2;
            }
        }
        this.repaint();
    }

    public boolean isEnabled() {
        return (this.state & 1) == 0;
    }

    public void setEnabled(boolean bl) {
        this.state = bl ? (this.state &= 0xFFFFFFFE) : (this.state |= 1);
        super.setEnabled(bl);
    }

    protected ItemPainter getPainter(Object object) {
        return this.viewManager != null ? this.viewManager.getPainter(object, this.state) : null;
    }

    public void modelContentChanged(SingletonModelEvent singletonModelEvent) {
        if (this.editor != null) {
            this.endEdit(false);
        }
        this.repaint();
    }

    public Dimension getPreferredSize() {
        Graphics graphics = this.getSiteGraphics();
        Object object = this.model != null ? this.model.get() : null;
        ItemPainter itemPainter = this.getPainter(object);
        Dimension dimension = itemPainter != null ? itemPainter.getPreferredSize(object, graphics, this.state, this) : new Dimension(0, 0);
        Dimension dimension2 = this.border.getPreferredSize(null, graphics, this.state, this);
        dimension.width += dimension2.width;
        dimension.height += dimension2.height;
        if (this.preferredHeight > dimension.height) {
            dimension.height = this.preferredHeight;
        }
        if (this.preferredWidth > dimension.width) {
            dimension.width = this.preferredWidth;
        }
        return dimension;
    }

    public void doLayout() {
        if (this.editor != null) {
            Rectangle rectangle = this.outerRect();
            this.editor.changeBounds(rectangle);
        }
    }

    public void setPreferredHeight(int n) {
        this.preferredHeight = n;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public void setPreferredWidth(int n) {
        this.preferredWidth = n;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void addKeyListener(KeyListener keyListener) {
        this.keyMulticaster.add(keyListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.keyMulticaster.remove(keyListener);
    }

    private void fireActionEvent() {
        Object object = this.model != null ? this.model.get() : null;
        String string = object != null ? object.toString() : "";
        this.processActionEvent(new ActionEvent(this, 1001, string));
    }
}

