/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.jmx;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import net.sbbi.log.Log;
import net.sbbi.log.LogFactory;
import net.sbbi.upnp.Discovery;
import net.sbbi.upnp.DiscoveryAdvertisement;
import net.sbbi.upnp.DiscoveryEventHandler;
import net.sbbi.upnp.ServiceEventHandler;
import net.sbbi.upnp.devices.UPNPDevice;
import net.sbbi.upnp.devices.UPNPRootDevice;
import net.sbbi.upnp.jmx.UPNPServiceMBean;
import net.sbbi.upnp.services.UPNPService;

public class JMXManager
implements DiscoveryEventHandler,
ServiceEventHandler {
    private static final JMXManager instance = new JMXManager();
    private static final Log log = LogFactory.getLog(JMXManager.class);
    private Map registeredDevices = new HashMap();
    private Map registeredBeansPerUDN = new HashMap();
    private MBeanServer server;

    public static final JMXManager getInstance() {
        return instance;
    }

    private void register(UPNPRootDevice device) throws Exception {
        List services = device.getServices();
        log.info("Registering UPNP root device " + device.getUDN() + " located at " + device.getDeviceDefLoc());
        HashSet registeredMBeans = new HashSet();
        if (services != null) {
            this.registerServices(device, this.server, services, registeredMBeans);
        }
        this.registerChildDevice(this.server, device.getChildDevices(), registeredMBeans);
        this.registeredDevices.put(device.getUDN(), device);
        this.registeredBeansPerUDN.put(device.getUDN(), registeredMBeans);
    }

    private void registerServices(UPNPDevice device, MBeanServer server, List services, Set beansContainer) throws Exception {
        Iterator i = services.iterator();
        while (i.hasNext()) {
            UPNPService srv = (UPNPService)i.next();
            UPNPServiceMBean mBean = new UPNPServiceMBean(device, srv, null, null);
            log.info("Registering service " + srv.getServiceId());
            server.registerMBean(mBean, mBean.getObjectName());
            beansContainer.add(mBean);
        }
    }

    private void registerChildDevice(MBeanServer server, List childDevices, Set beansContainer) throws Exception {
        if (childDevices != null) {
            Iterator itr = childDevices.iterator();
            while (itr.hasNext()) {
                UPNPDevice device = (UPNPDevice)itr.next();
                log.info("Processing device " + device.getDeviceType());
                List services = device.getServices();
                if (services == null) continue;
                this.registerServices(device, server, services, beansContainer);
            }
        }
    }

    public void eventSSDPAlive(String usn, String udn, String nt, String maxAge, URL location) {
        System.out.println("ALIVE " + nt + " " + usn);
        if (this.registeredDevices.get(udn) == null) {
            try {
                UPNPRootDevice newDevice = new UPNPRootDevice(location, maxAge);
                log.info("Registering new device " + newDevice.getModelName());
                this.register(newDevice);
            }
            catch (Exception ex) {
                log.error("Error during new device " + location + " registration", ex);
            }
        }
    }

    public void eventSSDPByeBye(String usn, String udn, String nt) {
        if (this.registeredDevices.get(udn) != null) {
            log.info("Good bye root device usn " + usn + " nt " + nt);
            Set registeredBeans = (Set)this.registeredBeansPerUDN.get(udn);
            Iterator i = registeredBeans.iterator();
            while (i.hasNext()) {
                UPNPServiceMBean bean = (UPNPServiceMBean)i.next();
                try {
                    this.server.unregisterMBean(bean.getObjectName());
                }
                catch (Exception ex) {}
            }
            this.registeredBeansPerUDN.remove(udn);
            this.registeredDevices.remove(udn);
        }
    }

    private MBeanServer initMBeanServer(MBeanServerConfig conf) throws Exception {
        String oldSysProp = System.getProperty("javax.management.builder.initial");
        System.setProperty("javax.management.builder.initial", "mx4j.server.MX4JMBeanServerBuilder");
        this.server = MBeanServerFactory.createMBeanServer("UPNPLib");
        if (oldSysProp != null) {
            System.setProperty("javax.management.builder.initial", oldSysProp);
        }
        ObjectName serverName = new ObjectName("Http:name=HttpAdaptor");
        this.server.createMBean("mx4j.tools.adaptor.http.HttpAdaptor", serverName, null);
        this.server.setAttribute(serverName, new Attribute("Port", new Integer(conf.adapterAdapterPort)));
        Boolean allowWanBool = new Boolean(conf.allowWan);
        if (allowWanBool.booleanValue()) {
            this.server.setAttribute(serverName, new Attribute("Host", "0.0.0.0"));
        } else {
            this.server.setAttribute(serverName, new Attribute("Host", "localhost"));
        }
        ObjectName processorName = new ObjectName("Http:name=XSLTProcessor");
        this.server.createMBean("mx4j.tools.adaptor.http.XSLTProcessor", processorName, null);
        this.server.setAttribute(processorName, new Attribute("LocaleString", conf.locale));
        this.server.setAttribute(processorName, new Attribute("UseCache", Boolean.FALSE));
        this.server.setAttribute(processorName, new Attribute("PathInJar", "net/sbbi/jmx/xsl"));
        this.server.setAttribute(serverName, new Attribute("ProcessorName", processorName));
        this.server.invoke(serverName, "addAuthorization", new Object[]{conf.adapterUserName, conf.adapterPassword}, new String[]{"java.lang.String", "java.lang.String"});
        this.server.setAttribute(serverName, new Attribute("AuthenticationMethod", "basic"));
        this.server.invoke(serverName, "start", null, null);
        return this.server;
    }

    public static final void main(String[] args) {
        if (args.length != 6) {
            log.info("Usage : JMXManager <AdapterPort> <UserName> <Password> <AllowWan> <Locale> <discoveryTimeout>");
            System.exit(0);
        }
        try {
            JMXManager manager = JMXManager.getInstance();
            MBeanServerConfig conf = new MBeanServerConfig(args);
            UPNPRootDevice[] dev = Discovery.discover(conf.discoveryTimeout, "upnp:rootdevice");
            manager.initMBeanServer(conf);
            if (dev != null) {
                for (int i = 0; i < dev.length; ++i) {
                    manager.register(dev[i]);
                }
            } else {
                log.info("Sorry, but no UPNP devices responded on the network");
            }
            DiscoveryAdvertisement.getInstance().registerEvent(0, "upnp:rootdevice", manager);
            DiscoveryAdvertisement.getInstance().registerEvent(1, "upnp:rootdevice", manager);
        }
        catch (Exception ex) {
            log.error("Error during startup", ex);
        }
    }

    public void handleStateVariableEvent(String varName, String newValue) {
        log.info("Var " + varName + " changed to " + newValue);
    }

    private static final class MBeanServerConfig {
        private String adapterAdapterPort;
        private String adapterUserName;
        private String adapterPassword;
        private String allowWan;
        private String locale;
        private int discoveryTimeout;

        private MBeanServerConfig(String[] args) {
            this.adapterAdapterPort = args[0];
            this.adapterUserName = args[1];
            this.adapterPassword = args[2];
            this.allowWan = args[3];
            this.locale = args[4];
            this.discoveryTimeout = Integer.parseInt(args[5]);
        }
    }
}

