/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import org.jvnet.lafwidget.utils.FadeStateListener;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ButtonColorDelegate;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.RolloverButtonListener;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;

public class SubstanceRadioButtonUI
extends BasicRadioButtonUI {
    private SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate();
    protected PropertyChangeListener substancePropertyListener;
    protected JToggleButton button;
    private static Map<String, Icon> icons = new HashMap<String, Icon>();
    protected FadeStateListener substanceFadeStateListener;

    public static synchronized void reset() {
        icons.clear();
    }

    protected void installListeners(final AbstractButton b) {
        super.installListeners(b);
        this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), null);
        this.substanceFadeStateListener.registerListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceRadioButtonUI.this.substanceFadeStateListener != null) {
                        SubstanceRadioButtonUI.this.substanceFadeStateListener.unregisterListeners();
                    }
                    SubstanceRadioButtonUI.this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), null);
                    SubstanceRadioButtonUI.this.substanceFadeStateListener.registerListeners();
                }
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        Color bg = b.getBackground();
        if (bg instanceof UIResource) {
            b.setBackground(new ButtonColorDelegate(b, false));
        }
        b.putClientProperty("substancelaf.buttonopacityoriginal", b.isOpaque());
        b.setOpaque(false);
    }

    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setOpaque((Boolean)b.getClientProperty("substancelaf.buttonopacityoriginal"));
        b.putClientProperty("substancelaf.buttonopacityoriginal", null);
    }

    protected void uninstallListeners(AbstractButton b) {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        super.uninstallListeners(b);
    }

    private static synchronized Icon getIcon(JToggleButton button, ComponentState state) {
        SubstanceTheme theme;
        float visibility;
        FadeTracker fadeTracker = FadeTracker.getInstance();
        float f = visibility = state.isSelected() ? 10.0f : 0.0f;
        if (fadeTracker.isTracked(button, FadeTracker.FadeKind.SELECTION)) {
            visibility = fadeTracker.getFade10(button, FadeTracker.FadeKind.SELECTION);
        }
        if (fadeTracker.isTracked(button, FadeTracker.FadeKind.ROLLOVER)) {
            SubstanceTheme defaultTheme = SubstanceCoreUtilities.getDefaultTheme(button, true);
            SubstanceTheme theme2 = theme = SubstanceCoreUtilities.getActiveTheme(button, true);
            float cyclePos = 0.0f;
            if (!state.isSelected() && state.isEnabled()) {
                if (state == ComponentState.DEFAULT) {
                    theme2 = defaultTheme;
                    cyclePos = 10.0f - fadeTracker.getFade10(button, FadeTracker.FadeKind.ROLLOVER);
                } else {
                    theme2 = theme;
                    theme = defaultTheme;
                    cyclePos = fadeTracker.getFade10(button, FadeTracker.FadeKind.ROLLOVER);
                }
                String key = state.name() + ":" + theme.getDisplayName() + ":" + theme2.getDisplayName() + ":" + cyclePos + ":" + visibility;
                Icon result = icons.get(key);
                if (result != null) {
                    return result;
                }
                result = new ImageIcon(SubstanceImageCreator.getRadioButton(button, SubstanceSizeUtils.getRadioButtonMarkSize(), state, 0, theme, theme2, cyclePos, visibility / 10.0f));
                icons.put(key, result);
                return result;
            }
        }
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        theme = SubstanceCoreUtilities.getComponentTheme(button, kind);
        int cyclePos = state.getCycleCount();
        String key = state.name() + ":" + theme.getDisplayName() + ":" + theme.getDisplayName() + ":" + cyclePos + ":" + visibility;
        Icon result = icons.get(key);
        if (result != null) {
            return result;
        }
        result = new ImageIcon(SubstanceImageCreator.getRadioButton(button, SubstanceSizeUtils.getRadioButtonMarkSize(), state, 0, theme, theme, cyclePos, visibility / 10.0f));
        icons.put(key, result);
        return result;
    }

    public static ComponentUI createUI(JComponent b) {
        return new SubstanceRadioButtonUI((JToggleButton)b);
    }

    public SubstanceRadioButtonUI(JToggleButton button) {
        this.button = button;
        button.setRolloverEnabled(true);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new RolloverButtonListener(b);
    }

    public Icon getDefaultIcon() {
        ButtonModel model = this.button.getModel();
        return SubstanceRadioButtonUI.getIcon(this.button, ComponentState.getState(model, this.button));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Graphics g, JComponent c) {
        if (!(UIManager.getLookAndFeel() instanceof SubstanceLookAndFeel)) {
            return;
        }
        JComponent jComponent = c;
        synchronized (jComponent) {
            boolean isOpaque = c.isOpaque();
            c.setOpaque(false);
            this.bgDelegate.update(g, c);
            super.paint(g, c);
            c.setOpaque(isOpaque);
        }
        AbstractButton b = (AbstractButton)c;
        if (!b.isFocusPainted()) {
            return;
        }
        FontMetrics fm = c.getFontMetrics(c.getFont());
        Insets i = c.getInsets();
        Dimension size = new Dimension();
        Rectangle viewRect = new Rectangle();
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        size = b.getSize(size);
        viewRect.x = i.left;
        viewRect.y = i.top;
        viewRect.width = size.width - (i.right + viewRect.x);
        viewRect.height = size.height - (i.bottom + viewRect.y);
        iconRect.height = 0;
        iconRect.width = 0;
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.height = 0;
        textRect.width = 0;
        textRect.y = 0;
        textRect.x = 0;
        Icon altIcon = b.getIcon();
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), altIcon != null ? altIcon : this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        if (!(text == null || textRect.width <= 0 || textRect.height <= 0 || b.hasFocus() && b.isFocusPainted() || !FadeTracker.getInstance().isTracked(c, FadeTracker.FadeKind.FOCUS))) {
            this.paintFocus(g, textRect, size);
        }
    }

    protected void paintFocus(Graphics g, Rectangle t, Dimension d) {
        SubstanceCoreUtilities.paintFocus(g, this.button, this.button, t, 1.0f, 1);
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceRadioButtonUI: \n");
        sb.append("\t" + icons.size() + " icons");
        return sb.toString();
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        SubstanceCoreUtilities.paintText(g, (AbstractButton)c, textRect, text, this.getTextShiftOffset(), this.getPropertyPrefix());
    }
}

