/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;
import org.jvnet.lafwidget.utils.FadeStateListener;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceSpinnerButton;

public class SubstanceSpinnerUI
extends BasicSpinnerUI {
    protected PropertyChangeListener substancePropertyChangeListener;
    protected FadeStateListener substanceFadeStateListener;

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceSpinnerUI();
    }

    protected Component createNextButton() {
        SubstanceSpinnerButton c = new SubstanceSpinnerButton(this.spinner, SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getArrowIconWidth() - 2, SubstanceSizeUtils.getArrowIconHeight() - 1, SubstanceSizeUtils.getArrowStrokeWidth(), 1, SubstanceCoreUtilities.getActiveTheme(this.spinner, true)), 1);
        int spinnerButtonSize = SubstanceSizeUtils.getSpinnerButtonWidth();
        c.setPreferredSize(new Dimension(spinnerButtonSize, spinnerButtonSize));
        c.setMinimumSize(new Dimension(5, 5));
        HashSet<SubstanceConstants.Side> openSides = new HashSet<SubstanceConstants.Side>();
        openSides.add(SubstanceConstants.Side.BOTTOM);
        c.putClientProperty("substancelaf.buttonopenSide", openSides);
        this.installNextButtonListeners(c);
        return c;
    }

    protected Component createPreviousButton() {
        SubstanceSpinnerButton c = new SubstanceSpinnerButton(this.spinner, SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getArrowIconWidth() - 2, SubstanceSizeUtils.getArrowIconHeight() - 1, SubstanceSizeUtils.getArrowStrokeWidth(), 5, SubstanceCoreUtilities.getActiveTheme(this.spinner, true)), 5);
        int spinnerButtonSize = SubstanceSizeUtils.getSpinnerButtonWidth();
        c.setPreferredSize(new Dimension(spinnerButtonSize, spinnerButtonSize));
        c.setMinimumSize(new Dimension(5, 5));
        HashSet<SubstanceConstants.Side> openSides = new HashSet<SubstanceConstants.Side>();
        openSides.add(SubstanceConstants.Side.TOP);
        c.putClientProperty("substancelaf.buttonopenSide", openSides);
        this.installPreviousButtonListeners(c);
        return c;
    }

    protected void installDefaults() {
        JFormattedTextField tf;
        super.installDefaults();
        JComponent editor = this.spinner.getEditor();
        if (editor != null && editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
            tf.setBorder(new EmptyBorder(0, 1, 0, 1));
        }
    }

    protected void installListeners() {
        super.installListeners();
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("editor".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            JFormattedTextField tf;
                            if (SubstanceSpinnerUI.this.substanceFadeStateListener != null) {
                                SubstanceSpinnerUI.this.substanceFadeStateListener.unregisterListeners();
                            }
                            if (SubstanceSpinnerUI.this.spinner == null) {
                                return;
                            }
                            JComponent editor = SubstanceSpinnerUI.this.spinner.getEditor();
                            if (editor != null && editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
                                tf.setBorder(new EmptyBorder(0, 1, 0, 1));
                                SubstanceSpinnerUI.this.substanceFadeStateListener = new FadeStateListener(tf, null, new FadeTracker.FadeTrackerCallback(){

                                    public void fadeEnded(FadeTracker.FadeKind fadeKind) {
                                        if (SubstanceSpinnerUI.this.spinner != null) {
                                            SubstanceSpinnerUI.this.spinner.repaint();
                                        }
                                    }

                                    public void fadePerformed(FadeTracker.FadeKind fadeKind, float fadeCycle10) {
                                        if (SubstanceSpinnerUI.this.spinner != null) {
                                            SubstanceSpinnerUI.this.spinner.repaint();
                                        }
                                    }
                                });
                                SubstanceSpinnerUI.this.substanceFadeStateListener.registerListeners();
                            }
                        }
                    });
                }
            }
        };
        this.spinner.addPropertyChangeListener(this.substancePropertyChangeListener);
        JComponent editor = this.spinner.getEditor();
        if (editor != null && editor instanceof JSpinner.DefaultEditor) {
            JFormattedTextField tf = ((JSpinner.DefaultEditor)editor).getTextField();
            this.substanceFadeStateListener = new FadeStateListener(tf, null, new FadeTracker.FadeTrackerCallback(){

                public void fadeEnded(FadeTracker.FadeKind fadeKind) {
                    if (SubstanceSpinnerUI.this.spinner != null) {
                        SubstanceSpinnerUI.this.spinner.repaint();
                    }
                }

                public void fadePerformed(FadeTracker.FadeKind fadeKind, float fadeCycle10) {
                    if (SubstanceSpinnerUI.this.spinner != null) {
                        SubstanceSpinnerUI.this.spinner.repaint();
                    }
                }
            });
            this.substanceFadeStateListener.registerListeners();
        }
    }

    protected void uninstallListeners() {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        this.spinner.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (SubstanceSpinnerUI.hasFocus(this.spinner) || FadeTracker.getInstance().isTracked(this.spinner, FadeTracker.FadeKind.FOCUS)) {
            this.paintFocus(g, this.spinner.getEditor().getBounds());
        }
    }

    private static boolean hasFocus(Component comp) {
        if (comp.hasFocus()) {
            return true;
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                Component child = cont.getComponent(i);
                if (!SubstanceSpinnerUI.hasFocus(child)) continue;
                return true;
            }
        }
        return false;
    }

    protected void paintFocus(Graphics g, Rectangle bounds) {
        JFormattedTextField tf;
        JComponent editor = this.spinner.getEditor();
        if (editor != null && editor instanceof JSpinner.DefaultEditor && (tf = ((JSpinner.DefaultEditor)editor).getTextField()) != null) {
            SubstanceCoreUtilities.paintFocus(g, this.spinner, tf, bounds, 0.4f, 2 + SubstanceSizeUtils.getExtraPadding());
        }
    }
}

