/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.nativeskin.win32;

import com.l2fprod.gui.nativeskin.NativeSkin;
import com.l2fprod.gui.nativeskin.win32.Win32Region;
import com.l2fprod.gui.region.ImageRegion;
import com.l2fprod.gui.region.Region;
import com.l2fprod.util.OS;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.PixelGrabber;
import sun.awt.DrawingSurface;
import sun.awt.DrawingSurfaceInfo;
import sun.awt.Win32DrawingSurface;

public class Win32NativeSkin
extends NativeSkin {
    public void setWindowTransparency(Window window, int transparency) {
        Win32NativeSkin.setWindowTransparency0(Win32NativeSkin.getHWND(window), transparency);
    }

    public void setWindowRegion(Window window, Region region, boolean redraw) {
        this.setWindowRegion(Win32NativeSkin.getHWND(window), region, redraw);
    }

    public void setWindowRegion(int handle, Region region, boolean redraw) {
        if (region instanceof ImageRegion) {
            region = this.createRegion(((ImageRegion)region).getImage(), ((ImageRegion)region).getImage().getWidth(null), ((ImageRegion)region).getImage().getHeight(null));
        }
        Win32NativeSkin.setWindowRegion0(handle, ((Win32Region)region).nativeHandle, redraw);
    }

    public Region createEllipticRegion(int x1, int y1, int x2, int y2) {
        return new Win32Region(Win32NativeSkin.createEllipticRegion0(x1, y1, x2, y2));
    }

    public Region createRectangleRegion(int x1, int y1, int x2, int y2) {
        return new Win32Region(Win32NativeSkin.createRectangleRegion0(x1, y1, x2, y2));
    }

    public Region createRoundRectangleRegion(int x1, int y1, int x2, int y2, int x3, int y3) {
        return new Win32Region(Win32NativeSkin.createRoundRectangleRegion0(x1, y1, x2, y2, x3, y3));
    }

    public Region createPolygonRegion(int[] xpoints, int[] ypoints, int fillMode) {
        if (xpoints == null || ypoints == null || xpoints.length != ypoints.length) {
            throw new IllegalArgumentException("xpoints and ypoints must be != null and size must not differ");
        }
        return new Win32Region(Win32NativeSkin.createPolygonRegion0(xpoints, ypoints, fillMode));
    }

    public Region combineRegions(Region region1, Region region2, int combineMode) {
        return new Win32Region(Win32NativeSkin.combineRegions0(((Win32Region)region1).nativeHandle, ((Win32Region)region2).nativeHandle, combineMode));
    }

    public void setAlwaysOnTop(Window window, boolean enable) {
        Win32NativeSkin.setAlwaysOnTop0(Win32NativeSkin.getHWND(window), enable);
    }

    public Region createRegion(Image image, int width, int height) {
        int[] pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(image, 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            e.printStackTrace();
        }
        return new Win32Region(Win32NativeSkin.createRegion0(pixels, width, height));
    }

    private static native void setWindowRegion0(int var0, long var1, boolean var3);

    private static int getHWND(Window window) {
        if (window.getPeer() == null) {
            window.addNotify();
        }
        if (OS.isOneDotFour()) {
            return Win32NativeSkin.getHWND0(window);
        }
        int hwnd = 0;
        DrawingSurfaceInfo drawingSurfaceInfo = ((DrawingSurface)window.getPeer()).getDrawingSurfaceInfo();
        if (null != drawingSurfaceInfo) {
            drawingSurfaceInfo.lock();
            Win32DrawingSurface win32DrawingSurface = (Win32DrawingSurface)drawingSurfaceInfo.getSurface();
            hwnd = win32DrawingSurface.getHWnd();
            drawingSurfaceInfo.unlock();
        }
        return hwnd;
    }

    private static native int getHWND0(Window var0);

    private static native void setWindowTransparency0(int var0, int var1);

    private static native long createEllipticRegion0(int var0, int var1, int var2, int var3);

    private static native long createRectangleRegion0(int var0, int var1, int var2, int var3);

    private static native long createRoundRectangleRegion0(int var0, int var1, int var2, int var3, int var4, int var5);

    private static native long createPolygonRegion0(int[] var0, int[] var1, int var2);

    private static native long combineRegions0(long var0, long var2, int var4);

    private static native long createRegion0(int[] var0, int var1, int var2);

    private static native void setAlwaysOnTop0(int var0, boolean var1);
}

