/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.systeminfo;

public class SystemInfo {
    private static boolean _systemInfoLibraryLoaded;

    public static boolean isLibraryLoadedOK() {
        return _systemInfoLibraryLoaded;
    }

    private static native long nativeGetSessionIdleTime();

    private static native boolean nativeIsSessionLocked();

    public static long getSessionIdleTime() {
        if (_systemInfoLibraryLoaded) {
            return SystemInfo.nativeGetSessionIdleTime();
        }
        return -1L;
    }

    public static boolean isSessionLocked() {
        if (!_systemInfoLibraryLoaded) {
            throw new RuntimeException("systeminfo.dll not loaded");
        }
        return SystemInfo.nativeIsSessionLocked();
    }

    static {
        String operatingSystem = System.getProperty("os.name");
        boolean oldWindows = operatingSystem.matches("Windows (95|98|NT).*");
        String callbacksFlag = System.getProperty("systeminfo.callbacks");
        boolean forceCallbacks = "true".equals(callbacksFlag);
        try {
            if (oldWindows || forceCallbacks) {
                System.loadLibrary("systemcallback");
            } else {
                System.loadLibrary("systeminfo");
            }
            _systemInfoLibraryLoaded = true;
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println("Couldn't find system info library in " + System.getProperty("java.library.path"));
            e.printStackTrace(System.err);
            _systemInfoLibraryLoaded = false;
        }
    }
}

