/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sdp.parser;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sdp.parser.Lexer;
import gov.nist.javax.sdp.parser.SDPParser;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.Hashtable;

public class ParserFactory {
    private static Hashtable parserTable;
    private static Class[] constructorArgs;
    private static final String packageName = "gov.nist.javax.sdp.parser";

    private static Class getParser(String parserClass) {
        try {
            return Class.forName("gov.nist.javax.sdp.parser." + parserClass);
        }
        catch (ClassNotFoundException ex) {
            System.out.println("Could not find class");
            ex.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    public static SDPParser createParser(String field) throws ParseException {
        String fieldName = Lexer.getFieldName(field);
        if (fieldName == null) {
            return null;
        }
        Class parserClass = (Class)parserTable.get(fieldName.toLowerCase());
        if (parserClass != null) {
            try {
                Constructor cons = parserClass.getConstructor(constructorArgs);
                Object[] args = new Object[]{field};
                SDPParser retval = (SDPParser)cons.newInstance(args);
                return retval;
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
                return null;
            }
        }
        throw new ParseException("Could not find parser for " + fieldName, 0);
    }

    static {
        constructorArgs = new Class[1];
        ParserFactory.constructorArgs[0] = new String().getClass();
        parserTable = new Hashtable();
        parserTable.put("a", ParserFactory.getParser("AttributeFieldParser"));
        parserTable.put("b", ParserFactory.getParser("BandwidthFieldParser"));
        parserTable.put("c", ParserFactory.getParser("ConnectionFieldParser"));
        parserTable.put("e", ParserFactory.getParser("EmailFieldParser"));
        parserTable.put("i", ParserFactory.getParser("InformationFieldParser"));
        parserTable.put("k", ParserFactory.getParser("KeyFieldParser"));
        parserTable.put("m", ParserFactory.getParser("MediaFieldParser"));
        parserTable.put("o", ParserFactory.getParser("OriginFieldParser"));
        parserTable.put("p", ParserFactory.getParser("PhoneFieldParser"));
        parserTable.put("v", ParserFactory.getParser("ProtoVersionFieldParser"));
        parserTable.put("r", ParserFactory.getParser("RepeatFieldParser"));
        parserTable.put("s", ParserFactory.getParser("SessionNameFieldParser"));
        parserTable.put("t", ParserFactory.getParser("TimeFieldParser"));
        parserTable.put("u", ParserFactory.getParser("URIFieldParser"));
        parserTable.put("z", ParserFactory.getParser("ZoneFieldParser"));
    }
}

