/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.core.InternalErrorHandler;
import gov.nist.core.LogWriter;
import gov.nist.javax.sip.EventScanner;
import gov.nist.javax.sip.EventWrapper;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.HopImpl;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionErrorEvent;
import gov.nist.javax.sip.stack.SIPTransactionEventListener;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.EventObject;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TooManyListenersException;
import javax.sip.ClientTransaction;
import javax.sip.ListeningPoint;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.Timeout;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Hop;
import javax.sip.header.CallIdHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;

public final class SipProviderImpl
implements SipProvider,
SIPTransactionEventListener {
    protected SipListener sipListener;
    protected boolean isActive;
    private SIPTransactionStack sipStack;
    protected SipStackImpl sipStackImpl;
    protected ListeningPointImpl listeningPoint;
    protected EventScanner eventScanner;

    protected void stop() {
        if (LogWriter.needsLogging) {
            this.sipStackImpl.logMessage("Exiting provider");
        }
        this.listeningPoint.removeSipProvider();
        this.eventScanner.stop();
    }

    public void handleEvent(EventObject sipEvent, SIPTransaction transaction) {
        if (LogWriter.needsLogging) {
            this.sipStackImpl.logMessage("handleEvent " + sipEvent + "currentTransaction = " + transaction + "this.sipListener = " + this.sipListener + "sipEvent.source = " + sipEvent.getSource());
            this.sipStackImpl.logStackTrace();
        }
        EventWrapper eventWrapper = new EventWrapper();
        eventWrapper.sipEvent = sipEvent;
        eventWrapper.transaction = transaction;
        if (transaction != null) {
            transaction.setEventPending();
        }
        if (!this.sipStackImpl.reEntrantListener) {
            this.eventScanner.addEvent(eventWrapper);
        } else {
            this.eventScanner.deliverEvent(eventWrapper);
        }
    }

    protected SipProviderImpl(EventScanner eventScanner) {
        this.eventScanner = eventScanner;
        ++this.eventScanner.refCount;
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSipListener(SipListener sipListener) throws TooManyListenersException {
        SipProviderImpl provider;
        Iterator it;
        SipStackImpl sipStackImpl = this.sipStackImpl;
        synchronized (sipStackImpl) {
            it = this.sipStackImpl.getSipProviders();
            while (it.hasNext()) {
                provider = (SipProviderImpl)it.next();
                if (provider.sipListener == null || provider.sipListener == sipListener) continue;
                throw new TooManyListenersException();
            }
        }
        if (LogWriter.needsLogging) {
            this.sipStackImpl.logMessage("add SipListener " + sipListener);
        }
        this.sipListener = sipListener;
        sipStackImpl = this.sipStackImpl;
        synchronized (sipStackImpl) {
            it = this.sipStackImpl.getSipProviders();
            while (it.hasNext()) {
                provider = (SipProviderImpl)it.next();
                provider.sipListener = sipListener;
            }
        }
    }

    public ListeningPoint getListeningPoint() {
        return this.listeningPoint;
    }

    public CallIdHeader getNewCallId() {
        String callId = Utils.generateCallIdentifier(this.getSipStack().getIPAddress());
        CallID callid = new CallID();
        try {
            callid.setCallId(callId);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return callid;
    }

    public ClientTransaction getNewClientTransaction(Request request) throws TransactionUnavailableException {
        SIPRequest sipRequest;
        block22: {
            SIPClientTransaction ct;
            if (request == null) {
                throw new NullPointerException("null request");
            }
            sipRequest = (SIPRequest)request;
            if (sipRequest.getTransaction() != null) {
                throw new TransactionUnavailableException("Transaction already assigned to request");
            }
            if (request.getMethod().equalsIgnoreCase("CANCEL") && (ct = (SIPClientTransaction)this.sipStack.findCancelTransaction((SIPRequest)request, false)) != null) {
                SIPClientTransaction retval = this.sipStack.createClientTransaction(ct.getMessageChannel());
                ((SIPTransaction)retval).setOriginalRequest((SIPRequest)request);
                ((SIPTransaction)retval).addEventListener(this);
                this.sipStack.addTransaction(retval);
                retval.setDialog((SIPDialog)ct.getDialog());
                return retval;
            }
            if (LogWriter.needsLogging) {
                this.sipStackImpl.logMessage("could not find existing transaction for " + ((SIPRequest)request).getFirstLine());
            }
            ListIterator it = this.sipStackImpl.getRouter().getNextHops(request);
            String dialogId = sipRequest.getDialogId(false);
            SIPDialog dialog = this.sipStack.getDialog(dialogId);
            if (it == null || !it.hasNext()) {
                if (dialog != null) {
                    try {
                        HopImpl hop = dialog.getNextHop();
                        if (hop != null) {
                            SIPClientTransaction ct2 = (SIPClientTransaction)this.sipStack.createMessageChannel(hop);
                            String branchId = Utils.generateBranchId();
                            if (sipRequest.getTopmostVia() != null) {
                                sipRequest.getTopmostVia().setBranch(branchId);
                            } else {
                                Via via = this.listeningPoint.messageProcessor.getViaHeader();
                                sipRequest.addHeader(via);
                            }
                            ct2.setOriginalRequest(sipRequest);
                            ct2.setBranch(branchId);
                            ct2.setDialog(dialog);
                            ct2.addEventListener(this);
                            return ct2;
                        }
                        break block22;
                    }
                    catch (Exception ex) {
                        throw new TransactionUnavailableException(ex.getMessage());
                    }
                }
                throw new TransactionUnavailableException("no route!");
            }
            while (it.hasNext()) {
                Hop hop = (Hop)it.next();
                try {
                    SIPClientTransaction ct3 = (SIPClientTransaction)this.sipStack.createMessageChannel(hop);
                    if (ct3 == null) continue;
                    String branchId = Utils.generateBranchId();
                    if (sipRequest.getTopmostVia() != null) {
                        sipRequest.getTopmostVia().setBranch(branchId);
                    } else {
                        Via via = this.listeningPoint.messageProcessor.getViaHeader();
                        sipRequest.addHeader(via);
                    }
                    ct3.setOriginalRequest(sipRequest);
                    ct3.setBranch(branchId);
                    if (this.sipStack.isDialogCreated(request.getMethod())) {
                        if (dialog != null) {
                            ct3.setDialog(dialog);
                        } else {
                            this.sipStack.createDialog(ct3);
                        }
                    } else {
                        ct3.setDialog(dialog);
                    }
                    ct3.addEventListener(this);
                    return ct3;
                }
                catch (UnknownHostException ex) {
                }
                catch (ParseException ex) {
                    InternalErrorHandler.handleException(ex);
                }
            }
        }
        if (LogWriter.needsLogging) {
            this.sipStackImpl.logMessage("Error processing " + sipRequest);
        }
        throw new TransactionUnavailableException("Could not resolve next hop or listening point unavailable! ");
    }

    public ServerTransaction getNewServerTransaction(Request request) throws TransactionAlreadyExistsException, TransactionUnavailableException {
        SIPServerTransaction transaction = null;
        SIPRequest sipRequest = (SIPRequest)request;
        if (this.sipStack.isDialogCreated(sipRequest.getMethod())) {
            if (this.sipStack.findTransaction((SIPRequest)request, true) != null) {
                throw new TransactionAlreadyExistsException("server transaction already exists!");
            }
            if (!this.sipStack.hasResources()) {
                throw new TransactionUnavailableException("Resource Not available!");
            }
            transaction = (SIPServerTransaction)((SIPRequest)request).getTransaction();
            if (transaction == null) {
                throw new TransactionUnavailableException("Transaction not available");
            }
            if (transaction.getOriginalRequest() == null) {
                transaction.setOriginalRequest(sipRequest);
            }
            try {
                this.sipStack.addTransaction(transaction);
            }
            catch (IOException ex) {
                throw new TransactionUnavailableException("Error sending provisional response");
            }
            transaction.addEventListener(this);
            String dialogId = sipRequest.getDialogId(true);
            SIPDialog dialog = this.sipStack.getDialog(dialogId);
            if (dialog == null) {
                dialog = this.sipStack.createDialog(transaction);
            } else {
                transaction.setDialog(dialog);
            }
            dialog.setStack(this.sipStack);
            dialog.addRoute(sipRequest);
            if (dialog.getRemoteTag() != null && dialog.getLocalTag() != null) {
                this.sipStack.putDialog(dialog);
            }
        } else {
            transaction = (SIPServerTransaction)this.sipStack.findTransaction((SIPRequest)request, true);
            if (transaction != null) {
                throw new TransactionAlreadyExistsException("Transaction exists! ");
            }
            transaction = (SIPServerTransaction)((SIPRequest)request).getTransaction();
            if (transaction == null) {
                throw new TransactionUnavailableException("Transaction not available!");
            }
            if (transaction.getOriginalRequest() == null) {
                transaction.setOriginalRequest(sipRequest);
            }
            try {
                this.sipStack.addTransaction(transaction);
            }
            catch (IOException ex) {
                throw new TransactionUnavailableException("Could not send back provisional response!");
            }
            String dialogId = sipRequest.getDialogId(true);
            SIPDialog dialog = this.sipStack.getDialog(dialogId);
            if (dialog != null) {
                dialog.addTransaction(transaction);
                dialog.addRoute(sipRequest);
            }
        }
        return transaction;
    }

    public SipStack getSipStack() {
        return this.sipStackImpl;
    }

    public void removeSipListener(SipListener sipListener) {
        if (sipListener == this.sipListener) {
            this.sipListener = null;
        }
    }

    public void sendRequest(Request request) throws SipException {
        ListIterator it = this.sipStack.getRouter().getNextHops(request);
        if (it == null || !it.hasNext()) {
            throw new SipException("could not determine next hop!");
        }
        if (((SIPRequest)request).getTopmostVia() == null) {
            throw new SipException("Invalid SipRequest -- no via header!");
        }
        SIPTransaction tr = this.sipStack.findTransaction((SIPRequest)request, false);
        if (tr != null) {
            throw new SipException("Cannot send statelessly Transaction found!");
        }
        while (it.hasNext()) {
            Hop nextHop = (Hop)it.next();
            try {
                SIPRequest sipRequest = (SIPRequest)request;
                String bid = sipRequest.getTransactionId();
                Via via = sipRequest.getTopmostVia();
                via.setBranch(bid);
                SIPRequest newRequest = sipRequest;
                MessageChannel messageChannel = this.sipStack.createRawMessageChannel(nextHop);
                if (messageChannel != null) {
                    messageChannel.sendMessage(newRequest);
                    continue;
                }
                throw new SipException("could not forward request");
            }
            catch (IOException ex) {
                throw new SipException(ex.getMessage());
            }
            catch (ParseException ex1) {
                InternalErrorHandler.handleException(ex1);
            }
        }
    }

    public void sendResponse(Response response) throws SipException {
        SIPResponse sipResponse = (SIPResponse)response;
        Via via = sipResponse.getTopmostVia();
        if (via == null) {
            throw new SipException("No via header in response!");
        }
        int port = via.getPort();
        String transport = via.getTransport();
        String host = via.getReceived();
        if (host == null) {
            host = via.getHost();
        }
        if (port == -1) {
            port = 5060;
        }
        HopImpl hop = new HopImpl(host + ":" + port + "/" + transport);
        try {
            MessageChannel messageChannel = this.sipStack.createRawMessageChannel(hop);
            messageChannel.sendMessage(sipResponse);
        }
        catch (IOException ex) {
            throw new SipException(ex.getMessage());
        }
    }

    public void setListeningPoint(ListeningPoint listeningPoint) {
        if (listeningPoint == null) {
            throw new NullPointerException("Null listening point");
        }
        ListeningPointImpl lp = (ListeningPointImpl)listeningPoint;
        lp.sipProviderImpl = this;
        this.listeningPoint = (ListeningPointImpl)listeningPoint;
    }

    protected void setSipStack(SipStackImpl sipStackImpl) {
        this.sipStackImpl = sipStackImpl;
        this.sipStack = sipStackImpl;
    }

    public void transactionErrorEvent(SIPTransactionErrorEvent transactionErrorEvent) {
        SIPTransaction transaction = (SIPTransaction)transactionErrorEvent.getSource();
        if (transactionErrorEvent.getErrorID() == 2) {
            if (LogWriter.needsLogging) {
                this.sipStackImpl.logMessage("TransportError occured on " + transaction);
            }
            Object errorObject = transactionErrorEvent.getSource();
            Timeout timeout = Timeout.TRANSACTION;
            TimeoutEvent ev = null;
            ev = errorObject instanceof SIPServerTransaction ? new TimeoutEvent((Object)this, (ServerTransaction)errorObject, timeout) : new TimeoutEvent((Object)this, (ClientTransaction)errorObject, timeout);
            this.handleEvent(ev, (SIPTransaction)errorObject);
        } else if (transactionErrorEvent.getErrorID() == 1) {
            Object errorObject = transactionErrorEvent.getSource();
            Timeout timeout = Timeout.TRANSACTION;
            TimeoutEvent ev = null;
            ev = errorObject instanceof SIPServerTransaction ? new TimeoutEvent((Object)this, (ServerTransaction)errorObject, timeout) : new TimeoutEvent((Object)this, (ClientTransaction)errorObject, timeout);
            this.handleEvent(ev, (SIPTransaction)errorObject);
        } else if (transactionErrorEvent.getErrorID() == 3) {
            if (this.sipStackImpl.isRetransmissionFilterActive()) {
                InternalErrorHandler.handleException("Unexpected event !");
            }
            Object errorObject = transactionErrorEvent.getSource();
            Timeout timeout = Timeout.RETRANSMIT;
            TimeoutEvent ev = null;
            ev = errorObject instanceof SIPServerTransaction ? new TimeoutEvent((Object)this, (ServerTransaction)errorObject, timeout) : new TimeoutEvent((Object)this, (ClientTransaction)errorObject, timeout);
            this.handleEvent(ev, (SIPTransaction)errorObject);
        }
    }
}

