/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.header.AddressParametersHeader;
import gov.nist.javax.sip.header.ContactList;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.address.Address;
import javax.sip.header.ContactHeader;

public final class Contact
extends AddressParametersHeader
implements ContactHeader {
    public static final String ACTION = "action";
    public static final String PROXY = "proxy";
    public static final String REDIRECT = "redirect";
    public static final String EXPIRES = "expires";
    public static final String Q = "q";
    private ContactList contactList;
    protected boolean wildCardFlag;

    public Contact() {
        super("Contact");
    }

    public void setParameter(String name, String value) throws ParseException {
        NameValue nv = this.parameters.getNameValue(name);
        if (nv != null) {
            nv.setValue(value);
        } else {
            nv = new NameValue(name, value);
            if (name.equalsIgnoreCase("methods")) {
                nv.setQuotedValue();
            }
            this.parameters.set(nv);
        }
    }

    protected String encodeBody() {
        StringBuffer encoding = new StringBuffer();
        if (this.wildCardFlag) {
            return encoding.append("*").toString();
        }
        if (this.address.getAddressType() == 1) {
            encoding.append(this.address.encode());
        } else {
            encoding.append("<").append(this.address.encode()).append(">");
        }
        if (!this.parameters.isEmpty()) {
            encoding.append(";").append(this.parameters.encode());
        }
        return encoding.toString();
    }

    public ContactList getContactList() {
        return this.contactList;
    }

    public boolean getWildCardFlag() {
        return this.wildCardFlag;
    }

    public Address getAddress() {
        return this.address;
    }

    public NameValueList getContactParms() {
        return this.parameters;
    }

    public int getExpires() {
        return this.getParameterAsInt(EXPIRES);
    }

    public void setExpires(int expiryDeltaSeconds) {
        Integer deltaSeconds = new Integer(expiryDeltaSeconds);
        this.parameters.set(EXPIRES, deltaSeconds);
    }

    public float getQValue() {
        return this.getParameterAsFloat(Q);
    }

    public void setContactList(ContactList cl) {
        this.contactList = cl;
    }

    public void setWildCardFlag(boolean w) {
        this.wildCardFlag = true;
        this.address = new AddressImpl();
        this.address.setWildCardFlag();
    }

    public void setAddress(Address address) {
        if (address == null) {
            throw new NullPointerException("null address");
        }
        this.address = (AddressImpl)address;
        this.wildCardFlag = false;
    }

    public void setQValue(float qValue) throws InvalidArgumentException {
        if (qValue != -1.0f && (qValue < 0.0f || qValue > 1.0f)) {
            throw new InvalidArgumentException("JAIN-SIP Exception, Contact, setQValue(), the qValue is not between 0 and 1");
        }
        this.parameters.set(Q, new Float(qValue));
    }

    public boolean equals(Object that) {
        if (that.getClass() != this.getClass()) {
            return false;
        }
        Contact contact = (Contact)that;
        if (this.wildCardFlag != contact.wildCardFlag) {
            return false;
        }
        if (this.wildCardFlag == contact.wildCardFlag) {
            return true;
        }
        return super.equals(that);
    }
}

