/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.SIPHeader;
import javax.sip.InvalidArgumentException;
import javax.sip.header.TimeStampHeader;

public class TimeStamp
extends SIPHeader
implements TimeStampHeader {
    protected float timeStamp;
    protected float delay = -1.0f;

    public TimeStamp() {
        super("Timestamp");
    }

    public String encodeBody() {
        if (this.delay != -1.0f) {
            return new Float(this.timeStamp).toString() + " " + new Float(this.delay).toString();
        }
        return new Float(this.timeStamp).toString();
    }

    public boolean hasDelay() {
        return this.delay != -1.0f;
    }

    public void removeDelay() {
        this.delay = -1.0f;
    }

    public void setTimeStamp(float timeStamp) throws InvalidArgumentException {
        if (timeStamp < 0.0f) {
            throw new InvalidArgumentException("JAIN-SIP Exception, TimeStamp, setTimeStamp(), the timeStamp parameter is <0");
        }
        this.timeStamp = timeStamp;
    }

    public float getTimeStamp() {
        return this.timeStamp;
    }

    public float getDelay() {
        return this.delay;
    }

    public void setDelay(float delay) throws InvalidArgumentException {
        if (delay < 0.0f && delay != -1.0f) {
            throw new InvalidArgumentException("JAIN-SIP Exception, TimeStamp, setDelay(), the delay parameter is <0");
        }
        this.delay = delay;
    }
}

