/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.header.ParametersHeader;
import gov.nist.javax.sip.header.Protocol;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.header.ViaHeader;

public class Via
extends ParametersHeader
implements ViaHeader {
    public static final String BRANCH = "branch";
    public static final String RECEIVED = "received";
    public static final String MADDR = "maddr";
    public static final String TTL = "ttl";
    protected Protocol sentProtocol = new Protocol();
    protected HostPort sentBy;
    protected String comment;

    public Via() {
        super("Via");
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        Via that = (Via)other;
        if (!this.sentProtocol.equals(that.sentProtocol)) {
            return false;
        }
        return this.sentBy.equals(that.sentBy);
    }

    public String getProtocolVersion() {
        if (this.sentProtocol == null) {
            return null;
        }
        return this.sentProtocol.getProtocolVersion();
    }

    public Protocol getSentProtocol() {
        return this.sentProtocol;
    }

    public HostPort getSentBy() {
        return this.sentBy;
    }

    public NameValueList getViaParms() {
        return this.parameters;
    }

    public String getComment() {
        return this.comment;
    }

    public Host getMaddr() {
        return (Host)this.parameters.getValue(MADDR);
    }

    public boolean hasPort() {
        return this.getSentBy().hasPort();
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public void removePort() {
        this.sentBy.removePort();
    }

    public void removeComment() {
        this.comment = null;
    }

    public void setProtocolVersion(String protocolVersion) {
        if (this.sentProtocol == null) {
            this.sentProtocol = new Protocol();
        }
        this.sentProtocol.setProtocolVersion(protocolVersion);
    }

    public void setHost(Host host) {
        if (this.sentBy == null) {
            this.sentBy = new HostPort();
        }
        this.sentBy.setHost(host);
    }

    public void setSentProtocol(Protocol s) {
        this.sentProtocol = s;
    }

    public void setSentBy(HostPort s) {
        this.sentBy = s;
    }

    public void setComment(String c) {
        this.comment = c;
    }

    protected String encodeBody() {
        StringBuffer encoding = new StringBuffer();
        encoding.append(this.sentProtocol.encode()).append(" ").append(this.sentBy.encode());
        if (!this.parameters.isEmpty()) {
            encoding.append(";").append(this.parameters.encode());
        }
        if (this.comment != null) {
            encoding.append(" ").append("(").append(this.comment).append(")");
        }
        return encoding.toString();
    }

    public void setHost(String host) throws ParseException {
        if (this.sentBy == null) {
            this.sentBy = new HostPort();
        }
        try {
            Host h = new Host(host);
            this.sentBy.setHost(h);
        }
        catch (Exception e) {
            throw new NullPointerException(" host parameter is null");
        }
    }

    public String getHost() {
        if (this.sentBy == null) {
            return null;
        }
        Host host = this.sentBy.getHost();
        if (host == null) {
            return null;
        }
        return host.getHostname();
    }

    public void setPort(int port) {
        if (this.sentBy == null) {
            this.sentBy = new HostPort();
        }
        this.sentBy.setPort(port);
    }

    public int getPort() {
        if (this.sentBy == null) {
            return -1;
        }
        return this.sentBy.getPort();
    }

    public String getTransport() {
        if (this.sentProtocol == null) {
            return null;
        }
        return this.sentProtocol.getTransport();
    }

    public void setTransport(String transport) throws ParseException {
        if (transport == null) {
            throw new NullPointerException("JAIN-SIP Exception, Via, setTransport(), the transport parameter is null.");
        }
        if (this.sentProtocol == null) {
            this.sentProtocol = new Protocol();
        }
        this.sentProtocol.setTransport(transport);
    }

    public String getProtocol() {
        if (this.sentProtocol == null) {
            return null;
        }
        return this.sentProtocol.getProtocolName();
    }

    public void setProtocol(String protocol) throws ParseException {
        if (protocol == null) {
            throw new NullPointerException("JAIN-SIP Exception, Via, setProtocol(), the protocol parameter is null.");
        }
        if (this.sentProtocol == null) {
            this.sentProtocol = new Protocol();
        }
        this.sentProtocol.setProtocolName(protocol);
    }

    public int getTTL() {
        int ttl = this.getParameterAsInt(TTL);
        return ttl;
    }

    public void setTTL(int ttl) throws InvalidArgumentException {
        if (ttl < 0 && ttl != -1) {
            throw new InvalidArgumentException("JAIN-SIP Exception, Via, setTTL(), the ttl parameter is < 0");
        }
        this.setParameter(new NameValue(TTL, new Integer(ttl)));
    }

    public String getMAddr() {
        return this.getParameter(MADDR);
    }

    public void setMAddr(String mAddr) throws ParseException {
        if (mAddr == null) {
            throw new NullPointerException("JAIN-SIP Exception, Via, setMAddr(), the mAddr parameter is null.");
        }
        Host host = new Host();
        host.setAddress(mAddr);
        NameValue nameValue = new NameValue(MADDR, host);
        this.setParameter(nameValue);
    }

    public String getReceived() {
        return this.getParameter(RECEIVED);
    }

    public void setReceived(String received) throws ParseException {
        if (received == null) {
            throw new NullPointerException("JAIN-SIP Exception, Via, setReceived(), the received parameter is null.");
        }
        this.setParameter(RECEIVED, received);
    }

    public String getBranch() {
        return this.getParameter(BRANCH);
    }

    public void setBranch(String branch) throws ParseException {
        if (branch == null) {
            throw new NullPointerException("JAIN-SIP Exception, Via, setBranch(), the branch parameter is null.");
        }
        this.setParameter(BRANCH, branch);
    }
}

