/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.core.LogWriter;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.ParseExceptionListener;
import gov.nist.javax.sip.parser.StringMsgParser;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPMessageStack;
import gov.nist.javax.sip.stack.ServerLog;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.UDPMessageProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.LinkedList;

public class UDPMessageChannel
extends MessageChannel
implements ParseExceptionListener,
Runnable {
    protected SIPMessageStack stack;
    protected StringMsgParser myParser;
    private InetAddress peerAddress;
    private String myAddress;
    private int peerPort;
    private String peerProtocol;
    protected int myPort;
    private byte[] msgBytes;
    private DatagramPacket incomingPacket;
    private long receptionTime;

    protected UDPMessageChannel(SIPMessageStack stack, UDPMessageProcessor messageProcessor) {
        this.messageProcessor = messageProcessor;
        this.stack = stack;
        Thread mythread = new Thread(this);
        mythread.setName("UDPMessageChannelThread");
        mythread.setDaemon(true);
        mythread.start();
    }

    protected UDPMessageChannel(SIPMessageStack stack, UDPMessageProcessor messageProcessor, DatagramPacket packet) {
        this.incomingPacket = packet;
        this.messageProcessor = messageProcessor;
        this.stack = stack;
        this.myAddress = stack.getHostAddress();
        this.myPort = messageProcessor.getPort();
        Thread mythread = new Thread(this);
        mythread.setDaemon(true);
        mythread.start();
    }

    protected UDPMessageChannel(InetAddress targetAddr, int port, SIPMessageStack sipStack, UDPMessageProcessor messageProcessor) {
        this.peerAddress = targetAddr;
        this.peerPort = port;
        this.peerProtocol = "UDP";
        this.messageProcessor = messageProcessor;
        this.myAddress = sipStack.getHostAddress();
        this.myPort = messageProcessor.getPort();
        this.stack = sipStack;
        if (LogWriter.needsLogging) {
            this.stack.logWriter.logMessage("Creating message channel " + targetAddr.getHostAddress() + "/" + port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            DatagramPacket packet;
            if (this.myParser == null) {
                this.myParser = new StringMsgParser();
                this.myParser.setParseExceptionListener(this);
            }
            if (this.stack.threadPoolSize != -1) {
                LinkedList linkedList = ((UDPMessageProcessor)this.messageProcessor).messageQueue;
                synchronized (linkedList) {
                    while (((UDPMessageProcessor)this.messageProcessor).messageQueue.isEmpty()) {
                        if (!((UDPMessageProcessor)this.messageProcessor).isRunning) {
                            return;
                        }
                        try {
                            ((UDPMessageProcessor)this.messageProcessor).messageQueue.wait();
                        }
                        catch (InterruptedException ex) {
                            if (((UDPMessageProcessor)this.messageProcessor).isRunning) continue;
                            return;
                        }
                    }
                    packet = (DatagramPacket)((UDPMessageProcessor)this.messageProcessor).messageQueue.removeFirst();
                }
                this.incomingPacket = packet;
            } else {
                packet = this.incomingPacket;
            }
            this.peerAddress = packet.getAddress();
            int packetLength = packet.getLength();
            byte[] bytes = packet.getData();
            byte[] msgBytes = new byte[packetLength];
            System.arraycopy(bytes, 0, msgBytes, 0, packetLength);
            if (LogWriter.needsLogging) {
                this.stack.logWriter.logMessage("UDPMessageChannel: peerAddress = " + this.peerAddress.getHostAddress() + "/" + packet.getPort());
                this.stack.logWriter.logMessage("Length = " + packetLength);
                String msgString = new String(msgBytes, 0, packetLength);
                this.stack.logWriter.logMessage(msgString);
            }
            Object sipMessages = null;
            SIPMessage sipMessage = null;
            try {
                this.receptionTime = System.currentTimeMillis();
                sipMessage = this.myParser.parseSIPMessage(msgBytes);
                this.myParser = null;
            }
            catch (ParseException ex) {
                this.myParser = null;
                if (LogWriter.needsLogging) {
                    this.stack.logWriter.logMessage("Rejecting message !  " + new String(msgBytes));
                    this.stack.logWriter.logMessage("error message " + ex.getMessage());
                    this.stack.logWriter.logException(ex);
                }
                this.stack.logBadMessage(new String(msgBytes));
                if (this.stack.threadPoolSize != -1) continue;
                return;
            }
            if (sipMessage == null) {
                if (LogWriter.needsLogging) {
                    this.stack.logWriter.logMessage("Rejecting message !  " + new String(msgBytes));
                    this.stack.logWriter.logMessage("Null message parsed.");
                }
                if (this.stack.threadPoolSize != -1) continue;
                return;
            }
            ViaList viaList = sipMessage.getViaHeaders();
            if (sipMessage.getFrom() == null || sipMessage.getTo() == null || sipMessage.getCallId() == null || sipMessage.getCSeq() == null || sipMessage.getViaHeaders() == null) {
                String badmsg = new String(msgBytes);
                if (LogWriter.needsLogging) {
                    this.stack.logWriter.logMessage("bad message " + badmsg);
                    this.stack.logWriter.logMessage(">>> Dropped Bad Msg From = " + sipMessage.getFrom() + "To = " + sipMessage.getTo() + "CallId = " + sipMessage.getCallId() + "CSeq = " + sipMessage.getCSeq() + "Via = " + sipMessage.getViaHeaders());
                }
                this.stack.logBadMessage(badmsg);
                if (this.stack.threadPoolSize != -1) continue;
                return;
            }
            if (sipMessage instanceof SIPRequest) {
                Via v = (Via)viaList.first();
                if (v.hasPort()) {
                    if (sipMessage instanceof SIPRequest) {
                        this.peerPort = v.getPort();
                    }
                } else {
                    this.peerPort = 5060;
                }
                this.peerProtocol = v.getTransport();
                try {
                    this.peerAddress = packet.getAddress();
                    if (!v.getSentBy().getInetAddress().equals(this.peerAddress)) {
                        v.setParameter("received", this.peerAddress.getHostName());
                    }
                }
                catch (UnknownHostException ex) {
                    if (this.stack.serverLog.needsLogging(ServerLog.TRACE_MESSAGES)) {
                        this.stack.serverLog.logMessage(sipMessage, this.getViaHost() + ":" + this.getViaPort(), this.stack.getHostAddress() + ":" + this.stack.getPort(this.getTransport()), "Dropped -- Could not resolve VIA header address!", false);
                    }
                    if (!LogWriter.needsLogging) continue;
                    this.stack.logWriter.logMessage("Rejecting message -- could not resolve Via Address");
                    continue;
                }
                catch (ParseException ex1) {
                    InternalErrorHandler.handleException(ex1);
                }
            }
            if (sipMessage instanceof SIPRequest) {
                SIPRequest sipRequest = (SIPRequest)sipMessage;
                ServerRequestInterface sipServerRequest = this.stack.newSIPServerRequest(sipRequest, this);
                if (sipServerRequest == null) {
                    if (!LogWriter.needsLogging) continue;
                    this.stack.logWriter.logMessage("Null request interface returned");
                    continue;
                }
                if (LogWriter.needsLogging) {
                    this.stack.logWriter.logMessage("About to process " + sipRequest.getFirstLine() + "/" + sipServerRequest);
                }
                sipServerRequest.processRequest(sipRequest, this);
                if (LogWriter.needsLogging) {
                    this.stack.logWriter.logMessage("Done processing " + sipRequest.getFirstLine() + "/" + sipServerRequest);
                }
                if (this.stack.serverLog.needsLogging(ServerLog.TRACE_MESSAGES)) {
                    if (sipServerRequest.getProcessingInfo() == null) {
                        this.stack.serverLog.logMessage(sipMessage, sipRequest.getViaHost() + ":" + sipRequest.getViaPort(), this.stack.getHostAddress() + ":" + this.stack.getPort(this.getTransport()), false, new Long(this.receptionTime).toString());
                    } else {
                        this.stack.serverLog.logMessage(sipMessage, sipRequest.getViaHost() + ":" + sipRequest.getViaPort(), this.stack.getHostAddress() + ":" + this.stack.getPort(this.getTransport()), sipServerRequest.getProcessingInfo(), false, new Long(this.receptionTime).toString());
                    }
                }
            } else {
                SIPResponse sipResponse = (SIPResponse)sipMessage;
                ServerResponseInterface sipServerResponse = this.stack.newSIPServerResponse(sipResponse, this);
                if (sipServerResponse != null) {
                    sipServerResponse.processResponse(sipResponse, this);
                } else if (LogWriter.needsLogging) {
                    this.stack.logWriter.logMessage("null sipServerResponse!");
                }
            }
            if (this.stack.threadPoolSize == -1) break;
        }
    }

    public void handleException(ParseException ex, SIPMessage sipMessage, Class hdrClass, String header, String message) throws ParseException {
        if (LogWriter.needsLogging) {
            this.stack.logWriter.logException(ex);
        }
        if (hdrClass != null && (hdrClass.equals(From.class) || hdrClass.equals(To.class) || hdrClass.equals(CSeq.class) || hdrClass.equals(Via.class) || hdrClass.equals(CallID.class) || hdrClass.equals(RequestLine.class) || hdrClass.equals(StatusLine.class))) {
            this.stack.logBadMessage(message);
            throw ex;
        }
        sipMessage.addUnparsed(header);
    }

    public void sendMessage(SIPMessage sipMessage) throws IOException {
        if (LogWriter.needsLogging) {
            this.stack.logWriter.logStackTrace();
        }
        byte[] msg = sipMessage.encodeAsBytes();
        long time = System.currentTimeMillis();
        this.sendMessage(msg, this.peerAddress, this.peerPort, this.peerProtocol, sipMessage instanceof SIPRequest);
        if (this.stack.serverLog.needsLogging(ServerLog.TRACE_MESSAGES)) {
            this.logMessage(sipMessage, this.peerAddress, this.peerPort, time);
        }
    }

    protected void sendMessage(byte[] msg, InetAddress peerAddress, int peerPort, boolean reConnect) throws IOException {
        if (LogWriter.needsLogging) {
            this.stack.logWriter.logStackTrace();
        }
        if (peerPort == -1) {
            if (LogWriter.needsLogging) {
                this.stack.logWriter.logMessage(this.getClass().getName() + ":sendMessage: Dropping reply!");
            }
            throw new IOException("Receiver port not set ");
        }
        if (LogWriter.needsLogging) {
            this.stack.logWriter.logMessage(this.getClass().getName() + ":sendMessage " + peerAddress.getHostAddress() + "/" + peerPort + "\n" + new String(msg));
            this.stack.logWriter.logMessage("*******************\n");
        }
        DatagramPacket reply = new DatagramPacket(msg, msg.length, peerAddress, peerPort);
        try {
            DatagramSocket sock = this.stack.udpFlag ? ((UDPMessageProcessor)this.messageProcessor).sock : new DatagramSocket();
            sock.send(reply);
            if (!this.stack.udpFlag) {
                sock.close();
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendMessage(byte[] msg, InetAddress peerAddress, int peerPort, String peerProtocol, boolean retry) throws IOException {
        if (peerPort == -1) {
            if (!LogWriter.needsLogging) throw new IOException("Receiver port not set ");
            this.stack.logWriter.logMessage(this.getClass().getName() + ":sendMessage: Dropping reply!");
            throw new IOException("Receiver port not set ");
        }
        if (LogWriter.needsLogging) {
            this.stack.logWriter.logMessage(this.getClass().getName() + ":sendMessage " + peerAddress.getHostAddress() + "/" + peerPort + "\n" + new String(msg));
            this.stack.logWriter.logMessage("*******************\n");
        }
        if (peerProtocol.compareToIgnoreCase("UDP") == 0) {
            DatagramPacket reply = new DatagramPacket(msg, msg.length, peerAddress, peerPort);
            try {
                DatagramSocket sock = this.stack.udpFlag ? ((UDPMessageProcessor)this.messageProcessor).sock : new DatagramSocket();
                sock.send(reply);
                if (this.stack.udpFlag) return;
                sock.close();
                return;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
                return;
            }
        } else {
            Socket outputSocket = this.stack.ioHandler.sendBytes(peerAddress, peerPort, "tcp", msg, retry);
            OutputStream myOutputStream = outputSocket.getOutputStream();
            myOutputStream.write(msg, 0, msg.length);
            myOutputStream.flush();
        }
    }

    public SIPMessageStack getSIPStack() {
        return this.stack;
    }

    public String getTransport() {
        return "udp";
    }

    public String getHost() {
        return this.stack.stackAddress;
    }

    public int getPort() {
        return ((UDPMessageProcessor)this.messageProcessor).getPort();
    }

    public String getPeerName() {
        return this.peerAddress.getHostName();
    }

    public String getPeerAddress() {
        return this.peerAddress.getHostAddress();
    }

    protected InetAddress getPeerInetAddress() {
        return this.peerAddress;
    }

    public boolean equals(Object other) {
        boolean retval;
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            retval = false;
        } else {
            UDPMessageChannel that = (UDPMessageChannel)other;
            retval = this.getKey().equals(that.getKey());
        }
        return retval;
    }

    public String getKey() {
        return UDPMessageChannel.getKey(this.peerAddress, this.peerPort, "UDP");
    }

    public String getViaHost() {
        return this.myAddress;
    }

    public int getViaPort() {
        return this.myPort;
    }

    public boolean isReliable() {
        return false;
    }

    public boolean isSecure() {
        return false;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public String getPeerProtocol() {
        return this.peerProtocol;
    }

    public void close() {
    }
}

