/*
 * Decompiled with CFR 0.152.
 */
package net.java.stun4j.attribute;

import net.java.stun4j.StunAddress;
import net.java.stun4j.StunException;
import net.java.stun4j.attribute.Attribute;

abstract class AddressAttribute
extends Attribute {
    static final byte family = 1;
    protected StunAddress address = null;
    public static final char DATA_LENGTH = '\b';

    AddressAttribute(char attributeType) {
        super(attributeType);
    }

    private boolean isTypeValid(char type) {
        return type == '\u0001' || type == '\u0002' || type == '\u0004' || type == '\u0005' || type == '\u000b';
    }

    protected void setAttributeType(char type) {
        if (!this.isTypeValid(type)) {
            throw new IllegalArgumentException(type + "is not a valid address attribute!");
        }
        super.setAttributeType(type);
    }

    public String getName() {
        switch (this.getAttributeType()) {
            case '\u0001': {
                return "MAPPED-ADDRESS";
            }
            case '\u0002': {
                return "RESPONSE-ADDRESS";
            }
            case '\u0004': {
                return "SOURCE-ADDRESS";
            }
            case '\u0005': {
                return "CHANGED-ADDRESS";
            }
            case '\u000b': {
                return "REFLECTED-FROM";
            }
        }
        return "UNKNOWN MESSAGE";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AddressAttribute) || obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AddressAttribute att = (AddressAttribute)obj;
        if (att.getAttributeType() != this.getAttributeType() || att.getDataLength() != this.getDataLength() || att.getFamily() != this.getFamily() || att.getAddress() != null && !this.address.equals(att.getAddress())) {
            return false;
        }
        if (att.getAddress() == null && this.getAddress() == null) {
            return true;
        }
        return true;
    }

    public char getDataLength() {
        return '\b';
    }

    public byte[] encode() {
        char type = this.getAttributeType();
        if (!this.isTypeValid(type)) {
            throw new IllegalStateException(type + "is not a valid address attribute!");
        }
        byte[] binValue = new byte[]{(byte)(type >> 8), (byte)(type & 0xFF), (byte)(this.getDataLength() >> 8), (byte)(this.getDataLength() & 0xFF), 0, this.getFamily(), (byte)(this.getPort() >> 8), (byte)(this.getPort() & 0xFF), this.getAddressBytes()[0], this.getAddressBytes()[1], this.getAddressBytes()[2], this.getAddressBytes()[3]};
        return binValue;
    }

    public void setAddress(StunAddress address) {
        this.address = address;
    }

    public StunAddress getAddress() {
        return this.address;
    }

    public byte[] getAddressBytes() {
        return this.address.getAddressBytes();
    }

    public byte getFamily() {
        return 1;
    }

    public char getPort() {
        return this.address.getPort();
    }

    void decodeAttributeBody(byte[] attributeValue, char offset, char length) throws StunException {
        char c = offset = (char)(offset + 2);
        char c2 = offset = (char)(offset + '\u0001');
        offset = (char)(offset + '\u0001');
        char port = (char)(attributeValue[c] << 8 | attributeValue[c2] & 0xFF);
        byte[] byArray = new byte[4];
        char c3 = offset;
        offset = (char)(offset + '\u0001');
        byArray[0] = attributeValue[c3];
        char c4 = offset;
        offset = (char)(offset + '\u0001');
        byArray[1] = attributeValue[c4];
        char c5 = offset;
        offset = (char)(offset + '\u0001');
        byArray[2] = attributeValue[c5];
        char c6 = offset;
        offset = (char)(offset + '\u0001');
        byArray[3] = attributeValue[c6];
        byte[] address = byArray;
        this.setAddress(new StunAddress(address, (int)port));
    }
}

