/*
 * Decompiled with CFR 0.152.
 */
package com.jeans.trayicon;

import com.jeans.trayicon.TrayDummyComponent;
import com.jeans.trayicon.WindowsTrayIcon;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class SwingTrayPopup
extends JPopupMenu {
    WindowsTrayIcon m_Icon;
    MouseListener m_Listener;

    public void setTrayIcon(WindowsTrayIcon windowsTrayIcon) {
        if (windowsTrayIcon != null) {
            this.m_Icon = windowsTrayIcon;
            SwingTrayPopup swingTrayPopup = this;
            swingTrayPopup.m_Icon.initJAWT();
            SwingTrayPopup swingTrayPopup2 = this;
            swingTrayPopup2.m_Icon.initHook();
            this.m_Listener = new ActivateListener();
            this.m_Icon.addMouseListener(this.m_Listener);
        } else if (this.m_Icon != null) {
            this.m_Icon.removeMouseListener(this.m_Listener);
            this.m_Icon = null;
        }
    }

    public void showMenu(int n, int n2) {
        SwingUtilities.invokeLater(new InvokeMenu(n, n2));
    }

    private boolean componentContains(JComponent jComponent, int n, int n2) {
        boolean bl;
        if (!jComponent.isVisible()) {
            return false;
        }
        Point point = jComponent.getLocationOnScreen();
        Dimension dimension = jComponent.getSize();
        boolean bl2 = bl = n > point.x && n < point.x + dimension.width && n2 > point.y && n2 < point.y + dimension.height;
        if (bl) {
            return true;
        }
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            JMenu jMenu;
            JComponent jComponent2 = (JComponent)jComponent.getComponent(i);
            if (!(jComponent2 instanceof JMenu) || !this.componentContains((jMenu = (JMenu)jComponent2).getPopupMenu(), n, n2)) continue;
            return true;
        }
        return false;
    }

    private boolean menuContains(int n, int n2) {
        return this.componentContains(this, n, n2);
    }

    private class InvokeMenu
    implements Runnable {
        int m_Xp;
        int m_Yp;

        public InvokeMenu(int n, int n2) {
            this.m_Xp = n;
            this.m_Yp = n2;
        }

        public void run() {
            TrayDummyComponent trayDummyComponent = WindowsTrayIcon.getDummyComponent();
            WindowsTrayIcon.setMouseClickHook(new ClickListener());
            Dimension dimension = SwingTrayPopup.this.getPreferredSize();
            SwingTrayPopup.this.show(trayDummyComponent, this.m_Xp - dimension.width, this.m_Yp - dimension.height);
            WindowsTrayIcon.setAlwaysOnTop(trayDummyComponent, true);
            SwingTrayPopup.this.updateUI();
        }
    }

    private class ActivateListener
    extends MouseAdapter {
        private ActivateListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && (mouseEvent.getModifiers() & 8) != 0 && mouseEvent.getClickCount() == 1) {
                SwingTrayPopup.this.showMenu(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class ClickListener
    extends MouseAdapter {
        private ClickListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!SwingTrayPopup.this.menuContains(mouseEvent.getX(), mouseEvent.getY())) {
                SwingTrayPopup.this.setVisible(false);
                WindowsTrayIcon.setMouseClickHook(null);
            }
        }
    }
}

