/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Schedule;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import resources.Professor;
import resources.ProfessorSummary;
import resources.SchedCourse;

public class Summary
implements Serializable,
Printable,
Pageable,
Observer {
    static final long serialVersionUID = 911L;
    private Hashtable profSummarys = new Hashtable(10, 0.75f);
    private boolean dirty = true;
    private Vector summaryLines;

    public Summary() {
        Schedule.getSchedule().addObserver(this);
        this.buildSummary();
    }

    public synchronized void update(Observable sched, Object obj) {
        this.buildSummary();
    }

    public synchronized void buildSummary() {
        Schedule schedule = Schedule.getSchedule();
        ArrayList professors = schedule.getProfessors();
        this.profSummarys.clear();
        this.dirty = true;
        ProfessorSummary total = new ProfessorSummary(new Professor("All Totals:", "", 3));
        ProfessorSummary totalf = new ProfessorSummary(new Professor("Full Time Totals:", "", 3));
        ProfessorSummary totala = new ProfessorSummary(new Professor("Adjunct Totals:", "", 3));
        Iterator it = professors.iterator();
        while (it.hasNext()) {
            ProfessorSummary summary = new ProfessorSummary((Professor)it.next());
            this.profSummarys.put(summary.getProfessor(), summary);
            if (summary.getProfessor().getStatus() == 1) {
                totalf.incrementSections(summary.getSections());
                totalf.incrementCreditHours(summary.getCreditHours());
            } else if (summary.getProfessor().getStatus() == 2) {
                totala.incrementSections(summary.getSections());
                totala.incrementCreditHours(summary.getCreditHours());
            }
            total.incrementSections(summary.getSections());
            total.incrementCreditHours(summary.getCreditHours());
        }
        this.profSummarys.put("Total", total);
        this.profSummarys.put("Total Full Time", totalf);
        this.profSummarys.put("Total Adjunct", totala);
    }

    public String calcSummary() {
        String result = "";
        String[] lines = this.getSummaryLines();
        for (int i = 0; i < lines.length; ++i) {
            result = result + lines[i] + "\n";
        }
        return result;
    }

    public int totalCapacity() {
        ArrayList courses = Schedule.getSchedule().getSchedCourses();
        int total = 0;
        for (SchedCourse course : courses) {
            total += course.getClassroom().getCapacity();
        }
        return total;
    }

    public int fullTimeFacultyCount() {
        Schedule schedule = Schedule.getSchedule();
        ArrayList profs = schedule.getProfessors();
        int count = 0;
        Iterator it = profs.iterator();
        while (it.hasNext()) {
            if (((Professor)it.next()).getStatus() != 1) continue;
            ++count;
        }
        return count;
    }

    public int coursesFullTime() {
        Schedule schedule = Schedule.getSchedule();
        int count = 0;
        Enumeration enum1 = this.profSummarys.elements();
        while (enum1.hasMoreElements()) {
            ProfessorSummary profSummary = (ProfessorSummary)enum1.nextElement();
            if (profSummary.getProfessor().getStatus() != 1) continue;
            count += profSummary.getSections();
        }
        return count;
    }

    public int coursesAdjunct() {
        Schedule schedule = Schedule.getSchedule();
        int count = 0;
        Enumeration enum1 = this.profSummarys.elements();
        while (enum1.hasMoreElements()) {
            ProfessorSummary profSummary = (ProfessorSummary)enum1.nextElement();
            if (profSummary.getProfessor().getStatus() != 2) continue;
            count += profSummary.getSections();
        }
        return count;
    }

    public int adjunctFacultyCount() {
        Schedule schedule = Schedule.getSchedule();
        ArrayList profs = schedule.getProfessors();
        int count = 0;
        Iterator it = profs.iterator();
        while (it.hasNext()) {
            if (((Professor)it.next()).getStatus() != 2) continue;
            ++count;
        }
        return count;
    }

    public int totalCreditHours() {
        Schedule schedule = Schedule.getSchedule();
        ProfessorSummary totals = (ProfessorSummary)this.profSummarys.get("Total");
        return totals.getCreditHours();
    }

    private String fullTimerSummary(Professor prof) {
        Schedule schedule = Schedule.getSchedule();
        if (!this.profSummarys.containsKey(prof)) {
            return "Summary for " + prof + " not found!";
        }
        return this.profSummarys.get(prof).toString();
    }

    public synchronized int getLinesPerPage(PageFormat pageFormat) {
        double pageHeight = pageFormat.getPaper().getImageableHeight();
        int lines = (int)(pageHeight / 9.0);
        return lines;
    }

    public synchronized int getNumberOfPages() {
        int linesPerPage = this.getLinesPerPage(this.getPageFormat(0));
        int totalLines = this.getSummaryLines().length;
        return totalLines / linesPerPage;
    }

    public synchronized int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > this.getNumberOfPages()) {
            return 1;
        }
        this.draw(g, pageFormat, pageIndex, new Rectangle((int)pageFormat.getPaper().getImageableX(), (int)pageFormat.getPaper().getImageableY(), (int)pageFormat.getPaper().getImageableWidth(), (int)pageFormat.getPaper().getImageableHeight()));
        return 0;
    }

    private synchronized String[] getSummaryLines() {
        if (this.dirty) {
            Schedule schedule = Schedule.getSchedule();
            int len = 10 + this.profSummarys.size() / 2;
            this.summaryLines = new Vector(20, 10);
            this.summaryLines.add("Summary of Schedule: " + schedule.getScheduleName());
            this.summaryLines.add(schedule.updated().trim());
            this.summaryLines.add("");
            this.summaryLines.add("Sections:     " + schedule.getSchedCourses().size());
            this.summaryLines.add("Credit Hours: " + this.totalCreditHours());
            this.summaryLines.add("Capacity:     " + this.totalCapacity());
            this.summaryLines.add("");
            this.summaryLines.add("");
            this.summaryLines.add("Full Time Faculty Scheduled: " + this.fullTimeFacultyCount());
            this.summaryLines.add("");
            this.summaryLines.add("Name                Sections  Credit Hours");
            this.summaryLines.add("---------------     --------  ------------");
            ProfessorSummary totalsft = (ProfessorSummary)this.profSummarys.get("Total Full Time");
            ProfessorSummary totalsat = (ProfessorSummary)this.profSummarys.get("Total");
            Enumeration enum1 = this.profSummarys.elements();
            while (enum1.hasMoreElements()) {
                ProfessorSummary profSummary = (ProfessorSummary)enum1.nextElement();
                if (profSummary.getProfessor().getStatus() != 1) continue;
                this.summaryLines.add(profSummary.toString());
            }
            this.summaryLines.add("---------------     --------  ------------");
            this.summaryLines.add(totalsft.toString());
            this.summaryLines.add("");
            if (totalsat.getSections() > 0) {
                this.summaryLines.add("Full Time percentage of all sections: " + NumberFormat.getPercentInstance().format((double)totalsft.getSections() / (double)totalsat.getSections()));
                this.summaryLines.add("Full Time percentage of all Credit Hours:  " + NumberFormat.getPercentInstance().format((double)totalsft.getCreditHours() / (double)totalsat.getCreditHours()));
            }
            this.dirty = false;
        }
        this.summaryLines.trimToSize();
        return this.summaryLines.toArray(new String[1]);
    }

    private synchronized void draw(Graphics g, PageFormat pageFormat, int pageIndex, Rectangle r) {
        Schedule schedule = Schedule.getSchedule();
        Graphics g2d = g;
        ((Graphics2D)g).setStroke(new BasicStroke(0.5f));
        Font titleFont = new Font("Monospaced", 1, 10);
        Font regFont = new Font("Monospaced", 0, 8);
        FontMetrics fm = g2d.getFontMetrics(regFont);
        int lineHeight = fm.getHeight();
        int linesPerPage = this.getLinesPerPage(pageFormat);
        String[] summary = this.getSummaryLines();
        g.setFont(regFont);
        String pageNumberString = pageIndex + 1 + "/" + this.getNumberOfPages();
        g.drawString(pageNumberString, (int)((double)(r.width - fm.stringWidth(pageNumberString)) + pageFormat.getImageableX()), (int)(pageFormat.getImageableY() + pageFormat.getPaper().getHeight()));
        int ypos = (int)pageFormat.getImageableY() + lineHeight;
        for (int currentLine = linesPerPage * pageIndex; currentLine < summary.length && currentLine < currentLine + linesPerPage; ++currentLine) {
            if (currentLine == 0) {
                g.setFont(titleFont);
            } else {
                g.setFont(regFont);
            }
            g.drawString(summary[currentLine], (int)pageFormat.getImageableX(), ypos);
            ypos += lineHeight;
        }
    }

    public synchronized Printable getPrintable(int pageIndex) {
        return this;
    }

    public synchronized PageFormat getPageFormat(int pageIndex) {
        PageFormat pageFormat = PrinterJob.getPrinterJob().defaultPage();
        Paper paper = pageFormat.getPaper();
        pageFormat.setPaper(paper);
        return pageFormat;
    }
}

