/*
 * Decompiled with CFR 0.152.
 */
package panels;

import application.ClassroomScheduler;
import application.Schedule;
import application.ViewGraphSched;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import panels.ScheduleTableModel;
import panels.TableSorter;
import resources.Classroom;
import resources.Professor;

public class ViewSchedulePanel
extends JPanel
implements Observer {
    private Schedule schedule = Schedule.getSchedule();
    private JTable schedTable;
    private ScheduleTableModel scheduleTableModel;
    private JScrollPane tableScrollPane;
    private ViewGraphSched viewGraphSched = new ViewGraphSched(null);
    private JScrollPane chartScrollPane;
    private JPanel leftPanel;
    private CardLayout cardLayout;
    private ButtonGroup tableOrChart;
    private JRadioButton tableButton;
    private JRadioButton chartButton;
    private ButtonGroup whatToShow;
    private JRadioButton showAll;
    private JRadioButton showRoom;
    private JRadioButton showProfessor;
    private JComboBox roomCB;
    private JComboBox professorCB;
    private JButton printView;
    private JButton printAll;
    private GridBagConstraints gbc = ViewSchedulePanel.startingGBC();
    private TitledBorder titledBorder;
    private Border border = BorderFactory.createLoweredBevelBorder();

    public ViewSchedulePanel() {
        this.makeWidgets();
        this.doTheLayout();
        this.addToolTips();
        this.addListeners();
    }

    public void update(Observable o, Object arg) {
        if (this.tableButton.isSelected()) {
            this.scheduleTableModel.fireTableDataChanged();
        }
        TableColumn profColumn = this.schedTable.getColumnModel().getColumn(3);
        this.professorCB.removeAllItems();
        Iterator it = this.schedule.getProfessors().iterator();
        while (it.hasNext()) {
            this.professorCB.addItem(it.next());
        }
        this.roomCB.removeAllItems();
        it = this.schedule.getClassrooms().iterator();
        while (it.hasNext()) {
            this.roomCB.addItem(it.next());
        }
    }

    private void makeWidgets() {
        this.scheduleTableModel = new ScheduleTableModel();
        TableSorter sorter = new TableSorter(this.scheduleTableModel);
        this.schedTable = new JTable(sorter);
        sorter.addMouseListenerToHeaderInTable(this.schedTable);
        this.schedTable.setPreferredScrollableViewportSize(new Dimension(450, 700));
        this.tableScrollPane = new JScrollPane(this.schedTable, 22, 30);
        this.chartScrollPane = new JScrollPane(this.viewGraphSched, 22, 30);
        this.chartScrollPane.setPreferredSize(new Dimension(450, 700));
        this.tableOrChart = new ButtonGroup();
        this.tableButton = new JRadioButton("Table", true);
        this.chartButton = new JRadioButton("Time Chart", false);
        this.tableOrChart.add(this.tableButton);
        this.tableOrChart.add(this.chartButton);
        this.whatToShow = new ButtonGroup();
        this.showAll = new JRadioButton("All", true);
        this.showRoom = new JRadioButton("Room", false);
        this.showProfessor = new JRadioButton("Professor", false);
        this.whatToShow.add(this.showAll);
        this.whatToShow.add(this.showRoom);
        this.whatToShow.add(this.showProfessor);
        this.roomCB = new JComboBox();
        this.professorCB = new JComboBox();
        this.printView = new JButton(" Print This View ");
        this.printAll = new JButton(" Print All Similar Views ");
        Dimension buttonSize = this.printView.getPreferredSize();
        buttonSize.setSize(90.0, buttonSize.getHeight());
        this.printView.setSize(buttonSize);
        this.printAll.setSize(buttonSize);
        Border border = BorderFactory.createRaisedBevelBorder();
        this.printView.setBorder(border);
        this.printAll.setBorder(border);
    }

    private void doTheLayout() {
        JPanel rightPanel = new JPanel();
        this.leftPanel = new JPanel();
        GridBagLayout rightPanelGridBag = new GridBagLayout();
        rightPanel.setLayout(rightPanelGridBag);
        JPanel tableChartPanel = new JPanel();
        this.makeTableChartPanel(tableChartPanel);
        JPanel selectivePanel = new JPanel();
        this.makeSelectivePanel(selectivePanel);
        JPanel printPanel = new JPanel();
        this.makePrintPanel(printPanel);
        this.gbc = ViewSchedulePanel.startingGBC();
        this.gbc.ipady = 15;
        this.gbc.insets = new Insets(10, 10, 10, 10);
        this.gbc.anchor = 16;
        rightPanel.add((Component)tableChartPanel, this.gbc);
        this.gbc.gridheight = 3;
        this.gbc.anchor = 17;
        rightPanel.add((Component)selectivePanel, this.gbc);
        this.gbc.gridwidth = -1;
        this.gbc.gridheight = 1;
        this.gbc.anchor = 18;
        rightPanel.add((Component)printPanel, this.gbc);
        this.cardLayout = new CardLayout();
        this.leftPanel.setLayout(this.cardLayout);
        this.cardLayout.addLayoutComponent(this.tableScrollPane, "Table");
        this.cardLayout.addLayoutComponent(this.chartScrollPane, "Chart");
        this.cardLayout.show(this.leftPanel, "Table");
        this.leftPanel.add((Component)this.tableScrollPane, "Table");
        this.leftPanel.add((Component)this.chartScrollPane, "Chart");
        GridBagLayout gridBag = new GridBagLayout();
        this.setLayout(gridBag);
        this.gbc = new GridBagConstraints();
        this.gbc.weightx = 6.0;
        this.gbc.weighty = 1.0;
        this.gbc.insets = new Insets(7, 3, 7, 3);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 5;
        this.gbc.gridheight = 0;
        this.gbc.fill = 1;
        this.gbc.anchor = 17;
        this.add((Component)this.leftPanel, this.gbc);
        this.cardLayout.show(this.leftPanel, "Table");
        this.gbc.weightx = 1.0;
        this.gbc.gridx = 5;
        this.gbc.gridwidth = 1;
        this.add((Component)rightPanel, this.gbc);
    }

    private void makeSelectivePanel(JPanel selectivePanel) {
        this.titledBorder = BorderFactory.createTitledBorder(this.border, " Selective View ");
        selectivePanel.setBorder(this.titledBorder);
        selectivePanel.setLayout(new GridBagLayout());
        this.gbc.ipady = 0;
        selectivePanel.add((Component)this.showAll, this.gbc);
        selectivePanel.add((Component)this.showRoom, this.gbc);
        selectivePanel.add((Component)this.showProfessor, this.gbc);
        this.gbc.ipady = 10;
        JLabel label = new JLabel("Choose a classroom:");
        selectivePanel.add((Component)label, this.gbc);
        this.gbc.ipady = 0;
        selectivePanel.add((Component)this.roomCB, this.gbc);
        this.gbc.ipady = 2;
        label = new JLabel("Choose a professor:");
        selectivePanel.add((Component)label, this.gbc);
        this.gbc.ipady = 0;
        selectivePanel.add((Component)this.professorCB, this.gbc);
    }

    private void makeTableChartPanel(JPanel tableChartPanel) {
        this.titledBorder = BorderFactory.createTitledBorder(this.border, " View As ");
        tableChartPanel.setBorder(this.titledBorder);
        tableChartPanel.setLayout(new GridBagLayout());
        this.gbc = ViewSchedulePanel.startingGBC();
        tableChartPanel.add((Component)this.tableButton, this.gbc);
        tableChartPanel.add((Component)this.chartButton, this.gbc);
    }

    private void makePrintPanel(JPanel printPanel) {
        this.titledBorder = BorderFactory.createTitledBorder(this.border, " Print ");
        printPanel.setBorder(this.titledBorder);
        printPanel.setLayout(new GridBagLayout());
        this.gbc = ViewSchedulePanel.startingGBC();
        this.gbc.insets = new Insets(5, 8, 5, 8);
        printPanel.add((Component)this.printView, this.gbc);
        printPanel.add((Component)this.printAll, this.gbc);
    }

    protected static GridBagConstraints startingGBC() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.gridheight = 1;
        gbc.ipady = 0;
        gbc.ipadx = 0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        return gbc;
    }

    private void addToolTips() {
    }

    private void addListeners() {
        ListenToWhatToShow whatToShowListener = new ListenToWhatToShow();
        this.tableButton.addActionListener(whatToShowListener);
        this.chartButton.addActionListener(whatToShowListener);
        this.showAll.addActionListener(whatToShowListener);
        this.showRoom.addActionListener(whatToShowListener);
        this.showProfessor.addActionListener(whatToShowListener);
        this.roomCB.addActionListener(whatToShowListener);
        this.professorCB.addActionListener(whatToShowListener);
        this.printView.addActionListener(whatToShowListener);
        this.printAll.addActionListener(whatToShowListener);
    }

    private void printTheView(Pageable toPrint, boolean confirm) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPageable(toPrint);
        if (confirm) {
            if (printJob.printDialog()) {
                try {
                    printJob.print();
                }
                catch (PrinterException pe) {
                    System.out.println(pe);
                    JOptionPane.showMessageDialog(ClassroomScheduler.getFrame(), "Error printing a schedule.", "Unknown Printer Error", 0);
                }
            }
        } else {
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                System.out.println(pe);
                JOptionPane.showMessageDialog(ClassroomScheduler.getFrame(), "Error printing a schedule.", "Unknown Printer Error", 0);
            }
        }
    }

    class ListenToWhatToShow
    implements ActionListener {
        ListenToWhatToShow() {
        }

        public void actionPerformed(ActionEvent ae) {
            if (ae.getActionCommand() == "Table") {
                ViewSchedulePanel.this.cardLayout.show(ViewSchedulePanel.this.leftPanel, "Table");
                ViewSchedulePanel.this.showAll.setEnabled(true);
                ViewSchedulePanel.this.showAll.setSelected(true);
                ViewSchedulePanel.this.roomCB.setEnabled(false);
                ViewSchedulePanel.this.professorCB.setEnabled(false);
                ViewSchedulePanel.this.printAll.setEnabled(false);
            }
            if (ae.getActionCommand() == "Time Chart") {
                ViewSchedulePanel.this.cardLayout.show(ViewSchedulePanel.this.leftPanel, "Chart");
                ViewSchedulePanel.this.showAll.setEnabled(false);
                ViewSchedulePanel.this.showRoom.setSelected(true);
                ViewSchedulePanel.this.roomCB.setEnabled(true);
                ViewSchedulePanel.this.professorCB.setEnabled(false);
                ViewSchedulePanel.this.viewGraphSched.setViewRoom((Classroom)ViewSchedulePanel.this.roomCB.getSelectedItem());
                ViewSchedulePanel.this.printAll.setEnabled(true);
            }
            if (ae.getActionCommand() == "All") {
                ViewSchedulePanel.this.roomCB.setEnabled(false);
                ViewSchedulePanel.this.professorCB.setEnabled(false);
            }
            if (ae.getActionCommand() == "Room") {
                ViewSchedulePanel.this.roomCB.setEnabled(true);
                ViewSchedulePanel.this.professorCB.setEnabled(false);
            }
            if (ae.getActionCommand() == "Professor") {
                ViewSchedulePanel.this.roomCB.setEnabled(false);
                ViewSchedulePanel.this.professorCB.setEnabled(true);
            }
            if (ViewSchedulePanel.this.chartButton.isSelected()) {
                if (ae.getActionCommand() == "Professor") {
                    ViewSchedulePanel.this.viewGraphSched.setViewProf((Professor)ViewSchedulePanel.this.professorCB.getSelectedItem());
                }
                if (ae.getActionCommand() == "Room") {
                    ViewSchedulePanel.this.viewGraphSched.setViewRoom((Classroom)ViewSchedulePanel.this.roomCB.getSelectedItem());
                }
                if (ae.getSource() == ViewSchedulePanel.this.roomCB) {
                    ViewSchedulePanel.this.viewGraphSched.setViewRoom((Classroom)ViewSchedulePanel.this.roomCB.getSelectedItem());
                }
                if (ae.getSource() == ViewSchedulePanel.this.professorCB) {
                    ViewSchedulePanel.this.viewGraphSched.setViewProf((Professor)ViewSchedulePanel.this.professorCB.getSelectedItem());
                }
            }
            if (ae.getActionCommand() == " Print This View ") {
                if (ViewSchedulePanel.this.chartButton.isSelected()) {
                    ViewSchedulePanel.this.printTheView(ViewSchedulePanel.this.viewGraphSched, true);
                } else {
                    ViewSchedulePanel.this.printTheView(ViewSchedulePanel.this.schedule, true);
                }
            }
            if (ae.getActionCommand() == " Print All Similar Views ") {
                if (!ViewSchedulePanel.this.chartButton.isSelected()) {
                    return;
                }
                if (ViewSchedulePanel.this.showRoom.isSelected()) {
                    System.out.println("Print all the rooms");
                    Iterator it = ViewSchedulePanel.this.schedule.getClassrooms().iterator();
                    while (it.hasNext()) {
                        ViewSchedulePanel.this.viewGraphSched.setViewRoom((Classroom)it.next());
                        ViewSchedulePanel.this.printTheView(ViewSchedulePanel.this.viewGraphSched, false);
                    }
                }
                if (ViewSchedulePanel.this.showProfessor.isSelected()) {
                    System.out.println("Print all the full time profs");
                    for (Professor p : ViewSchedulePanel.this.schedule.getProfessors()) {
                        if (p.getStatus() != 1) continue;
                        ViewSchedulePanel.this.viewGraphSched.setViewProf(p);
                        ViewSchedulePanel.this.printTheView(ViewSchedulePanel.this.viewGraphSched, false);
                    }
                }
            }
        }
    }
}

