/**
 *  Classroom Scheduler
 *  Copyright (C) 2004 Colin Archibald, Ph.D.
 *  https://sourceforge.net/projects/cr-scheduler/
 *
 *  Licensed under the Academic Free License version 2.0
 */

package panels;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.table.*;
import application.*;
import resources.*;
/**
 *
 * @author  Colin
 */
public class TimeSlotsPanel extends javax.swing.JPanel implements Observer {
    

    
    /** Creates new form TestGridbag */
    public TimeSlotsPanel(Component parent) {
        initComponents();
        this.parent = parent;
        ptm = new TimeSlotTableModel();
        sorter = new TableSorter(ptm);
        sorter.addMouseListenerToHeaderInTable(jTable1);
        jTable1.setModel(sorter);
        addListeners();
        setColumnSizes();
    }
    private void setColumnSizes(){
        // adjust the width of the columns
        TableColumn column = null;
        
        column = jTable1.getColumnModel().getColumn(0);
        column.setPreferredWidth(50);
        column = jTable1.getColumnModel().getColumn(1);
        column.setPreferredWidth(25);
        column = jTable1.getColumnModel().getColumn(2);
        column.setPreferredWidth(25);
 
        daysColumn = jTable1.getColumnModel().getColumn(0);
        startColumn = jTable1.getColumnModel().getColumn(1);
        endColumn = jTable1.getColumnModel().getColumn(2);
        
        //buildingColumn.setCellEditor(new DefaultCellEditor(editBuilding));
        //roomColumn.setCellEditor(new DefaultCellEditor(editRoom));
        //capacityColumn.setCellEditor(new DefaultCellEditor(editCapacity));
    }
    
    private void addListeners() {
        TimeSlotsPanelListener timeSlotsPanelListener = new TimeSlotsPanelListener();
        addButton.addActionListener(timeSlotsPanelListener);
        deleteButton.addActionListener(timeSlotsPanelListener);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        buttonGroup2 = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jPanel3 = new javax.swing.JPanel();
        deleteButton = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jPanel11 = new javax.swing.JPanel();
        cbSunday = new javax.swing.JCheckBox();
        cbMonday = new javax.swing.JCheckBox();
        cbTuesday = new javax.swing.JCheckBox();
        cbWednesday = new javax.swing.JCheckBox();
        cbThursday = new javax.swing.JCheckBox();
        cbFriday = new javax.swing.JCheckBox();
        cbSaturday = new javax.swing.JCheckBox();
        jPanel21 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        tfStartHours = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        tfStartMinutes = new javax.swing.JTextField();
        jPanel5 = new javax.swing.JPanel();
        rbStartAM = new javax.swing.JRadioButton();
        rbStartPM = new javax.swing.JRadioButton();
        jPanel31 = new javax.swing.JPanel();
        jLabel11 = new javax.swing.JLabel();
        tfStopHours = new javax.swing.JTextField();
        jLabel21 = new javax.swing.JLabel();
        tfStopMinutes = new javax.swing.JTextField();
        jPanel51 = new javax.swing.JPanel();
        rbStopAM = new javax.swing.JRadioButton();
        rbStopPM = new javax.swing.JRadioButton();
        jPanel4 = new javax.swing.JPanel();
        addButton = new javax.swing.JButton();

        setLayout(new java.awt.GridBagLayout());

        setToolTipText("Hour (use 12 hour clock)");
        jPanel1.setLayout(new java.awt.GridBagLayout());

        jScrollPane1.setToolTipText("Double click on header to sort");
        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jTable1.setPreferredScrollableViewportSize(new java.awt.Dimension(300, 400));
        jScrollPane1.setViewportView(jTable1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.weighty = 0.9;
        jPanel1.add(jScrollPane1, gridBagConstraints);

        deleteButton.setText("Delete Selected Time Slot(s)");
        deleteButton.setToolTipText("Delete time slots no longer needed");
        deleteButton.setMaximumSize(new java.awt.Dimension(225, 26));
        deleteButton.setMinimumSize(new java.awt.Dimension(250, 26));
        deleteButton.setPreferredSize(new java.awt.Dimension(210, 26));
        deleteButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteButtonActionPerformed(evt);
            }
        });

        jPanel3.add(deleteButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(17, 0, 17, 0);
        jPanel1.add(jPanel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = -53;
        gridBagConstraints.ipady = -25;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new java.awt.Insets(17, 17, 17, 0);
        add(jPanel1, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel2.setBorder(new javax.swing.border.CompoundBorder(new javax.swing.border.EtchedBorder(), new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED)));
        jPanel11.setLayout(new java.awt.GridBagLayout());

        cbSunday.setText("Sunday");
        cbSunday.setToolTipText("Select day(s) of week");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel11.add(cbSunday, gridBagConstraints);

        cbMonday.setText("Monday");
        cbMonday.setToolTipText("Select day(s) of week");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel11.add(cbMonday, gridBagConstraints);

        cbTuesday.setText("Tuesday");
        cbTuesday.setToolTipText("Select day(s) of week");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel11.add(cbTuesday, gridBagConstraints);

        cbWednesday.setText("Wednesday");
        cbWednesday.setToolTipText("Select day(s) of week");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel11.add(cbWednesday, gridBagConstraints);

        cbThursday.setText("Thursday (R)");
        cbThursday.setToolTipText("Select day(s) of week");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel11.add(cbThursday, gridBagConstraints);

        cbFriday.setText("Friday");
        cbFriday.setToolTipText("Select day(s) of week");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel11.add(cbFriday, gridBagConstraints);

        cbSaturday.setText("Saturday");
        cbSaturday.setToolTipText("Select day(s) of week");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel11.add(cbSaturday, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 3;
        gridBagConstraints.ipady = 17;
        gridBagConstraints.insets = new java.awt.Insets(17, 20, 0, 0);
        jPanel2.add(jPanel11, gridBagConstraints);

        jPanel21.setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Start Time:  ");
        jPanel21.add(jLabel1, new java.awt.GridBagConstraints());

        tfStartHours.setToolTipText("Hour (use 12 hour clock)");
        tfStartHours.setPreferredSize(new java.awt.Dimension(25, 20));
        jPanel21.add(tfStartHours, new java.awt.GridBagConstraints());

        jLabel2.setText(":");
        jPanel21.add(jLabel2, new java.awt.GridBagConstraints());

        tfStartMinutes.setToolTipText("Minute");
        tfStartMinutes.setPreferredSize(new java.awt.Dimension(25, 20));
        jPanel21.add(tfStartMinutes, new java.awt.GridBagConstraints());

        jPanel5.setLayout(new java.awt.GridBagLayout());

        rbStartAM.setText("AM");
        rbStartAM.setToolTipText("Must select one of AM/PM");
        buttonGroup1.add(rbStartAM);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel5.add(rbStartAM, gridBagConstraints);

        rbStartPM.setText("PM");
        rbStartPM.setToolTipText("Must select one of AM/PM");
        buttonGroup1.add(rbStartPM);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel5.add(rbStartPM, gridBagConstraints);

        jPanel21.add(jPanel5, new java.awt.GridBagConstraints());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 26;
        gridBagConstraints.ipady = 22;
        gridBagConstraints.insets = new java.awt.Insets(50, 10, 0, 0);
        jPanel2.add(jPanel21, gridBagConstraints);

        jPanel31.setLayout(new java.awt.GridBagLayout());

        jLabel11.setText("Stop Time:  ");
        jPanel31.add(jLabel11, new java.awt.GridBagConstraints());

        tfStopHours.setToolTipText("Hour (use 12 hour clock)");
        tfStopHours.setPreferredSize(new java.awt.Dimension(25, 20));
        jPanel31.add(tfStopHours, new java.awt.GridBagConstraints());

        jLabel21.setText(":");
        jPanel31.add(jLabel21, new java.awt.GridBagConstraints());

        tfStopMinutes.setToolTipText("Minute");
        tfStopMinutes.setPreferredSize(new java.awt.Dimension(25, 20));
        jPanel31.add(tfStopMinutes, new java.awt.GridBagConstraints());

        jPanel51.setLayout(new java.awt.GridBagLayout());

        rbStopAM.setText("AM");
        rbStopAM.setToolTipText("Must select one of AM/PM");
        buttonGroup2.add(rbStopAM);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel51.add(rbStopAM, gridBagConstraints);

        rbStopPM.setText("PM");
        rbStopPM.setToolTipText("Must select one of AM/PM");
        buttonGroup2.add(rbStopPM);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel51.add(rbStopPM, gridBagConstraints);

        jPanel31.add(jPanel51, new java.awt.GridBagConstraints());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 28;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        jPanel2.add(jPanel31, gridBagConstraints);

        addButton.setText("Add Time Slot");
        addButton.setToolTipText("Add this timeslot to the list");
        jPanel4.add(addButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.ipadx = 31;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(17, 30, 17, 0);
        jPanel2.add(jPanel4, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 17, 0, 17);
        add(jPanel2, gridBagConstraints);

    }//GEN-END:initComponents

    private void deleteButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deleteButtonActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_deleteButtonActionPerformed
        
    public void update(java.util.Observable observable, Object obj) {
        ptm.fireTableDataChanged();
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addButton;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.ButtonGroup buttonGroup2;
    private javax.swing.JCheckBox cbFriday;
    private javax.swing.JCheckBox cbMonday;
    private javax.swing.JCheckBox cbSaturday;
    private javax.swing.JCheckBox cbSunday;
    private javax.swing.JCheckBox cbThursday;
    private javax.swing.JCheckBox cbTuesday;
    private javax.swing.JCheckBox cbWednesday;
    private javax.swing.JButton deleteButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel11;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel21;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel31;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel51;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JRadioButton rbStartAM;
    private javax.swing.JRadioButton rbStartPM;
    private javax.swing.JRadioButton rbStopAM;
    private javax.swing.JRadioButton rbStopPM;
    private javax.swing.JTextField tfStartHours;
    private javax.swing.JTextField tfStartMinutes;
    private javax.swing.JTextField tfStopHours;
    private javax.swing.JTextField tfStopMinutes;
    // End of variables declaration//GEN-END:variables
    
    private TimeSlotsPanelListener timeSlotsPanelListener;
    private Schedule schedule = Schedule.getSchedule();
    private TimeSlotTableModel ptm;
    private TableSorter sorter;
    private TableColumn daysColumn;
    private TableColumn startColumn;
    private TableColumn endColumn;
    private JTextField editDays = new JTextField();
    private JTextField editStart = new JTextField();
    private JTextField editStop = new JTextField();
    
    private Component parent; // for placing the error dialogs
    
    class TimeSlotsPanelListener implements ActionListener {
        
        public void actionPerformed(ActionEvent e) {
            System.out.println("I hear " + "|"+e.getActionCommand()+"|");
            if (e.getActionCommand().equals("Add Time Slot")){
              // check that the days of week are valid
                boolean anyDaySet = false;
                boolean tempDays[] = new boolean[8];
                
                anyDaySet = setDayFlags(tempDays);
                
                if (!anyDaySet) {
                    JOptionPane.showMessageDialog(parent, "You must pick at least one day of the week");
                    return;
                }
                
                // make the start and stop times
                CRTime tempStart, tempStop;
                
                try {
                    tempStart = new CRTime(Integer.parseInt(tfStartHours.getText().trim()),
                    Integer.parseInt(tfStartMinutes.getText().trim()),
                    rbStartAM.isSelected());
                    tempStop = new CRTime(Integer.parseInt(tfStopHours.getText().trim()),
                    Integer.parseInt(tfStopMinutes.getText().trim()),
                    rbStopAM.isSelected());
                }
                catch (CRTimeException crte) {
                    JOptionPane.showMessageDialog(parent, crte.getMessage());
                    return;
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(parent, 
                        "You must enter a valid number (1-12) in the hour and minute fields");
                    return;
                }
                
                schedule.addTimeSlot(new TimeSlot(tempDays, tempStart, tempStop));
                
                // clear the UI            
                cbSunday.setSelected(false);
                cbMonday.setSelected(false);
                cbTuesday.setSelected(false);
                cbWednesday.setSelected(false);
                cbThursday.setSelected(false);
                cbFriday.setSelected(false);
                cbSaturday.setSelected(false);
                
                rbStartAM.setSelected(false);  
                rbStopAM.setSelected(false);
                rbStartPM.setSelected(false);  
                rbStopPM.setSelected(false);
                tfStartHours.setText("");
                tfStartMinutes.setText("");
                tfStopHours.setText("");
                tfStopMinutes.setText("");

                
            } else if (e.getActionCommand().equals("Delete Selected Time Slot(s)")){
                System.out.println("I'm deleting a time slot over here");
                // Determine which items to be deleted
                int[] selected = jTable1.getSelectedRows();
                
                for (int i = selected.length - 1 ; i >= 0 ; i--) {
                    int realIndex = sorter.map(selected[i]);
                    // Removes the items from the list
                    schedule.removeTimeSlot((TimeSlot)
                    schedule.getTimeSlots().get(realIndex));
                }
            }
        }
    } // end inner class
    
    private boolean setDayFlags(boolean[] tempdays){
        boolean result = false;
        if (cbSunday.isSelected()){
            result = true;
            tempdays[Calendar.SUNDAY] = true;
        }
        if (cbMonday.isSelected()){
            result = true;
            tempdays[Calendar.MONDAY] = true;
        }        
        if (cbTuesday.isSelected()){
            result = true;
            tempdays[Calendar.TUESDAY] = true;
        }
        if (cbWednesday.isSelected()){
            result = true;
            tempdays[Calendar.WEDNESDAY] = true;
        }
        if (cbThursday.isSelected()){
            result = true;
            tempdays[Calendar.THURSDAY] = true;
        }
        if (cbFriday.isSelected()){
            result = true;
            tempdays[Calendar.FRIDAY] = true;
        }
        if (cbSaturday.isSelected()){
            result = true;
            tempdays[Calendar.SATURDAY] = true;
        }   
        return result;
    }
}


class TimeSlotTableModel extends AbstractTableModel {
    private Schedule schedule;
    
    final String[] columnNames = {
        "Days of Week",
        "Start",
        "End",
    };
    /** Creates a new instance of RoomsTableModel */
    public TimeSlotTableModel() {
        schedule = Schedule.getSchedule();
    }
    public int getColumnCount() {
        return columnNames.length;
    }
    public int getRowCount() {
        return schedule.getTimeSlots().size();
    }
    public String getColumnName(int col) {
        return columnNames[col];
    }
    
    public Class getColumnClass(int c) {
        return " ".getClass();
    }
    public boolean isCellEditable(int row, int col) {
        return false;
    }
    public Object getValueAt(int row, int col) {
       TimeSlot timeSlot = (TimeSlot)schedule.getTimeSlots().get(row);
        switch(col){
            case 0: return timeSlot.toDaysString();
            case 1: 
                if (timeSlot.getStartTime() != null){
                    return timeSlot.getStartTime().toString();
                }
            case 2: 
                if(timeSlot.getStopTime() != null){
                    return timeSlot.getStopTime().toString();
                }
        }
        return ""; 
    }
    public void setValueAt(Object value, int row, int col) {
        //fireTableCellUpdated(row, col);
    }
}
