/**
 *  Classroom Scheduler
 *  Copyright (C) 2004 Colin Archibald, Ph.D.
 *  https://sourceforge.net/projects/cr-scheduler/
 *
 *  Licensed under the Academic Free License version 2.0
 */

package resources;

import java.awt.*;
import java.io.*;
import java.util.Iterator;
import application.*;
/**
 * ClassroomScheduler classroom
 */

public class Classroom implements Constants, Comparable, Serializable {
    static final long serialVersionUID = 911;
    
    private String building;
    private String roomName;
    private int    capacity;
    
    // Constructors
    
    /**
     * Constructor declaration
     *
     *
     * @param String building for this room
     * @param String roomName usually an alphanumeric
     * @param int capacity seats in this room
     *
     */
    
    public Classroom(String building, String roomName, int capacity) {
        this.capacity = capacity;
        this.roomName = roomName;
        this.building = building;
    }
    
    // accessors and mutators
    
    /**
     * Method declaration
     *
     *
     * @return int capacity of this room
     *
     */
    
    public int getCapacity() {
        return capacity;
    }
    
    /**
     * Method declaration
     *
     *
     * @return String roomName the name of this room (alphanumeric)
     *
     */
    
    public String getRoomName() {
        return roomName;
    }
    
    /**
     * Method declaration
     *
     *
     * @return  String building the building where this classroom is located
     *
     */
    
    public String getBuilding() {
        return building;
    }
    
    /**
     * Method declaration
     *
     *
     * @param capacity
     */
    
    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }
    
    /**
     * Method declaration
     *
     *
     * @param roomName
     *
     * @see
     */
    
    public void setRoomName(String roomName) {
        this.roomName = roomName;
    }
    
    /**
     * Method declaration
     *
     * @param Building
     */
    
    public void setBuilding(String building) {
        this.building = building;
    }
    
    /**
     * @return  String representation of the classroom
     */
    
    public String toString() {
        if (roomName.trim().equals("TBA")) {
            return roomName;
        }
        
        return building + "-" + roomName + " (" + capacity + ")";
    }
    // implement the Comparable interface for sorting
    
    public int compareTo(Object obj) {
        if (!(obj instanceof Classroom)){
            return 0;   
        }
        
        if (!building.equals(((Classroom)obj).building))
            return building.compareTo(((Classroom)obj).building);
        else if(!roomName.equals(((Classroom)obj).roomName))
            return roomName.compareTo(((Classroom)obj).roomName);
        
        return 0;
    }
    
    // determine if 2 rooms are equal - avoid duplicates
    
    public boolean equals(Object obj) {
        if (!(obj instanceof Classroom)){
            return false;
        }        
        Classroom room2 = (Classroom) obj;
        
        if (roomName.equals(room2.roomName) &&
            building.equals(room2.building) &&
            capacity == room2.capacity)
            return true;
        return false;
    }
    
    public void draw(Graphics g, Rectangle r) {
        //		System.out.println("drawing a room : " + r);
        Schedule schedule = Schedule.getSchedule();
        
        Iterator it = schedule.getSchedCourses().iterator();
        
        while (it.hasNext()){
            SchedCourse schedCourse = (SchedCourse) it.next();
            
            if (this.equals(schedCourse.getClassroom())) {
                schedCourse.drawGraphical(g, SchedCourse.CLASSROOM, r);
            }
        }
    }
}



