/*
 * Decompiled with CFR 0.152.
 */
package genj.geo;

import com.vividsolutions.jts.geom.Coordinate;
import genj.Version;
import genj.gedcom.Gedcom;
import genj.geo.Country;
import genj.geo.GeoLocation;
import genj.geo.GeoMap;
import genj.geo.GeoServiceException;
import genj.util.DirectAccessTokenizer;
import genj.util.EnvironmentChecker;
import genj.util.Origin;
import genj.util.Registry;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GeoService {
    static final Integer TIMEOUT = new Integer(10000);
    static final Charset UTF8 = Charset.forName("UTF8");
    static final Logger LOG = Logger.getLogger("genj.geo");
    static final URL URL = GeoService.createQueryURL();
    private static final String GEO_DIR = "geo";
    private static GeoService instance;
    private List maps;
    private static final String HEADER;

    private static URL createQueryURL() {
        try {
            return new URL("http://genj.sourceforge.net/php/geoq.php");
        }
        catch (MalformedURLException e) {
            throw new Error("init");
        }
    }

    private GeoService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GeoService getInstance() {
        if (instance == null) {
            Class clazz = GeoService.class;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new GeoService();
                }
            }
        }
        return instance;
    }

    File[] getGeoFiles() {
        ArrayList<File> result = new ArrayList<File>();
        String[] dirs = new String[]{EnvironmentChecker.getProperty((Object)this, (String)"user.home.genj/geo", (String)"", (String)"looking for user's geo files"), EnvironmentChecker.getProperty((Object)this, (String)"all.home.genj/geo", (String)"", (String)"looking for shared geo files"), EnvironmentChecker.getProperty((Object)this, (String)"genj.geo.dir", (String)GEO_DIR, (String)"looking for installed geo files")};
        for (int i = 0; i < dirs.length; ++i) {
            File dir = new File(dirs[i]);
            if (!dir.isDirectory()) continue;
            result.addAll(Arrays.asList(dir.listFiles()));
        }
        return result.toArray(new File[result.size()]);
    }

    private Registry getRegistry(Gedcom gedcom) {
        String name = gedcom.getName();
        if (name.endsWith(".ged")) {
            name = name.substring(0, name.length() - ".ged".length());
        }
        name = name + ".geo";
        return Registry.lookup((String)name, (Origin)gedcom.getOrigin());
    }

    private String encode(GeoLocation location) {
        StringBuffer query = new StringBuffer();
        query.append(location.getCity());
        query.append(",");
        if (location.getJurisdictions().isEmpty()) {
            query.append(",");
        } else {
            Iterator it = location.getJurisdictions().iterator();
            while (it.hasNext()) {
                query.append(it.next().toString());
                query.append(",");
            }
        }
        Country c = location.getCountry();
        if (c != null) {
            query.append(c.getCode());
        }
        return query.toString();
    }

    private GeoLocation decode(String location) {
        DirectAccessTokenizer tokens = new DirectAccessTokenizer(location, ",", false);
        if (tokens.count() != 5) {
            return null;
        }
        GeoLocation result = new GeoLocation(tokens.get(0), tokens.get(1), Country.get(tokens.get(2)));
        try {
            result.setCoordinate(Float.parseFloat(tokens.get(3)), Float.parseFloat(tokens.get(4)));
        }
        catch (NumberFormatException e) {
            return null;
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    protected List webservice(URL url, List locations, boolean followRedirect) throws GeoServiceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK], 9[CATCHBLOCK], 14[UNCONDITIONALDOLOOP]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List query(GeoLocation location) throws GeoServiceException {
        List rows = this.webservice(URL, Collections.singletonList(location), true);
        return rows.isEmpty() ? new ArrayList() : (List)rows.get(0);
    }

    public void match(Gedcom gedcom, Collection locations, boolean matchAll) throws GeoServiceException {
        Registry registry = gedcom != null ? this.getRegistry(gedcom) : new Registry();
        ArrayList<GeoLocation> todos = new ArrayList<GeoLocation>(locations.size());
        Iterator it = locations.iterator();
        while (it.hasNext()) {
            GeoLocation location = (GeoLocation)it.next();
            String restored = registry.get(location.getJurisdictionsAsString(), (String)null);
            if (restored != null) {
                try {
                    StringTokenizer tokens = new StringTokenizer(restored, ",");
                    location.setCoordinate(Double.parseDouble(tokens.nextToken()), Double.parseDouble(tokens.nextToken()));
                    if (tokens.hasMoreTokens()) {
                        location.setMatches(Integer.parseInt(tokens.nextToken()));
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (location.isValid()) continue;
            todos.add(location);
        }
        if (todos.isEmpty() || todos.size() != locations.size() && !matchAll) {
            return;
        }
        List rows = this.webservice(URL, todos, true);
        for (int i = 0; i < todos.size(); ++i) {
            GeoLocation todo = (GeoLocation)todos.get(i);
            List hits = (List)rows.get(i);
            if (hits.isEmpty()) continue;
            GeoLocation match = null;
            int matchScore = -1;
            for (int h = 0; h < hits.size(); ++h) {
                GeoLocation hit = (GeoLocation)hits.get(h);
                int hitScore = 0;
                if (todo.getCity().equals(hit.getCity())) {
                    hitScore += 8;
                }
                if (todo.getJurisdictions().containsAll(hit.getJurisdictions())) {
                    hitScore += 4;
                }
                if (todo.getCountry() != null && todo.getCountry().equals(hit.getCountry())) {
                    hitScore += 2;
                }
                if (Country.HERE.equals(hit.getCountry())) {
                    ++hitScore;
                }
                if (hitScore <= matchScore) continue;
                match = hit;
                matchScore = hitScore;
            }
            todo.setCoordinate(match.getCoordinate());
            todo.setMatches(hits.size());
            this.remember(gedcom, todo);
        }
    }

    public void remember(Gedcom gedcom, GeoLocation location) {
        if (gedcom == null) {
            return;
        }
        Coordinate coord = location.getCoordinate();
        this.getRegistry(gedcom).put(location.getJurisdictionsAsString(), coord.y + "," + coord.x + "," + location.getMatches());
    }

    public synchronized GeoMap[] getMaps() {
        if (this.maps == null) {
            this.maps = new ArrayList();
            File[] files = this.getGeoFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].getName().equals("CVS") || !files[i].isDirectory() && !files[i].getName().endsWith(".zip")) continue;
                try {
                    this.maps.add(new GeoMap(files[i]));
                    continue;
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, "problem reading map from " + files[i], t);
                }
            }
        }
        return this.maps.toArray(new GeoMap[this.maps.size()]);
    }

    static {
        HEADER = "GEOQ:" + System.getProperty("user.name") + "," + System.getProperty("os.name") + "," + "GenJ " + Version.getInstance().getBuildString();
    }
}

