/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import java.util.List;

public class CoordinateArrays {
    private static final Coordinate[] coordArrayType = new Coordinate[0];

    public static Coordinate[] copyDeep(Coordinate[] coordinateArray) {
        Coordinate[] coordinateArray2 = new Coordinate[coordinateArray.length];
        for (int i = 0; i < coordinateArray.length; ++i) {
            coordinateArray2[i] = new Coordinate(coordinateArray[i]);
        }
        return coordinateArray2;
    }

    public static Coordinate[] toCoordinateArray(List list) {
        return list.toArray(coordArrayType);
    }

    public static boolean hasRepeatedPoints(Coordinate[] coordinateArray) {
        for (int i = 1; i < coordinateArray.length; ++i) {
            if (!coordinateArray[i - 1].equals(coordinateArray[i])) continue;
            return true;
        }
        return false;
    }

    public static Coordinate[] atLeastNCoordinatesOrNothing(int n, Coordinate[] coordinateArray) {
        return coordinateArray.length >= n ? coordinateArray : new Coordinate[]{};
    }

    public static Coordinate[] removeRepeatedPoints(Coordinate[] coordinateArray) {
        if (!CoordinateArrays.hasRepeatedPoints(coordinateArray)) {
            return coordinateArray;
        }
        CoordinateList coordinateList = new CoordinateList(coordinateArray, false);
        return coordinateList.toCoordinateArray();
    }

    public static void reverse(Coordinate[] coordinateArray) {
        int n = coordinateArray.length - 1;
        int n2 = n / 2;
        for (int i = 0; i <= n2; ++i) {
            Coordinate coordinate = coordinateArray[i];
            coordinateArray[i] = coordinateArray[n - i];
            coordinateArray[n - i] = coordinate;
        }
    }

    public static boolean equals(Coordinate[] coordinateArray, Coordinate[] coordinateArray2) {
        if (coordinateArray == coordinateArray2) {
            return true;
        }
        if (coordinateArray == null || coordinateArray2 == null) {
            return false;
        }
        if (coordinateArray.length != coordinateArray2.length) {
            return false;
        }
        for (int i = 0; i < coordinateArray.length; ++i) {
            if (coordinateArray[i].equals(coordinateArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static Coordinate minCoordinate(Coordinate[] coordinateArray) {
        Coordinate coordinate = null;
        for (int i = 0; i < coordinateArray.length; ++i) {
            if (coordinate != null && coordinate.compareTo(coordinateArray[i]) <= 0) continue;
            coordinate = coordinateArray[i];
        }
        return coordinate;
    }

    public static void scroll(Coordinate[] coordinateArray, Coordinate coordinate) {
        int n = CoordinateArrays.indexOf(coordinate, coordinateArray);
        if (n < 0) {
            return;
        }
        Coordinate[] coordinateArray2 = new Coordinate[coordinateArray.length];
        System.arraycopy(coordinateArray, n, coordinateArray2, 0, coordinateArray.length - n);
        System.arraycopy(coordinateArray, 0, coordinateArray2, coordinateArray.length - n, n);
        System.arraycopy(coordinateArray2, 0, coordinateArray, 0, coordinateArray.length);
    }

    public static int indexOf(Coordinate coordinate, Coordinate[] coordinateArray) {
        for (int i = 0; i < coordinateArray.length; ++i) {
            if (!coordinate.equals(coordinateArray[i])) continue;
            return i;
        }
        return -1;
    }
}

