/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PrecisionModel
implements Serializable,
Comparable {
    private static final long serialVersionUID = 7777263578777803835L;
    public static final Type FIXED = new Type("FIXED");
    public static final Type FLOATING = new Type("FLOATING");
    public static final Type FLOATING_SINGLE = new Type("FLOATING SINGLE");
    public static final double maximumPreciseValue = 9.007199254740992E15;
    private Type modelType;
    private double scale;

    public PrecisionModel() {
        this.modelType = FLOATING;
    }

    public PrecisionModel(Type type) {
        this.modelType = type;
        if (type == FIXED) {
            this.setScale(1.0);
        }
    }

    public PrecisionModel(double d, double d2, double d3) {
        this.modelType = FIXED;
        this.setScale(d);
    }

    public PrecisionModel(double d) {
        this.modelType = FIXED;
        this.setScale(d);
    }

    public PrecisionModel(PrecisionModel precisionModel) {
        this.modelType = precisionModel.modelType;
        this.scale = precisionModel.scale;
    }

    public boolean isFloating() {
        return this.modelType == FLOATING || this.modelType == FLOATING_SINGLE;
    }

    public int getMaximumSignificantDigits() {
        int n = 16;
        if (this.modelType == FLOATING) {
            n = 16;
        } else if (this.modelType == FLOATING_SINGLE) {
            n = 6;
        } else if (this.modelType == FIXED) {
            n = 1 + (int)Math.ceil(Math.log(this.getScale()) / Math.log(10.0));
        }
        return n;
    }

    public double getScale() {
        return this.scale;
    }

    public Type getType() {
        return this.modelType;
    }

    private void setScale(double d) {
        this.scale = Math.abs(d);
    }

    public double getOffsetX() {
        return 0.0;
    }

    public double getOffsetY() {
        return 0.0;
    }

    public void toInternal(Coordinate coordinate, Coordinate coordinate2) {
        if (this.isFloating()) {
            coordinate2.x = coordinate.x;
            coordinate2.y = coordinate.y;
        } else {
            coordinate2.x = this.makePrecise(coordinate.x);
            coordinate2.y = this.makePrecise(coordinate.y);
        }
        coordinate2.z = coordinate.z;
    }

    public Coordinate toInternal(Coordinate coordinate) {
        Coordinate coordinate2 = new Coordinate(coordinate);
        this.makePrecise(coordinate2);
        return coordinate2;
    }

    public Coordinate toExternal(Coordinate coordinate) {
        Coordinate coordinate2 = new Coordinate(coordinate);
        return coordinate2;
    }

    public void toExternal(Coordinate coordinate, Coordinate coordinate2) {
        coordinate2.x = coordinate.x;
        coordinate2.y = coordinate.y;
    }

    public double makePrecise(double d) {
        if (this.modelType == FLOATING_SINGLE) {
            float f = (float)d;
            return f;
        }
        if (this.modelType == FIXED) {
            return Math.rint(d * this.scale) / this.scale;
        }
        return d;
    }

    public void makePrecise(Coordinate coordinate) {
        if (this.modelType == FLOATING) {
            return;
        }
        coordinate.x = this.makePrecise(coordinate.x);
        coordinate.y = this.makePrecise(coordinate.y);
    }

    public String toString() {
        String string = "UNKNOWN";
        if (this.modelType == FLOATING) {
            string = "Floating";
        } else if (this.modelType == FLOATING_SINGLE) {
            string = "Floating-Single";
        } else if (this.modelType == FIXED) {
            string = "Fixed (Scale=" + this.getScale() + ")";
        }
        return string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PrecisionModel)) {
            return false;
        }
        PrecisionModel precisionModel = (PrecisionModel)object;
        return this.modelType == precisionModel.modelType && this.scale == precisionModel.scale;
    }

    public int compareTo(Object object) {
        PrecisionModel precisionModel = (PrecisionModel)object;
        int n = this.getMaximumSignificantDigits();
        int n2 = precisionModel.getMaximumSignificantDigits();
        return new Integer(n).compareTo(new Integer(n2));
    }

    static class Type
    implements Serializable {
        private static final long serialVersionUID = -5528602631731589822L;
        private static Map nameToTypeMap = new HashMap();
        private String name;

        public Type(String string) {
            this.name = string;
            nameToTypeMap.put(string, this);
        }

        public String toString() {
            return this.name;
        }

        private Object readResolve() {
            return nameToTypeMap.get(this.name);
        }
    }
}

