/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Location;

public class TopologyLocation {
    int[] location;

    public TopologyLocation(int[] nArray) {
        this.init(nArray.length);
    }

    public TopologyLocation(int n, int n2, int n3) {
        this.init(3);
        this.location[0] = n;
        this.location[1] = n2;
        this.location[2] = n3;
    }

    public TopologyLocation(int n) {
        this.init(1);
        this.location[0] = n;
    }

    public TopologyLocation(TopologyLocation topologyLocation) {
        this.init(topologyLocation.location.length);
        if (topologyLocation != null) {
            for (int i = 0; i < this.location.length; ++i) {
                this.location[i] = topologyLocation.location[i];
            }
        }
    }

    private void init(int n) {
        this.location = new int[n];
        this.setAllLocations(-1);
    }

    public int get(int n) {
        if (n < this.location.length) {
            return this.location[n];
        }
        return -1;
    }

    public boolean isNull() {
        for (int i = 0; i < this.location.length; ++i) {
            if (this.location[i] == -1) continue;
            return false;
        }
        return true;
    }

    public boolean isAnyNull() {
        for (int i = 0; i < this.location.length; ++i) {
            if (this.location[i] != -1) continue;
            return true;
        }
        return false;
    }

    public boolean isEqualOnSide(TopologyLocation topologyLocation, int n) {
        return this.location[n] == topologyLocation.location[n];
    }

    public boolean isArea() {
        return this.location.length > 1;
    }

    public boolean isLine() {
        return this.location.length == 1;
    }

    public void flip() {
        if (this.location.length <= 1) {
            return;
        }
        int n = this.location[1];
        this.location[1] = this.location[2];
        this.location[2] = n;
    }

    public void setAllLocations(int n) {
        for (int i = 0; i < this.location.length; ++i) {
            this.location[i] = n;
        }
    }

    public void setAllLocationsIfNull(int n) {
        for (int i = 0; i < this.location.length; ++i) {
            if (this.location[i] != -1) continue;
            this.location[i] = n;
        }
    }

    public void setLocation(int n, int n2) {
        this.location[n] = n2;
    }

    public void setLocation(int n) {
        this.setLocation(0, n);
    }

    public int[] getLocations() {
        return this.location;
    }

    public void setLocations(int n, int n2, int n3) {
        this.location[0] = n;
        this.location[1] = n2;
        this.location[2] = n3;
    }

    public void setLocations(TopologyLocation topologyLocation) {
        for (int i = 0; i < topologyLocation.location.length; ++i) {
            this.location[i] = topologyLocation.location[i];
        }
    }

    public boolean allPositionsEqual(int n) {
        for (int i = 0; i < this.location.length; ++i) {
            if (this.location[i] == n) continue;
            return false;
        }
        return true;
    }

    public void merge(TopologyLocation topologyLocation) {
        if (topologyLocation.location.length > this.location.length) {
            int[] nArray = new int[]{this.location[0], -1, -1};
            this.location = nArray;
        }
        for (int i = 0; i < this.location.length; ++i) {
            if (this.location[i] != -1 || i >= topologyLocation.location.length) continue;
            this.location[i] = topologyLocation.location[i];
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.location.length > 1) {
            stringBuffer.append(Location.toLocationSymbol(this.location[1]));
        }
        stringBuffer.append(Location.toLocationSymbol(this.location[0]));
        if (this.location.length > 1) {
            stringBuffer.append(Location.toLocationSymbol(this.location[2]));
        }
        return stringBuffer.toString();
    }
}

