/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.strtree;

import com.vividsolutions.jts.util.Assert;

public class Interval {
    private double min;
    private double max;

    public Interval(Interval interval) {
        this(interval.min, interval.max);
    }

    public Interval(double d, double d2) {
        Assert.isTrue(d <= d2);
        this.min = d;
        this.max = d2;
    }

    public double getCentre() {
        return (this.min + this.max) / 2.0;
    }

    public Interval expandToInclude(Interval interval) {
        this.max = Math.max(this.max, interval.max);
        this.min = Math.min(this.min, interval.min);
        return this;
    }

    public boolean intersects(Interval interval) {
        return !(interval.min > this.max) && !(interval.max < this.min);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Interval)) {
            return false;
        }
        Interval interval = (Interval)object;
        return this.min == interval.min && this.max == interval.max;
    }
}

