/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.noding.SegmentNode;
import com.vividsolutions.jts.noding.SegmentString;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SegmentNodeList {
    private Map nodeMap = new TreeMap();
    private SegmentString edge;
    private List sortedNodes;

    public SegmentNodeList(SegmentString segmentString) {
        this.edge = segmentString;
    }

    public SegmentNode add(Coordinate coordinate, int n, double d) {
        SegmentNode segmentNode = new SegmentNode(coordinate, n, d);
        Object v = this.nodeMap.get(segmentNode);
        SegmentNode segmentNode2 = (SegmentNode)this.nodeMap.get(segmentNode);
        if (segmentNode2 != null) {
            return segmentNode2;
        }
        this.nodeMap.put(segmentNode, segmentNode);
        return segmentNode;
    }

    public Iterator iterator() {
        return this.nodeMap.values().iterator();
    }

    public void addEndpoints() {
        int n = this.edge.size() - 1;
        this.add(this.edge.getCoordinate(0), 0, 0.0);
        this.add(this.edge.getCoordinate(n), n, 0.0);
    }

    public void addSplitEdges(Collection collection) {
        ArrayList<SegmentString> arrayList = new ArrayList<SegmentString>();
        this.addEndpoints();
        Iterator iterator = this.iterator();
        SegmentNode segmentNode = (SegmentNode)iterator.next();
        while (iterator.hasNext()) {
            SegmentNode segmentNode2 = (SegmentNode)iterator.next();
            SegmentString segmentString = this.createSplitEdge(segmentNode, segmentNode2);
            collection.add(segmentString);
            arrayList.add(segmentString);
            segmentNode = segmentNode2;
        }
    }

    private void checkSplitEdgesCorrectness(List list) {
        Coordinate[] coordinateArray = this.edge.getCoordinates();
        SegmentString segmentString = (SegmentString)list.get(0);
        Coordinate coordinate = segmentString.getCoordinate(0);
        if (!coordinate.equals(coordinateArray[0])) {
            throw new RuntimeException("bad split edge start point at " + coordinate);
        }
        SegmentString segmentString2 = (SegmentString)list.get(list.size() - 1);
        Coordinate[] coordinateArray2 = segmentString2.getCoordinates();
        Coordinate coordinate2 = coordinateArray2[coordinateArray2.length - 1];
        if (!coordinate2.equals(coordinateArray[coordinateArray.length - 1])) {
            throw new RuntimeException("bad split edge end point at " + coordinate2);
        }
    }

    SegmentString createSplitEdge(SegmentNode segmentNode, SegmentNode segmentNode2) {
        boolean bl;
        int n = segmentNode2.segmentIndex - segmentNode.segmentIndex + 2;
        Coordinate coordinate = this.edge.getCoordinate(segmentNode2.segmentIndex);
        boolean bl2 = bl = segmentNode2.dist > 0.0 || !segmentNode2.coord.equals2D(coordinate);
        if (!bl) {
            --n;
        }
        Coordinate[] coordinateArray = new Coordinate[n];
        int n2 = 0;
        coordinateArray[n2++] = new Coordinate(segmentNode.coord);
        for (int i = segmentNode.segmentIndex + 1; i <= segmentNode2.segmentIndex; ++i) {
            coordinateArray[n2++] = this.edge.getCoordinate(i);
        }
        if (bl) {
            coordinateArray[n2] = segmentNode2.coord;
        }
        return new SegmentString(coordinateArray, this.edge.getContext());
    }

    public void print(PrintStream printStream) {
        printStream.println("Intersections:");
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SegmentNode segmentNode = (SegmentNode)iterator.next();
            segmentNode.print(printStream);
        }
    }
}

