/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.distance;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.geom.util.PointExtracter;
import com.vividsolutions.jts.geom.util.PolygonExtracter;
import com.vividsolutions.jts.operation.distance.ConnectedElementLocationFilter;
import com.vividsolutions.jts.operation.distance.GeometryLocation;
import java.util.List;

public class DistanceOp {
    private PointLocator ptLocator = new PointLocator();
    private Geometry[] geom;
    private GeometryLocation[] minDistanceLocation;
    private double minDistance = Double.MAX_VALUE;

    public static double distance(Geometry geometry, Geometry geometry2) {
        DistanceOp distanceOp = new DistanceOp(geometry, geometry2);
        return distanceOp.distance();
    }

    public static Coordinate[] closestPoints(Geometry geometry, Geometry geometry2) {
        DistanceOp distanceOp = new DistanceOp(geometry, geometry2);
        return distanceOp.closestPoints();
    }

    public DistanceOp(Geometry geometry, Geometry geometry2) {
        this.geom = new Geometry[2];
        this.geom[0] = geometry;
        this.geom[1] = geometry2;
    }

    public double distance() {
        this.computeMinDistance();
        return this.minDistance;
    }

    public Coordinate[] closestPoints() {
        this.computeMinDistance();
        Coordinate[] coordinateArray = new Coordinate[]{this.minDistanceLocation[0].getCoordinate(), this.minDistanceLocation[1].getCoordinate()};
        return coordinateArray;
    }

    public GeometryLocation[] closestLocations() {
        this.computeMinDistance();
        return this.minDistanceLocation;
    }

    private void updateMinDistance(double d) {
        if (d < this.minDistance) {
            this.minDistance = d;
        }
    }

    private void updateMinDistance(GeometryLocation[] geometryLocationArray, boolean bl) {
        if (geometryLocationArray[0] == null) {
            return;
        }
        if (bl) {
            this.minDistanceLocation[0] = geometryLocationArray[1];
            this.minDistanceLocation[1] = geometryLocationArray[0];
        } else {
            this.minDistanceLocation[0] = geometryLocationArray[0];
            this.minDistanceLocation[1] = geometryLocationArray[1];
        }
    }

    private void computeMinDistance() {
        if (this.minDistanceLocation != null) {
            return;
        }
        this.minDistanceLocation = new GeometryLocation[2];
        this.computeContainmentDistance();
        if (this.minDistance <= 0.0) {
            return;
        }
        this.computeLineDistance();
    }

    private void computeContainmentDistance() {
        List list;
        List list2 = PolygonExtracter.getPolygons(this.geom[0]);
        List list3 = PolygonExtracter.getPolygons(this.geom[1]);
        GeometryLocation[] geometryLocationArray = new GeometryLocation[2];
        if (list3.size() > 0) {
            list = ConnectedElementLocationFilter.getLocations(this.geom[0]);
            this.computeInside(list, list3, geometryLocationArray);
            if (this.minDistance <= 0.0) {
                this.minDistanceLocation[0] = geometryLocationArray[0];
                this.minDistanceLocation[1] = geometryLocationArray[1];
                return;
            }
        }
        if (list2.size() > 0) {
            list = ConnectedElementLocationFilter.getLocations(this.geom[1]);
            this.computeInside(list, list2, geometryLocationArray);
            if (this.minDistance <= 0.0) {
                this.minDistanceLocation[0] = geometryLocationArray[1];
                this.minDistanceLocation[1] = geometryLocationArray[0];
                return;
            }
        }
    }

    private void computeInside(List list, List list2, GeometryLocation[] geometryLocationArray) {
        for (int i = 0; i < list.size(); ++i) {
            GeometryLocation geometryLocation = (GeometryLocation)list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                Polygon polygon = (Polygon)list2.get(j);
                this.computeInside(geometryLocation, polygon, geometryLocationArray);
                if (!(this.minDistance <= 0.0)) continue;
                return;
            }
        }
    }

    private void computeInside(GeometryLocation geometryLocation, Polygon polygon, GeometryLocation[] geometryLocationArray) {
        Coordinate coordinate = geometryLocation.getCoordinate();
        if (2 != this.ptLocator.locate(coordinate, (Geometry)polygon)) {
            GeometryLocation geometryLocation2;
            this.minDistance = 0.0;
            geometryLocationArray[0] = geometryLocation;
            geometryLocationArray[1] = geometryLocation2 = new GeometryLocation(polygon, coordinate);
            return;
        }
    }

    private void computeLineDistance() {
        GeometryLocation[] geometryLocationArray = new GeometryLocation[2];
        List list = LinearComponentExtracter.getLines(this.geom[0]);
        List list2 = LinearComponentExtracter.getLines(this.geom[1]);
        List list3 = PointExtracter.getPoints(this.geom[0]);
        List list4 = PointExtracter.getPoints(this.geom[1]);
        this.computeMinDistanceLines(list, list2, geometryLocationArray);
        this.updateMinDistance(geometryLocationArray, false);
        if (this.minDistance <= 0.0) {
            return;
        }
        geometryLocationArray[0] = null;
        geometryLocationArray[1] = null;
        this.computeMinDistanceLinesPoints(list, list4, geometryLocationArray);
        this.updateMinDistance(geometryLocationArray, false);
        if (this.minDistance <= 0.0) {
            return;
        }
        geometryLocationArray[0] = null;
        geometryLocationArray[1] = null;
        this.computeMinDistanceLinesPoints(list2, list3, geometryLocationArray);
        this.updateMinDistance(geometryLocationArray, true);
        if (this.minDistance <= 0.0) {
            return;
        }
        geometryLocationArray[0] = null;
        geometryLocationArray[1] = null;
        this.computeMinDistancePoints(list3, list4, geometryLocationArray);
        this.updateMinDistance(geometryLocationArray, false);
    }

    private void computeMinDistanceLines(List list, List list2, GeometryLocation[] geometryLocationArray) {
        for (int i = 0; i < list.size(); ++i) {
            LineString lineString = (LineString)list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                LineString lineString2 = (LineString)list2.get(j);
                this.computeMinDistance(lineString, lineString2, geometryLocationArray);
                if (!(this.minDistance <= 0.0)) continue;
                return;
            }
        }
    }

    private void computeMinDistancePoints(List list, List list2, GeometryLocation[] geometryLocationArray) {
        for (int i = 0; i < list.size(); ++i) {
            Point point = (Point)list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                Point point2 = (Point)list2.get(j);
                double d = point.getCoordinate().distance(point2.getCoordinate());
                if (d < this.minDistance) {
                    this.minDistance = d;
                    geometryLocationArray[0] = new GeometryLocation(point, 0, point.getCoordinate());
                    geometryLocationArray[1] = new GeometryLocation(point2, 0, point2.getCoordinate());
                }
                if (!(this.minDistance <= 0.0)) continue;
                return;
            }
        }
    }

    private void computeMinDistanceLinesPoints(List list, List list2, GeometryLocation[] geometryLocationArray) {
        for (int i = 0; i < list.size(); ++i) {
            LineString lineString = (LineString)list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                Point point = (Point)list2.get(j);
                this.computeMinDistance(lineString, point, geometryLocationArray);
                if (!(this.minDistance <= 0.0)) continue;
                return;
            }
        }
    }

    private void computeMinDistance(LineString lineString, LineString lineString2, GeometryLocation[] geometryLocationArray) {
        if (lineString.getEnvelopeInternal().distance(lineString2.getEnvelopeInternal()) > this.minDistance) {
            return;
        }
        Coordinate[] coordinateArray = lineString.getCoordinates();
        Coordinate[] coordinateArray2 = lineString2.getCoordinates();
        for (int i = 0; i < coordinateArray.length - 1; ++i) {
            for (int j = 0; j < coordinateArray2.length - 1; ++j) {
                double d = CGAlgorithms.distanceLineLine(coordinateArray[i], coordinateArray[i + 1], coordinateArray2[j], coordinateArray2[j + 1]);
                if (d < this.minDistance) {
                    this.minDistance = d;
                    LineSegment lineSegment = new LineSegment(coordinateArray[i], coordinateArray[i + 1]);
                    LineSegment lineSegment2 = new LineSegment(coordinateArray2[j], coordinateArray2[j + 1]);
                    Coordinate[] coordinateArray3 = lineSegment.closestPoints(lineSegment2);
                    geometryLocationArray[0] = new GeometryLocation(lineString, i, coordinateArray3[0]);
                    geometryLocationArray[1] = new GeometryLocation(lineString2, j, coordinateArray3[1]);
                }
                if (!(this.minDistance <= 0.0)) continue;
                return;
            }
        }
    }

    private void computeMinDistance(LineString lineString, Point point, GeometryLocation[] geometryLocationArray) {
        if (lineString.getEnvelopeInternal().distance(point.getEnvelopeInternal()) > this.minDistance) {
            return;
        }
        Coordinate[] coordinateArray = lineString.getCoordinates();
        Coordinate coordinate = point.getCoordinate();
        for (int i = 0; i < coordinateArray.length - 1; ++i) {
            double d = CGAlgorithms.distancePointLine(coordinate, coordinateArray[i], coordinateArray[i + 1]);
            if (d < this.minDistance) {
                this.minDistance = d;
                LineSegment lineSegment = new LineSegment(coordinateArray[i], coordinateArray[i + 1]);
                Coordinate coordinate2 = lineSegment.closestPoint(coordinate);
                geometryLocationArray[0] = new GeometryLocation(lineString, i, coordinate2);
                geometryLocationArray[1] = new GeometryLocation(point, 0, coordinate);
            }
            if (!(this.minDistance <= 0.0)) continue;
            return;
        }
    }
}

