/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.polygonize;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.polygonize.PolygonizeEdge;
import com.vividsolutions.jts.planargraph.DirectedEdge;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class EdgeRing {
    private GeometryFactory factory;
    private static CGAlgorithms cga = new CGAlgorithms();
    private List deList = new ArrayList();
    private LinearRing ring = null;
    private Coordinate[] ringPts = null;
    private List holes;

    public static EdgeRing findEdgeRingContaining(EdgeRing edgeRing, List list) {
        LinearRing linearRing = edgeRing.getRing();
        Envelope envelope = linearRing.getEnvelopeInternal();
        Coordinate coordinate = linearRing.getCoordinateN(0);
        EdgeRing edgeRing2 = null;
        Envelope envelope2 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EdgeRing edgeRing3 = (EdgeRing)iterator.next();
            LinearRing linearRing2 = edgeRing3.getRing();
            Envelope envelope3 = linearRing2.getEnvelopeInternal();
            if (edgeRing2 != null) {
                envelope2 = edgeRing2.getRing().getEnvelopeInternal();
            }
            boolean bl = false;
            if (envelope3.equals(envelope)) continue;
            coordinate = EdgeRing.ptNotInList(linearRing.getCoordinates(), linearRing2.getCoordinates());
            if (envelope3.contains(envelope)) {
                if (CGAlgorithms.isPointInRing(coordinate, linearRing2.getCoordinates())) {
                    bl = true;
                }
            }
            if (!bl || edgeRing2 != null && !envelope2.contains(envelope3)) continue;
            edgeRing2 = edgeRing3;
        }
        return edgeRing2;
    }

    public static Coordinate ptNotInList(Coordinate[] coordinateArray, Coordinate[] coordinateArray2) {
        for (int i = 0; i < coordinateArray.length; ++i) {
            Coordinate coordinate = coordinateArray[i];
            if (!EdgeRing.isInList(coordinate, coordinateArray2)) continue;
            return coordinate;
        }
        return null;
    }

    public static boolean isInList(Coordinate coordinate, Coordinate[] coordinateArray) {
        for (int i = 0; i < coordinateArray.length; ++i) {
            if (!coordinate.equals(coordinateArray[i])) continue;
            return false;
        }
        return true;
    }

    public EdgeRing(GeometryFactory geometryFactory) {
        this.factory = geometryFactory;
    }

    public void add(DirectedEdge directedEdge) {
        this.deList.add(directedEdge);
    }

    public boolean isHole() {
        LinearRing linearRing = this.getRing();
        return CGAlgorithms.isCCW(linearRing.getCoordinates());
    }

    public void addHole(LinearRing linearRing) {
        if (this.holes == null) {
            this.holes = new ArrayList();
        }
        this.holes.add(linearRing);
    }

    public Polygon getPolygon() {
        LinearRing[] linearRingArray = null;
        if (this.holes != null) {
            linearRingArray = new LinearRing[this.holes.size()];
            for (int i = 0; i < this.holes.size(); ++i) {
                linearRingArray[i] = (LinearRing)this.holes.get(i);
            }
        }
        Polygon polygon = this.factory.createPolygon(this.ring, linearRingArray);
        return polygon;
    }

    public boolean isValid() {
        this.getCoordinates();
        if (this.ringPts.length <= 3) {
            return false;
        }
        this.getRing();
        return this.ring.isValid();
    }

    private Coordinate[] getCoordinates() {
        if (this.ringPts == null) {
            CoordinateList coordinateList = new CoordinateList();
            Iterator iterator = this.deList.iterator();
            while (iterator.hasNext()) {
                DirectedEdge directedEdge = (DirectedEdge)iterator.next();
                PolygonizeEdge polygonizeEdge = (PolygonizeEdge)directedEdge.getEdge();
                EdgeRing.addEdge(polygonizeEdge.getLine().getCoordinates(), directedEdge.getEdgeDirection(), coordinateList);
            }
            this.ringPts = coordinateList.toCoordinateArray();
        }
        return this.ringPts;
    }

    public LineString getLineString() {
        this.getCoordinates();
        return this.factory.createLineString(this.ringPts);
    }

    public LinearRing getRing() {
        if (this.ring != null) {
            return this.ring;
        }
        this.getCoordinates();
        if (this.ringPts.length < 3) {
            System.out.println(this.ringPts);
        }
        try {
            this.ring = this.factory.createLinearRing(this.ringPts);
        }
        catch (Exception exception) {
            System.out.println(this.ringPts);
        }
        return this.ring;
    }

    private static void addEdge(Coordinate[] coordinateArray, boolean bl, CoordinateList coordinateList) {
        if (bl) {
            for (int i = 0; i < coordinateArray.length; ++i) {
                coordinateList.add(coordinateArray[i], false);
            }
        } else {
            for (int i = coordinateArray.length - 1; i >= 0; --i) {
                coordinateList.add(coordinateArray[i], false);
            }
        }
    }
}

