/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.planargraph;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Quadrant;
import com.vividsolutions.jts.planargraph.Edge;
import com.vividsolutions.jts.planargraph.GraphComponent;
import com.vividsolutions.jts.planargraph.Node;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DirectedEdge
extends GraphComponent
implements Comparable {
    protected static final CGAlgorithms cga = new CGAlgorithms();
    protected Edge parentEdge;
    protected Node from;
    protected Node to;
    protected Coordinate p0;
    protected Coordinate p1;
    protected DirectedEdge sym = null;
    protected boolean edgeDirection;
    protected int quadrant;
    protected double angle;

    public static List toEdges(Collection collection) {
        ArrayList<Edge> arrayList = new ArrayList<Edge>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((DirectedEdge)iterator.next()).parentEdge);
        }
        return arrayList;
    }

    public DirectedEdge(Node node, Node node2, Coordinate coordinate, boolean bl) {
        this.from = node;
        this.to = node2;
        this.edgeDirection = bl;
        this.p0 = node.getCoordinate();
        this.p1 = coordinate;
        double d = this.p1.x - this.p0.x;
        double d2 = this.p1.y - this.p0.y;
        this.quadrant = Quadrant.quadrant(d, d2);
        this.angle = Math.atan2(d2, d);
    }

    public Edge getEdge() {
        return this.parentEdge;
    }

    public void setEdge(Edge edge) {
        this.parentEdge = edge;
    }

    public int getQuadrant() {
        return this.quadrant;
    }

    public Coordinate getDirectionPt() {
        return this.p1;
    }

    public boolean getEdgeDirection() {
        return this.edgeDirection;
    }

    public Node getFromNode() {
        return this.from;
    }

    public Node getToNode() {
        return this.to;
    }

    public Coordinate getCoordinate() {
        return this.from.getCoordinate();
    }

    public double getAngle() {
        return this.angle;
    }

    public DirectedEdge getSym() {
        return this.sym;
    }

    public void setSym(DirectedEdge directedEdge) {
        this.sym = directedEdge;
    }

    public int compareTo(Object object) {
        DirectedEdge directedEdge = (DirectedEdge)object;
        return this.compareDirection(directedEdge);
    }

    public int compareDirection(DirectedEdge directedEdge) {
        if (this.quadrant > directedEdge.quadrant) {
            return 1;
        }
        if (this.quadrant < directedEdge.quadrant) {
            return -1;
        }
        return CGAlgorithms.computeOrientation(directedEdge.p0, directedEdge.p1, this.p1);
    }

    public void print(PrintStream printStream) {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1);
        printStream.print("  " + string2 + ": " + this.p0 + " - " + this.p1 + " " + this.quadrant + ":" + this.angle);
    }
}

