/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.feature;

import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.feature.AttributeType;
import java.util.ArrayList;
import java.util.HashMap;

public class FeatureSchema
implements Cloneable {
    private CoordinateSystem coordinateSystem = CoordinateSystem.UNSPECIFIED;
    private HashMap attributeNameToIndexMap = new HashMap();
    private int geometryIndex = -1;
    private int attributeCount = 0;
    private ArrayList attributeNames = new ArrayList();
    private ArrayList attributeTypes = new ArrayList();

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    public int getAttributeIndex(String string) {
        Integer n = (Integer)this.attributeNameToIndexMap.get(string);
        if (n == null) {
            throw new IllegalArgumentException("Unrecognized attribute name: " + string);
        }
        return n;
    }

    public boolean hasAttribute(String string) {
        return this.attributeNameToIndexMap.get(string) != null;
    }

    public int getGeometryIndex() {
        return this.geometryIndex;
    }

    public String getAttributeName(int n) {
        return (String)this.attributeNames.get(n);
    }

    public AttributeType getAttributeType(int n) {
        return (AttributeType)this.attributeTypes.get(n);
    }

    public AttributeType getAttributeType(String string) {
        return this.getAttributeType(this.getAttributeIndex(string));
    }

    public int getAttributeCount() {
        return this.attributeCount;
    }

    public void addAttribute(String string, AttributeType attributeType) {
        if (AttributeType.GEOMETRY == attributeType) {
            Assert.isTrue(this.geometryIndex == -1);
            this.geometryIndex = this.attributeCount;
        }
        this.attributeNames.add(string);
        this.attributeNameToIndexMap.put(string, new Integer(this.attributeCount));
        this.attributeTypes.add(attributeType);
        ++this.attributeCount;
    }

    public boolean equals(Object object) {
        return this.equals(object, false);
    }

    public boolean equals(Object object, boolean bl) {
        if (!(object instanceof FeatureSchema)) {
            return false;
        }
        FeatureSchema featureSchema = (FeatureSchema)object;
        if (this.attributeNames.size() != featureSchema.attributeNames.size()) {
            return false;
        }
        for (int i = 0; i < this.attributeNames.size(); ++i) {
            String string = (String)this.attributeNames.get(i);
            if (!featureSchema.attributeNames.contains(string)) {
                return false;
            }
            if (bl && !featureSchema.attributeNames.get(i).equals(string)) {
                return false;
            }
            if (this.getAttributeType(string) == featureSchema.getAttributeType(string)) continue;
            return false;
        }
        return true;
    }

    public FeatureSchema setCoordinateSystem(CoordinateSystem coordinateSystem) {
        this.coordinateSystem = coordinateSystem;
        return this;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }
}

