/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.LineSegment;
import java.util.Iterator;
import java.util.List;

public class SingleSegmentExpander {
    private Coordinate[] adjPt = new Coordinate[2];

    public static Envelope getInsetEnvelope(Envelope envelope, double d) {
        double d2;
        double d3 = envelope.getWidth() * d / 2.0;
        double d4 = envelope.getWidth() * d / 2.0;
        if (d4 < (d2 = d3)) {
            d2 = d4;
        }
        return new Envelope(envelope.getMinX() + d2, envelope.getMaxX() - d2, envelope.getMinY() + d2, envelope.getMaxY() - d2);
    }

    public boolean isApplicable(List list, List list2) {
        if (list.size() < 1) {
            return false;
        }
        LineSegment lineSegment = (LineSegment)list.get(0);
        return this.allSegsEqual(lineSegment, list) && this.allPtsInSeg(lineSegment, list2);
    }

    private boolean allSegsEqual(LineSegment lineSegment, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            LineSegment lineSegment2 = (LineSegment)iterator.next();
            if (lineSegment.equalsTopo(lineSegment2)) continue;
            return false;
        }
        return true;
    }

    private boolean allPtsInSeg(LineSegment lineSegment, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Coordinate coordinate = (Coordinate)iterator.next();
            if (lineSegment.p0.equals(coordinate)) {
                return true;
            }
            if (!lineSegment.p1.equals(coordinate)) continue;
            return true;
        }
        return false;
    }

    public Coordinate[] expandSegment(LineSegment lineSegment, Envelope envelope) {
        Envelope envelope2 = SingleSegmentExpander.getInsetEnvelope(envelope, 0.2);
        double d = lineSegment.p1.x - lineSegment.p0.x;
        double d2 = lineSegment.p1.y - lineSegment.p0.y;
        if (Math.abs(d) <= 1.0E-6) {
            double d3 = envelope2.getMinY();
            double d4 = envelope2.getMaxY();
            if (lineSegment.p0.y < lineSegment.p1.y) {
                d3 = envelope2.getMaxY();
                d4 = envelope2.getMinY();
            }
            this.adjPt[0] = new Coordinate(lineSegment.p0.x, d3);
            this.adjPt[1] = new Coordinate(lineSegment.p0.x, d4);
            return this.adjPt;
        }
        if (Math.abs(d2) <= 1.0E-6) {
            double d5 = envelope2.getMinX();
            double d6 = envelope2.getMaxX();
            if (lineSegment.p0.x < lineSegment.p1.x) {
                d5 = envelope2.getMaxX();
                d6 = envelope2.getMinX();
            }
            this.adjPt[0] = new Coordinate(d5, lineSegment.p0.y);
            this.adjPt[1] = new Coordinate(d6, lineSegment.p0.y);
            return this.adjPt;
        }
        this.adjPt[0] = this.rayEnvIntersection(lineSegment.p0, lineSegment.p1, envelope2);
        this.adjPt[1] = this.rayEnvIntersection(lineSegment.p1, lineSegment.p0, envelope2);
        return this.adjPt;
    }

    private Coordinate rayEnvIntersection(Coordinate coordinate, Coordinate coordinate2, Envelope envelope) {
        Coordinate coordinate3 = this.segIntX(coordinate, coordinate2, envelope.getMinX(), envelope.getMinY(), envelope.getMaxY());
        if (coordinate3 != null) {
            return coordinate3;
        }
        Coordinate coordinate4 = this.segIntX(coordinate, coordinate2, envelope.getMaxX(), envelope.getMinY(), envelope.getMaxY());
        if (coordinate4 != null) {
            return coordinate4;
        }
        Coordinate coordinate5 = this.segIntY(coordinate, coordinate2, envelope.getMinY(), envelope.getMinX(), envelope.getMaxX());
        if (coordinate5 != null) {
            return coordinate5;
        }
        Coordinate coordinate6 = this.segIntY(coordinate, coordinate2, envelope.getMaxY(), envelope.getMinX(), envelope.getMaxX());
        if (coordinate6 != null) {
            return coordinate6;
        }
        return null;
    }

    private double dotProduct(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = coordinate2.x - coordinate.x;
        double d2 = coordinate2.y - coordinate.y;
        double d3 = coordinate3.x - coordinate.x;
        double d4 = coordinate3.y - coordinate.y;
        return d * d3 + d2 * d4;
    }

    private Coordinate segIntX(Coordinate coordinate, Coordinate coordinate2, double d, double d2, double d3) {
        Coordinate coordinate3;
        double d4 = (coordinate2.y - coordinate.y) / (coordinate2.x - coordinate.x);
        double d5 = d4 * (d - coordinate.x) + coordinate.y;
        if (d5 > d2 && d5 < d3 && this.dotProduct(coordinate, coordinate2, coordinate3 = new Coordinate(d, d5)) < 0.0) {
            return coordinate3;
        }
        return null;
    }

    private Coordinate segIntY(Coordinate coordinate, Coordinate coordinate2, double d, double d2, double d3) {
        Coordinate coordinate3;
        double d4 = (coordinate2.x - coordinate.x) / (coordinate2.y - coordinate.y);
        double d5 = d4 * (d - coordinate.y) + coordinate.x;
        if (d5 > d2 && d5 < d3 && this.dotProduct(coordinate, coordinate2, coordinate3 = new Coordinate(d5, d)) < 0.0) {
            return coordinate3;
        }
        return null;
    }
}

