/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.AbstractSelection;
import com.vividsolutions.jump.workbench.ui.FeatureSelection;
import com.vividsolutions.jump.workbench.ui.PartSelection;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class LineStringSelection
extends AbstractSelection {
    public List items(Geometry geometry) {
        int n;
        Geometry geometry2;
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        if (geometry instanceof LineString) {
            arrayList.add(geometry);
        }
        if (geometry instanceof Polygon) {
            geometry2 = (Polygon)geometry;
            arrayList.add(((Polygon)geometry2).getExteriorRing());
            for (n = 0; n < ((Polygon)geometry2).getNumInteriorRing(); ++n) {
                arrayList.add(((Polygon)geometry2).getInteriorRingN(n));
            }
        }
        if (geometry instanceof GeometryCollection) {
            geometry2 = (GeometryCollection)geometry;
            for (n = 0; n < ((GeometryCollection)geometry2).getNumGeometries(); ++n) {
                arrayList.addAll(this.items(((GeometryCollection)geometry2).getGeometryN(n)));
            }
        }
        return arrayList;
    }

    public LineStringSelection(SelectionManager selectionManager) {
        super(selectionManager);
    }

    public String getRendererContentID() {
        return "SELECTED_LINESTRINGS";
    }

    protected boolean selectedInAncestors(Layer layer, Feature feature, Geometry geometry) {
        Assert.isTrue(this.getParent().getParent() instanceof FeatureSelection);
        Assert.isTrue(this.getParent() instanceof PartSelection);
        if (this.getParent().getParent().getFeaturesWithSelectedItems().contains(feature)) {
            return true;
        }
        Iterator iterator = this.getParent().getSelectedItems(layer, feature).iterator();
        while (iterator.hasNext()) {
            Geometry geometry2 = (Geometry)iterator.next();
            if (!this.items(geometry2).contains(geometry)) continue;
            return true;
        }
        return false;
    }

    protected void unselectInDescendants(Layer layer, Feature feature, Collection collection) {
        Assert.isTrue(this.getChild() == null);
    }
}

