/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.cursortool;

import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.LayerViewPanelListener;
import com.vividsolutions.jump.workbench.ui.cursortool.CursorTool;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class AbstractCursorTool
implements CursorTool {
    private boolean snappingConfigured = false;
    private boolean configuringSnapping = false;
    private boolean controlPressed;
    private boolean shiftPressed;
    private Color color = Color.red;
    private boolean filling = false;
    private Shape lastShapeDrawn;
    private LayerViewPanelListener layerViewPanelListener = new LayerViewPanelListener(){

        public void cursorPositionChanged(String string, String string2) {
        }

        public void selectionChanged() {
        }

        public void fenceChanged() {
        }

        public void painted(Graphics graphics) {
            try {
                if (AbstractCursorTool.this.shapeOnScreen) {
                    AbstractCursorTool.this.setShapeOnScreen(false);
                    AbstractCursorTool.this.redrawShape((Graphics2D)graphics);
                }
            }
            catch (Throwable throwable) {
                AbstractCursorTool.this.panel.getContext().handleThrowable(throwable);
            }
        }
    };
    private Color originalColor;
    private Stroke originalStroke;
    private LayerViewPanel panel;
    private boolean shapeOnScreen = false;
    private Stroke stroke = new BasicStroke(1.0f);
    private ArrayList listeners = new ArrayList();

    public void allowSnapping() {
        this.configuringSnapping = true;
    }

    protected boolean wasShiftPressed() {
        return this.shiftPressed;
    }

    protected boolean wasControlPressed() {
        return this.controlPressed;
    }

    public boolean isGestureInProgress() {
        return this.isShapeOnScreen();
    }

    public boolean isRightMouseButtonUsed() {
        return false;
    }

    public boolean isShapeOnScreen() {
        return this.shapeOnScreen;
    }

    public void activate(LayerViewPanel layerViewPanel) {
        if (this.panel != null) {
            this.panel.removeListener(this.layerViewPanelListener);
        }
        this.panel = layerViewPanel;
        this.panel.addListener(this.layerViewPanelListener);
    }

    public void deactivate() {
        this.cancelGesture();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.controlPressed = mouseEvent.isControlDown();
        this.shiftPressed = mouseEvent.isShiftDown();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void setColor(Color color) {
        this.color = color;
    }

    protected void setFilling(boolean bl) {
        this.filling = bl;
    }

    protected void setStrokeWidth(int n) {
        this.setStroke(new BasicStroke(n));
    }

    protected void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    protected void setup(Graphics2D graphics2D) {
        this.originalColor = graphics2D.getColor();
        this.originalStroke = graphics2D.getStroke();
        graphics2D.setColor(this.color);
        graphics2D.setXORMode(Color.white);
        graphics2D.setStroke(this.stroke);
    }

    protected LayerViewPanel getPanel() {
        return this.panel;
    }

    protected abstract Shape getShape() throws Exception;

    protected void cleanup(Graphics2D graphics2D) {
        graphics2D.setPaintMode();
        graphics2D.setColor(this.originalColor);
        graphics2D.setStroke(this.originalStroke);
    }

    protected void clearShape() {
        this.clearShape(this.getGraphics2D());
    }

    private Graphics2D getGraphics2D() {
        Graphics2D graphics2D = (Graphics2D)this.panel.getGraphics();
        if (graphics2D != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        return graphics2D;
    }

    public void cancelGesture() {
        this.clearShape();
    }

    protected void drawShapeXOR(Graphics2D graphics2D) throws Exception {
        Shape shape = this.getShape();
        this.drawShapeXOR(shape, graphics2D);
        this.lastShapeDrawn = shape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawShapeXOR(Shape shape, Graphics2D graphics2D) {
        this.setup(graphics2D);
        try {
            if (shape != null) {
                if (this.filling) {
                    graphics2D.fill(shape);
                } else {
                    graphics2D.draw(shape);
                }
            }
        }
        finally {
            this.cleanup(graphics2D);
        }
    }

    protected void redrawShape() throws Exception {
        this.redrawShape(this.getGraphics2D());
    }

    private void setShapeOnScreen(boolean bl) {
        this.shapeOnScreen = bl;
    }

    private void clearShape(Graphics2D graphics2D) {
        if (!this.shapeOnScreen) {
            return;
        }
        this.drawShapeXOR(this.lastShapeDrawn, graphics2D);
        this.setShapeOnScreen(false);
    }

    private void redrawShape(Graphics2D graphics2D) throws Exception {
        this.clearShape(graphics2D);
        this.drawShapeXOR(graphics2D);
        this.setShapeOnScreen(true);
    }

    protected abstract void gestureFinished() throws Exception;

    protected void fireGestureFinished() throws Exception {
        this.getPanel().getContext().setStatusMessage("");
        this.gestureFinished();
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            Listener listener = (Listener)iterator.next();
            listener.gestureFinished();
        }
    }

    public void add(Listener listener) {
        this.listeners.add(listener);
    }

    public Color getColor() {
        return this.color;
    }

    public static interface Listener {
        public void gestureFinished();
    }
}

