/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.util.CollectionMap;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.Viewport;
import com.vividsolutions.jump.workbench.ui.renderer.FeatureCollectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import com.vividsolutions.jump.workbench.ui.renderer.style.StyleUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;

public abstract class AbstractSelectionRenderer
extends FeatureCollectionRenderer
implements Style {
    public static final int HANDLE_WIDTH = 5;
    private boolean enabled = true;
    private Stroke handleStroke = new BasicStroke(1.0f);
    private Color handleFillColor;
    private Color handleLineColor = Color.black;
    private Stroke lineStroke = new BasicStroke(2.0f);
    private Color lineColor;
    private Stroke fillStroke = new BasicStroke(1.0f);
    private Color fillColor;
    private boolean filling = true;
    protected LayerViewPanel panel;
    private CollectionMap featureToSelectedItemsMap;
    private boolean paintingHandles;

    public AbstractSelectionRenderer(Object object, LayerViewPanel layerViewPanel, Color color, boolean bl, boolean bl2) {
        super(object, layerViewPanel);
        this.panel = layerViewPanel;
        this.handleFillColor = color;
        this.lineColor = color;
        this.fillColor = GUIUtil.alphaColor(Color.white, 75);
        this.paintingHandles = bl;
        this.filling = bl2;
    }

    public String getName() {
        throw new UnsupportedOperationException();
    }

    public Icon getIcon() {
        throw new UnsupportedOperationException();
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Object clone() {
        Assert.shouldNeverReachHere();
        return null;
    }

    public void initialize(Layer layer) {
    }

    public void paint(Feature feature, Graphics2D graphics2D, Viewport viewport) throws NoninvertibleTransformException {
        Iterator iterator = this.featureToSelectedItemsMap.getItems(feature).iterator();
        while (iterator.hasNext()) {
            Geometry geometry = (Geometry)iterator.next();
            this.paint(geometry, graphics2D, viewport);
        }
    }

    public void paint(Geometry geometry, Graphics2D graphics2D, Viewport viewport) throws NoninvertibleTransformException {
        Coordinate[] coordinateArray = geometry.getCoordinates();
        StyleUtil.paint(geometry, graphics2D, viewport, this.filling, this.fillStroke, this.fillColor, true, this.lineStroke, this.lineColor);
        if (this.paintingHandles) {
            AbstractSelectionRenderer.paintHandles(graphics2D, coordinateArray, this.handleStroke, this.handleFillColor, this.handleLineColor, this.panel.getViewport());
        }
    }

    protected Collection styles() {
        return Collections.singleton(this);
    }

    protected Map layerToFeaturesMap() {
        this.featureToSelectedItemsMap = new CollectionMap();
        HashMap hashMap = new HashMap();
        Iterator iterator = this.panel.getLayerManager().iterator();
        while (iterator.hasNext()) {
            Layer layer = (Layer)iterator.next();
            CollectionMap collectionMap = this.featureToSelectedItemsMap(layer);
            this.featureToSelectedItemsMap.putAll((Map)collectionMap);
            hashMap.put(layer, collectionMap.keySet());
        }
        return hashMap;
    }

    protected abstract CollectionMap featureToSelectedItemsMap(Layer var1);

    private static Shape handle(Point2D point2D) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 5.0, 5.0);
        double_.x = point2D.getX() - 2.0;
        double_.y = point2D.getY() - 2.0;
        return double_;
    }

    public static void paintHandles(Graphics2D graphics2D, Coordinate[] coordinateArray, Stroke stroke, Color color, Color color2, Viewport viewport) throws NoninvertibleTransformException {
        int n;
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
        for (n = 0; n < coordinateArray.length; ++n) {
            if (!viewport.getEnvelopeInModelCoordinates().contains(coordinateArray[n])) continue;
            graphics2D.fill(AbstractSelectionRenderer.handle(viewport.toViewPoint(new Point2D.Double(coordinateArray[n].x, coordinateArray[n].y))));
        }
        graphics2D.setColor(color2);
        for (n = 0; n < coordinateArray.length; ++n) {
            if (!viewport.getEnvelopeInModelCoordinates().contains(coordinateArray[n])) continue;
            graphics2D.draw(AbstractSelectionRenderer.handle(viewport.toViewPoint(new Point2D.Double(coordinateArray[n].x, coordinateArray[n].y))));
        }
    }
}

