/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.renderer.FeatureCollectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ImageCachingFeatureCollectionRenderer;
import com.vividsolutions.jump.workbench.ui.renderer.ThreadSafeImage;
import com.vividsolutions.jump.workbench.ui.renderer.style.Style;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class LayerRenderer
extends FeatureCollectionRenderer {
    private Layer layer;
    private LayerViewPanel panel;

    public LayerRenderer(final Layer layer, LayerViewPanel layerViewPanel) {
        super(layer, layerViewPanel, new ImageCachingFeatureCollectionRenderer(layer, layerViewPanel){

            protected ThreadSafeImage getImage() {
                if (!layer.isVisible()) {
                    return null;
                }
                return super.getImage();
            }

            public Runnable createRunnable() {
                if (!layer.isVisible()) {
                    return null;
                }
                return super.createRunnable();
            }
        });
        this.layer = layer;
        this.panel = layerViewPanel;
    }

    protected Collection styles() {
        ArrayList<Style> arrayList = new ArrayList<Style>(this.layer.getStyles());
        arrayList.remove(this.layer.getVertexStyle());
        arrayList.remove(this.layer.getLabelStyle());
        arrayList.add(this.layer.getVertexStyle());
        arrayList.add(this.layer.getLabelStyle());
        return arrayList;
    }

    protected Map layerToFeaturesMap() {
        Envelope envelope = this.panel.getViewport().getEnvelopeInModelCoordinates();
        return Collections.singletonMap(this.layer, this.layer.getFeatureCollection().query(envelope));
    }
}

