/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.java2D;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jump.workbench.ui.renderer.java2D.GeometryCollectionShape;
import com.vividsolutions.jump.workbench.ui.renderer.java2D.PolygonShape;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class Java2DConverter {
    private static double POINT_MARKER_SIZE = 3.0;
    private PointConverter pointConverter;

    public Java2DConverter(PointConverter pointConverter) {
        this.pointConverter = pointConverter;
    }

    private Shape toShape(Polygon polygon) throws NoninvertibleTransformException {
        ArrayList<Coordinate[]> arrayList = new ArrayList<Coordinate[]>();
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            arrayList.add(this.toViewCoordinates(polygon.getInteriorRingN(i).getCoordinates()));
        }
        return new PolygonShape(this.toViewCoordinates(polygon.getExteriorRing().getCoordinates()), arrayList);
    }

    private Coordinate[] toViewCoordinates(Coordinate[] coordinateArray) throws NoninvertibleTransformException {
        Coordinate[] coordinateArray2 = new Coordinate[coordinateArray.length];
        for (int i = 0; i < coordinateArray.length; ++i) {
            Point2D point2D = this.toViewPoint(coordinateArray[i]);
            coordinateArray2[i] = new Coordinate(point2D.getX(), point2D.getY());
        }
        return coordinateArray2;
    }

    private Shape toShape(GeometryCollection geometryCollection) throws NoninvertibleTransformException {
        GeometryCollectionShape geometryCollectionShape = new GeometryCollectionShape();
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            Geometry geometry = geometryCollection.getGeometryN(i);
            geometryCollectionShape.add(this.toShape(geometry));
        }
        return geometryCollectionShape;
    }

    private GeneralPath toShape(MultiLineString multiLineString) throws NoninvertibleTransformException {
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
            LineString lineString = (LineString)multiLineString.getGeometryN(i);
            generalPath.append(this.toShape(lineString), false);
        }
        return generalPath;
    }

    private GeneralPath toShape(LineString lineString) throws NoninvertibleTransformException {
        GeneralPath generalPath = new GeneralPath();
        Point2D point2D = this.toViewPoint(lineString.getCoordinateN(0));
        generalPath.moveTo((float)point2D.getX(), (float)point2D.getY());
        for (int i = 1; i < lineString.getNumPoints(); ++i) {
            point2D = this.toViewPoint(lineString.getCoordinateN(i));
            generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
        }
        return generalPath;
    }

    private Shape toShape(Point point) throws NoninvertibleTransformException {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, POINT_MARKER_SIZE, POINT_MARKER_SIZE);
        Point2D point2D = this.toViewPoint(point.getCoordinate());
        double_.x = point2D.getX() - POINT_MARKER_SIZE / 2.0;
        double_.y = point2D.getY() - POINT_MARKER_SIZE / 2.0;
        return double_;
    }

    private Point2D toViewPoint(Coordinate coordinate) throws NoninvertibleTransformException {
        Point2D point2D = this.pointConverter.toViewPoint(coordinate);
        return new Point2D.Double(Math.round(point2D.getX()), Math.round(point2D.getY()));
    }

    public Shape toShape(Geometry geometry) throws NoninvertibleTransformException {
        if (geometry.isEmpty()) {
            return new GeneralPath();
        }
        if (geometry instanceof Polygon) {
            return this.toShape((Polygon)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return this.toShape((MultiPolygon)geometry);
        }
        if (geometry instanceof LineString) {
            return this.toShape((LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.toShape((MultiLineString)geometry);
        }
        if (geometry instanceof Point) {
            return this.toShape((Point)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.toShape((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException("Unrecognized Geometry class: " + geometry.getClass());
    }

    public static interface PointConverter {
        public Point2D toViewPoint(Coordinate var1) throws NoninvertibleTransformException;
    }
}

