/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui.renderer.style;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.workbench.ui.Viewport;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;

public class StyleUtil {
    public static void paint(Geometry geometry, Graphics2D graphics2D, Viewport viewport, boolean bl, Stroke stroke, Paint paint, boolean bl2, Stroke stroke2, Color color) throws NoninvertibleTransformException {
        if (geometry instanceof GeometryCollection) {
            StyleUtil.paintGeometryCollection((GeometryCollection)geometry, graphics2D, viewport, bl, stroke, paint, bl2, stroke2, color);
            return;
        }
        Shape shape = StyleUtil.toShape(geometry, viewport);
        if (!(shape instanceof GeneralPath) && bl) {
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.fill(shape);
        }
        if (bl2) {
            graphics2D.setStroke(stroke2);
            graphics2D.setColor(color);
            graphics2D.draw(shape);
        }
    }

    private static void paintGeometryCollection(GeometryCollection geometryCollection, Graphics2D graphics2D, Viewport viewport, boolean bl, Stroke stroke, Paint paint, boolean bl2, Stroke stroke2, Color color) throws NoninvertibleTransformException {
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            StyleUtil.paint(geometryCollection.getGeometryN(i), graphics2D, viewport, bl, stroke, paint, bl2, stroke2, color);
        }
    }

    private static Shape toShape(Geometry geometry, Viewport viewport) throws NoninvertibleTransformException {
        Geometry geometry2;
        Envelope envelope = EnvelopeUtil.bufferByFraction(viewport.getEnvelopeInModelCoordinates(), 0.05);
        if (!envelope.contains((geometry2 = geometry).getEnvelopeInternal())) {
            try {
                geometry2 = EnvelopeUtil.toGeometry(envelope).intersection(geometry2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return viewport.getJava2DConverter().toShape(geometry2);
    }
}

