/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.BookmarkData;
import org.apache.fop.area.CTM;
import org.apache.fop.area.LineArea;
import org.apache.fop.area.OffDocumentExtensionAttachment;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.Character;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fo.extensions.xmp.XMPMetadata;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageFactory;
import org.apache.fop.image.XMLImage;
import org.apache.fop.pdf.PDFAMode;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFEncryptionManager;
import org.apache.fop.pdf.PDFFilterList;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFLink;
import org.apache.fop.pdf.PDFMetadata;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFState;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.render.AbstractPathOrientedRenderer;
import org.apache.fop.render.Graphics2DAdapter;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.pdf.CTMHelper;
import org.apache.fop.render.pdf.FopPDFImage;
import org.apache.fop.render.pdf.PDFGraphics2DAdapter;
import org.w3c.dom.Document;

public class PDFRenderer
extends AbstractPathOrientedRenderer {
    public static final String MIME_TYPE = "application/pdf";
    public static final String PDF_A_MODE = "pdf-a-mode";
    protected static final boolean WRITE_COMMENTS = true;
    protected PDFDocument pdfDoc;
    protected PDFAMode pdfAMode = PDFAMode.DISABLED;
    protected Map pages = null;
    protected Map pageReferences = new HashMap();
    protected Map pvReferences = new HashMap();
    protected OutputStream ostream;
    protected PDFResources pdfResources;
    protected PDFStream currentStream;
    protected PDFResourceContext currentContext = null;
    protected PDFPage currentPage;
    protected AffineTransform currentBasicTransform;
    protected PDFState currentState = null;
    protected String currentFontName = "";
    protected int currentFontSize = 0;
    protected int pageHeight;
    protected Map filterMap;
    protected boolean textOpen = false;
    protected boolean inTextMode = false;
    protected int prevWordY = 0;
    protected int prevWordX = 0;
    protected int prevWordWidth = 0;

    public void configure(Configuration cfg) throws ConfigurationException {
        this.filterMap = PDFFilterList.buildFilterMapFromConfiguration(cfg);
        List cfgFonts = FontSetup.buildFontListFromConfiguration(cfg);
        if (this.fontList == null) {
            this.fontList = cfgFonts;
        } else {
            this.fontList.addAll(cfgFonts);
        }
        String s = cfg.getChild(PDF_A_MODE, true).getValue(null);
        if (s != null) {
            this.pdfAMode = PDFAMode.valueOf(s);
        }
    }

    public void setUserAgent(FOUserAgent agent) {
        super.setUserAgent(agent);
        String s = (String)agent.getRendererOptions().get(PDF_A_MODE);
        if (s != null) {
            this.pdfAMode = PDFAMode.valueOf(s);
        }
    }

    public void startRenderer(OutputStream stream) throws IOException {
        if (this.userAgent == null) {
            throw new IllegalStateException("UserAgent must be set before starting the renderer");
        }
        this.ostream = stream;
        this.pdfDoc = new PDFDocument(this.userAgent.getProducer() != null ? this.userAgent.getProducer() : "");
        this.pdfDoc.setPDFAMode(this.pdfAMode);
        this.pdfDoc.setCreator(this.userAgent.getCreator());
        this.pdfDoc.setCreationDate(this.userAgent.getCreationDate());
        this.pdfDoc.getInfo().setAuthor(this.userAgent.getAuthor());
        this.pdfDoc.getInfo().setTitle(this.userAgent.getTitle());
        this.pdfDoc.getInfo().setKeywords(this.userAgent.getKeywords());
        this.pdfDoc.setFilterMap(this.filterMap);
        this.pdfDoc.outputHeader(stream);
        PDFEncryptionManager.setupPDFEncryption(this.userAgent.getPDFEncryptionParams(), this.pdfDoc);
    }

    public void stopRenderer() throws IOException {
        this.pdfDoc.getResources().addFonts(this.pdfDoc, this.fontInfo);
        this.pdfDoc.outputTrailer(this.ostream);
        this.pdfDoc = null;
        this.ostream = null;
        this.pages = null;
        this.pageReferences.clear();
        this.pvReferences.clear();
        this.pdfResources = null;
        this.currentStream = null;
        this.currentContext = null;
        this.currentPage = null;
        this.currentState = null;
        this.currentFontName = "";
    }

    public boolean supportsOutOfOrder() {
        return true;
    }

    public void processOffDocumentItem(OffDocumentItem odi) {
        ExtensionAttachment attachment;
        if (odi instanceof BookmarkData) {
            this.renderBookmarkTree((BookmarkData)odi);
        } else if (odi instanceof OffDocumentExtensionAttachment && "adobe:ns:meta/".equals((attachment = ((OffDocumentExtensionAttachment)odi).getAttachment()).getCategory())) {
            this.renderXMPMetadata((XMPMetadata)attachment);
        }
    }

    protected void renderBookmarkTree(BookmarkData bookmarks) {
        for (int i = 0; i < bookmarks.getCount(); ++i) {
            BookmarkData ext = bookmarks.getSubData(i);
            this.renderBookmarkItem(ext, null);
        }
    }

    private void renderBookmarkItem(BookmarkData bookmarkItem, PDFOutline parentBookmarkItem) {
        PDFOutline pdfOutline = null;
        PageViewport pv = bookmarkItem.getPageViewport();
        if (pv != null) {
            Rectangle2D bounds = pv.getViewArea();
            double h = bounds.getHeight();
            float yoffset = (float)h / 1000.0f;
            String intDest = (String)this.pageReferences.get(pv.getKey());
            if (parentBookmarkItem == null) {
                PDFOutline outlineRoot = this.pdfDoc.getOutlineRoot();
                pdfOutline = this.pdfDoc.getFactory().makeOutline(outlineRoot, bookmarkItem.getBookmarkTitle(), intDest, yoffset, bookmarkItem.showChildItems());
            } else {
                pdfOutline = this.pdfDoc.getFactory().makeOutline(parentBookmarkItem, bookmarkItem.getBookmarkTitle(), intDest, yoffset, bookmarkItem.showChildItems());
            }
        } else {
            log.warn((Object)("Unresolved bookmark item received: " + bookmarkItem.getIDRef()));
        }
        for (int i = 0; i < bookmarkItem.getCount(); ++i) {
            this.renderBookmarkItem(bookmarkItem.getSubData(i), pdfOutline);
        }
    }

    private void renderXMPMetadata(XMPMetadata metadata) {
        PDFMetadata pdfMetadata = this.pdfDoc.getFactory().makeMetadata(metadata.getDocument(), metadata.isReadOnly());
        this.pdfDoc.getRoot().setMetadata(pdfMetadata);
    }

    public Graphics2DAdapter getGraphics2DAdapter() {
        return new PDFGraphics2DAdapter(this);
    }

    protected void comment(String text) {
        this.currentStream.add("% " + text + "\n");
    }

    protected void saveGraphicsState() {
        this.endTextObject();
        this.currentStream.add("q\n");
    }

    protected void restoreGraphicsState() {
        this.endTextObject();
        this.currentStream.add("Q\n");
    }

    protected void beginTextObject() {
        if (!this.inTextMode) {
            this.currentStream.add("BT\n");
            this.inTextMode = true;
        }
    }

    protected void endTextObject() {
        this.closeText();
        if (this.inTextMode) {
            this.currentStream.add("ET\n");
            this.inTextMode = false;
        }
    }

    public void startPageSequence(LineArea seqTitle) {
        if (seqTitle != null) {
            String str = this.convertTitleToString(seqTitle);
            PDFInfo info = this.pdfDoc.getInfo();
            if (info.getTitle() == null) {
                info.setTitle(str);
            }
        }
        if (this.pdfDoc.getRoot().getMetadata() == null) {
            Document xmp = PDFMetadata.createXMPFromUserAgent(this.pdfDoc);
            PDFMetadata pdfMetadata = this.pdfDoc.getFactory().makeMetadata(xmp, true);
            this.pdfDoc.getRoot().setMetadata(pdfMetadata);
        }
    }

    public void preparePage(PageViewport page) {
        this.setupPage(page);
        if (this.pages == null) {
            this.pages = new HashMap();
        }
        this.pages.put(page, this.currentPage);
    }

    private void setupPage(PageViewport page) {
        this.pdfResources = this.pdfDoc.getResources();
        Rectangle2D bounds = page.getViewArea();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        this.currentPage = this.pdfDoc.getFactory().makePage(this.pdfResources, (int)Math.round(w / 1000.0), (int)Math.round(h / 1000.0), page.getPageIndex());
        this.pageReferences.put(page.getKey(), this.currentPage.referencePDF());
        this.pvReferences.put(page.getKey(), page);
    }

    public void renderPage(PageViewport page) throws IOException, FOPException {
        if (this.pages != null && (this.currentPage = (PDFPage)this.pages.get(page)) != null) {
            this.pages.remove(page);
        } else {
            this.setupPage(page);
        }
        Rectangle2D bounds = page.getViewArea();
        double h = bounds.getHeight();
        this.pageHeight = (int)h;
        this.currentStream = this.pdfDoc.getFactory().makeStream("content", false);
        this.currentState = new PDFState();
        this.currentBasicTransform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, (float)this.pageHeight / 1000.0f);
        this.currentStream.add(CTMHelper.toPDFString(this.currentBasicTransform, false) + " cm\n");
        this.currentFontName = "";
        super.renderPage(page);
        this.pdfDoc.registerObject(this.currentStream);
        this.currentPage.setContents(this.currentStream);
        PDFAnnotList annots = this.currentPage.getAnnotations();
        if (annots != null) {
            this.pdfDoc.addObject(annots);
        }
        this.pdfDoc.addObject(this.currentPage);
        this.pdfDoc.output(this.ostream);
    }

    protected void startVParea(CTM ctm, Rectangle2D clippingRect) {
        this.currentState.push();
        this.currentState.setTransform(new AffineTransform(CTMHelper.toPDFArray(ctm)));
        this.saveGraphicsState();
        if (clippingRect != null) {
            this.clipRect((float)clippingRect.getX() / 1000.0f, (float)clippingRect.getY() / 1000.0f, (float)clippingRect.getWidth() / 1000.0f, (float)clippingRect.getHeight() / 1000.0f);
        }
        this.currentStream.add(CTMHelper.toPDFString(ctm) + " cm\n");
    }

    protected void endVParea() {
        this.restoreGraphicsState();
        this.currentState.pop();
    }

    protected void handleRegionTraits(RegionViewport region) {
        this.currentFontName = "";
        super.handleRegionTraits(region);
    }

    protected static final String format(float value) {
        return PDFNumber.doubleOut(value);
    }

    protected void drawBorderLine(float x1, float y1, float x2, float y2, boolean horz, boolean startOrBefore, int style, ColorType col) {
        float w = x2 - x1;
        float h = y2 - y1;
        if (w < 0.0f || h < 0.0f) {
            log.error((Object)"Negative extent received. Border won't be painted.");
            return;
        }
        switch (style) {
            case 31: {
                this.setColor(this.toColor(col), false, null);
                if (horz) {
                    float unit = Math.abs(2.0f * h);
                    int rep = (int)(w / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = w / (float)rep;
                    this.currentStream.add("[" + PDFRenderer.format(unit) + "] 0 d ");
                    this.currentStream.add(PDFRenderer.format(h) + " w\n");
                    float ym = y1 + h / 2.0f;
                    this.currentStream.add(PDFRenderer.format(x1) + " " + PDFRenderer.format(ym) + " m " + PDFRenderer.format(x2) + " " + PDFRenderer.format(ym) + " l S\n");
                    break;
                }
                float unit = Math.abs(2.0f * w);
                int rep = (int)(h / unit);
                if (rep % 2 == 0) {
                    ++rep;
                }
                unit = h / (float)rep;
                this.currentStream.add("[" + PDFRenderer.format(unit) + "] 0 d ");
                this.currentStream.add(PDFRenderer.format(w) + " w\n");
                float xm = x1 + w / 2.0f;
                this.currentStream.add(PDFRenderer.format(xm) + " " + PDFRenderer.format(y1) + " m " + PDFRenderer.format(xm) + " " + PDFRenderer.format(y2) + " l S\n");
                break;
            }
            case 36: {
                this.setColor(this.toColor(col), false, null);
                this.currentStream.add("1 J ");
                if (horz) {
                    float unit = Math.abs(2.0f * h);
                    int rep = (int)(w / unit);
                    if (rep % 2 == 0) {
                        ++rep;
                    }
                    unit = w / (float)rep;
                    this.currentStream.add("[0 " + PDFRenderer.format(unit) + "] 0 d ");
                    this.currentStream.add(PDFRenderer.format(h) + " w\n");
                    float ym = y1 + h / 2.0f;
                    this.currentStream.add(PDFRenderer.format(x1) + " " + PDFRenderer.format(ym) + " m " + PDFRenderer.format(x2) + " " + PDFRenderer.format(ym) + " l S\n");
                    break;
                }
                float unit = Math.abs(2.0f * w);
                int rep = (int)(h / unit);
                if (rep % 2 == 0) {
                    ++rep;
                }
                unit = h / (float)rep;
                this.currentStream.add("[0 " + PDFRenderer.format(unit) + " ] 0 d ");
                this.currentStream.add(PDFRenderer.format(w) + " w\n");
                float xm = x1 + w / 2.0f;
                this.currentStream.add(PDFRenderer.format(xm) + " " + PDFRenderer.format(y1) + " m " + PDFRenderer.format(xm) + " " + PDFRenderer.format(y2) + " l S\n");
                break;
            }
            case 37: {
                this.setColor(this.toColor(col), false, null);
                this.currentStream.add("[] 0 d ");
                if (horz) {
                    float h3 = h / 3.0f;
                    this.currentStream.add(PDFRenderer.format(h3) + " w\n");
                    float ym1 = y1 + h3 / 2.0f;
                    float ym2 = ym1 + h3 + h3;
                    this.currentStream.add(PDFRenderer.format(x1) + " " + PDFRenderer.format(ym1) + " m " + PDFRenderer.format(x2) + " " + PDFRenderer.format(ym1) + " l S\n");
                    this.currentStream.add(PDFRenderer.format(x1) + " " + PDFRenderer.format(ym2) + " m " + PDFRenderer.format(x2) + " " + PDFRenderer.format(ym2) + " l S\n");
                    break;
                }
                float w3 = w / 3.0f;
                this.currentStream.add(PDFRenderer.format(w3) + " w\n");
                float xm1 = x1 + w3 / 2.0f;
                float xm2 = xm1 + w3 + w3;
                this.currentStream.add(PDFRenderer.format(xm1) + " " + PDFRenderer.format(y1) + " m " + PDFRenderer.format(xm1) + " " + PDFRenderer.format(y2) + " l S\n");
                this.currentStream.add(PDFRenderer.format(xm2) + " " + PDFRenderer.format(y1) + " m " + PDFRenderer.format(xm2) + " " + PDFRenderer.format(y2) + " l S\n");
                break;
            }
            case 55: 
            case 119: {
                float colFactor = style == 55 ? 0.4f : -0.4f;
                this.currentStream.add("[] 0 d ");
                Color c = this.toColor(col);
                if (horz) {
                    Color uppercol = this.lightenColor(c, -colFactor);
                    Color lowercol = this.lightenColor(c, colFactor);
                    float h3 = h / 3.0f;
                    this.currentStream.add(PDFRenderer.format(h3) + " w\n");
                    float ym1 = y1 + h3 / 2.0f;
                    this.setColor(uppercol, false, null);
                    this.currentStream.add(PDFRenderer.format(x1) + " " + PDFRenderer.format(ym1) + " m " + PDFRenderer.format(x2) + " " + PDFRenderer.format(ym1) + " l S\n");
                    this.setColor(c, false, null);
                    this.currentStream.add(PDFRenderer.format(x1) + " " + PDFRenderer.format(ym1 + h3) + " m " + PDFRenderer.format(x2) + " " + PDFRenderer.format(ym1 + h3) + " l S\n");
                    this.setColor(lowercol, false, null);
                    this.currentStream.add(PDFRenderer.format(x1) + " " + PDFRenderer.format(ym1 + h3 + h3) + " m " + PDFRenderer.format(x2) + " " + PDFRenderer.format(ym1 + h3 + h3) + " l S\n");
                    break;
                }
                Color leftcol = this.lightenColor(c, -colFactor);
                Color rightcol = this.lightenColor(c, colFactor);
                float w3 = w / 3.0f;
                this.currentStream.add(PDFRenderer.format(w3) + " w\n");
                float xm1 = x1 + w3 / 2.0f;
                this.setColor(leftcol, false, null);
                this.currentStream.add(PDFRenderer.format(xm1) + " " + PDFRenderer.format(y1) + " m " + PDFRenderer.format(xm1) + " " + PDFRenderer.format(y2) + " l S\n");
                this.setColor(c, false, null);
                this.currentStream.add(PDFRenderer.format(xm1 + w3) + " " + PDFRenderer.format(y1) + " m " + PDFRenderer.format(xm1 + w3) + " " + PDFRenderer.format(y2) + " l S\n");
                this.setColor(rightcol, false, null);
                this.currentStream.add(PDFRenderer.format(xm1 + w3 + w3) + " " + PDFRenderer.format(y1) + " m " + PDFRenderer.format(xm1 + w3 + w3) + " " + PDFRenderer.format(y2) + " l S\n");
                break;
            }
            case 67: 
            case 101: {
                float colFactor = style == 101 ? 0.4f : -0.4f;
                this.currentStream.add("[] 0 d ");
                Color c = this.toColor(col);
                if (horz) {
                    c = this.lightenColor(c, (float)(startOrBefore ? 1 : -1) * colFactor);
                    this.currentStream.add(PDFRenderer.format(h) + " w\n");
                    float ym1 = y1 + h / 2.0f;
                    this.setColor(c, false, null);
                    this.currentStream.add(PDFRenderer.format(x1) + " " + PDFRenderer.format(ym1) + " m " + PDFRenderer.format(x2) + " " + PDFRenderer.format(ym1) + " l S\n");
                    break;
                }
                c = this.lightenColor(c, (float)(startOrBefore ? 1 : -1) * colFactor);
                this.currentStream.add(PDFRenderer.format(w) + " w\n");
                float xm1 = x1 + w / 2.0f;
                this.setColor(c, false, null);
                this.currentStream.add(PDFRenderer.format(xm1) + " " + PDFRenderer.format(y1) + " m " + PDFRenderer.format(xm1) + " " + PDFRenderer.format(y2) + " l S\n");
                break;
            }
            case 57: {
                break;
            }
            default: {
                this.setColor(this.toColor(col), false, null);
                this.currentStream.add("[] 0 d ");
                if (horz) {
                    this.currentStream.add(PDFRenderer.format(h) + " w\n");
                    float ym = y1 + h / 2.0f;
                    this.currentStream.add(PDFRenderer.format(x1) + " " + PDFRenderer.format(ym) + " m " + PDFRenderer.format(x2) + " " + PDFRenderer.format(ym) + " l S\n");
                    break;
                }
                this.currentStream.add(PDFRenderer.format(w) + " w\n");
                float xm = x1 + w / 2.0f;
                this.currentStream.add(PDFRenderer.format(xm) + " " + PDFRenderer.format(y1) + " m " + PDFRenderer.format(xm) + " " + PDFRenderer.format(y2) + " l S\n");
            }
        }
    }

    private void updateLineWidth(float width) {
        if (this.currentState.setLineWidth(width)) {
            this.currentStream.add(PDFRenderer.format(width) + " w\n");
        }
    }

    protected void clipRect(float x, float y, float width, float height) {
        this.currentStream.add(PDFRenderer.format(x) + " " + PDFRenderer.format(y) + " " + PDFRenderer.format(width) + " " + PDFRenderer.format(height) + " re ");
        this.clip();
    }

    protected void clip() {
        this.currentStream.add("W\n");
        this.currentStream.add("n\n");
    }

    protected void moveTo(float x, float y) {
        this.currentStream.add(PDFRenderer.format(x) + " " + PDFRenderer.format(y) + " m ");
    }

    protected void lineTo(float x, float y) {
        this.currentStream.add(PDFRenderer.format(x) + " " + PDFRenderer.format(y) + " l ");
    }

    protected void closePath() {
        this.currentStream.add("h ");
    }

    protected void fillRect(float x, float y, float w, float h) {
        if (w != 0.0f && h != 0.0f) {
            this.currentStream.add(PDFRenderer.format(x) + " " + PDFRenderer.format(y) + " " + PDFRenderer.format(w) + " " + PDFRenderer.format(h) + " re f\n");
        }
    }

    private void drawLine(float startx, float starty, float endx, float endy) {
        this.currentStream.add(PDFRenderer.format(startx) + " " + PDFRenderer.format(starty) + " m ");
        this.currentStream.add(PDFRenderer.format(endx) + " " + PDFRenderer.format(endy) + " l S\n");
    }

    protected List breakOutOfStateStack() {
        ArrayList<PDFState.Data> breakOutList = new ArrayList<PDFState.Data>();
        while (true) {
            PDFState.Data data = this.currentState.getData();
            if (this.currentState.pop() == null) break;
            if (breakOutList.size() == 0) {
                this.comment("------ break out!");
            }
            breakOutList.add(0, data);
            this.restoreGraphicsState();
        }
        return breakOutList;
    }

    protected void restoreStateStackAfterBreakOut(List breakOutList) {
        this.comment("------ restoring context after break-out...");
        Iterator i = breakOutList.iterator();
        double[] matrix = new double[6];
        while (i.hasNext()) {
            PDFState.Data data = (PDFState.Data)i.next();
            this.currentState.push();
            this.saveGraphicsState();
            AffineTransform at = data.getTransform();
            if (at.isIdentity()) continue;
            this.currentState.setTransform(at);
            at.getMatrix(matrix);
            CTM tempctm = new CTM(matrix[0], matrix[1], matrix[2], matrix[3], matrix[4] * 1000.0, matrix[5] * 1000.0);
            this.currentStream.add(CTMHelper.toPDFString(tempctm) + " cm\n");
        }
        this.comment("------ done.");
    }

    protected void renderLineArea(LineArea line) {
        super.renderLineArea(line);
        this.closeText();
    }

    public void renderInlineParent(InlineParent ip) {
        float start = (float)this.currentIPPosition / 1000.0f;
        float top = (float)(ip.getOffset() + this.currentBPPosition) / 1000.0f;
        float width = (float)ip.getIPD() / 1000.0f;
        float height = (float)ip.getBPD() / 1000.0f;
        super.renderInlineParent(ip);
        Object tr = ip.getTrait(Trait.INTERNAL_LINK);
        boolean internal = false;
        String dest = null;
        float yoffset = 0.0f;
        if (tr == null) {
            dest = (String)ip.getTrait(Trait.EXTERNAL_LINK);
        } else {
            String pvKey = (String)tr;
            dest = (String)this.pageReferences.get(pvKey);
            if (dest != null) {
                PageViewport pv = (PageViewport)this.pvReferences.get(pvKey);
                Rectangle2D bounds = pv.getViewArea();
                double h = bounds.getHeight();
                yoffset = (float)h / 1000.0f;
                internal = true;
            }
        }
        if (dest != null) {
            Rectangle2D rect = new Rectangle2D.Float(start, top, width, height);
            AffineTransform transform = this.currentState.getTransform();
            rect = transform.createTransformedShape(rect).getBounds2D();
            rect = this.currentBasicTransform.createTransformedShape(rect).getBounds2D();
            int type = internal ? 1 : 0;
            PDFLink pdflink = this.pdfDoc.getFactory().makeLink(rect, dest, type, yoffset);
            this.currentPage.addAnnotation(pdflink);
        }
    }

    public void renderCharacter(Character ch) {
        this.renderInlineAreaBackAndBorders(ch);
        this.beginTextObject();
        StringBuffer pdf = new StringBuffer();
        Font font = this.getFontFromArea(ch);
        Typeface tf = (Typeface)this.fontInfo.getFonts().get(font.getFontName());
        boolean useMultiByte = tf.isMultiByte();
        String startText = useMultiByte ? "<" : "(";
        String endText = useMultiByte ? "> " : ") ";
        this.updateFont(font.getFontName(), font.getFontSize(), pdf);
        ColorType ct = (ColorType)ch.getTrait(Trait.COLOR);
        if (ct != null) {
            this.updateColor(ct, true, pdf);
        }
        int rx = this.currentIPPosition + ch.getBorderAndPaddingWidthStart();
        int bl = this.currentBPPosition + ch.getOffset() + ch.getBaselineOffset();
        if (!this.textOpen || bl != this.prevWordY) {
            this.closeText();
            pdf.append("1 0 0 -1 " + PDFRenderer.format((float)rx / 1000.0f) + " " + PDFRenderer.format((float)bl / 1000.0f) + " Tm " + PDFRenderer.format((float)ch.getTextLetterSpaceAdjust() / 1000.0f) + " Tc " + PDFRenderer.format((float)ch.getTextWordSpaceAdjust() / 1000.0f) + " Tw [" + startText);
            this.prevWordY = bl;
            this.textOpen = true;
        } else {
            this.closeText();
            pdf.append("1 0 0 -1 " + PDFRenderer.format((float)rx / 1000.0f) + " " + PDFRenderer.format((float)bl / 1000.0f) + " Tm " + PDFRenderer.format((float)ch.getTextLetterSpaceAdjust() / 1000.0f) + " Tc " + PDFRenderer.format((float)ch.getTextWordSpaceAdjust() / 1000.0f) + " Tw [" + startText);
            this.textOpen = true;
        }
        this.prevWordWidth = ch.getIPD();
        this.prevWordX = rx;
        String s = ch.getChar();
        this.escapeText(s, font, useMultiByte, pdf);
        pdf.append(endText);
        this.currentStream.add(pdf.toString());
        this.renderTextDecoration(tf, font.getFontSize(), ch, bl, rx);
        super.renderCharacter(ch);
    }

    public void renderText(TextArea text) {
        this.renderInlineAreaBackAndBorders(text);
        this.beginTextObject();
        StringBuffer pdf = new StringBuffer();
        String fontName = this.getInternalFontNameForArea(text);
        int size = (Integer)text.getTrait(Trait.FONT_SIZE);
        Typeface tf = (Typeface)this.fontInfo.getFonts().get(fontName);
        boolean useMultiByte = tf.isMultiByte();
        this.updateFont(fontName, size, pdf);
        ColorType ct = (ColorType)text.getTrait(Trait.COLOR);
        this.updateColor(ct, true, pdf);
        int rx = this.currentIPPosition + text.getBorderAndPaddingWidthStart();
        int bl = this.currentBPPosition + text.getOffset() + text.getBaselineOffset();
        if (!this.textOpen || bl != this.prevWordY) {
            this.closeText();
            pdf.append("1 0 0 -1 " + PDFRenderer.format((float)rx / 1000.0f) + " " + PDFRenderer.format((float)bl / 1000.0f) + " Tm " + PDFRenderer.format((float)text.getTextLetterSpaceAdjust() / 1000.0f) + " Tc " + PDFRenderer.format((float)text.getTextWordSpaceAdjust() / 1000.0f) + " Tw [");
            this.prevWordY = bl;
            this.textOpen = true;
        } else {
            this.closeText();
            pdf.append("1 0 0 -1 " + PDFRenderer.format((float)rx / 1000.0f) + " " + PDFRenderer.format((float)bl / 1000.0f) + " Tm " + PDFRenderer.format((float)text.getTextLetterSpaceAdjust() / 1000.0f) + " Tc " + PDFRenderer.format((float)text.getTextWordSpaceAdjust() / 1000.0f) + " Tw [");
            this.textOpen = true;
        }
        this.prevWordWidth = text.getIPD();
        this.prevWordX = rx;
        this.currentStream.add(pdf.toString());
        super.renderText(text);
        this.renderTextDecoration(tf, size, text, bl, rx);
    }

    public void renderWord(WordArea word) {
        Font font = this.getFontFromArea(word.getParentArea());
        Typeface tf = (Typeface)this.fontInfo.getFonts().get(font.getFontName());
        boolean useMultiByte = tf.isMultiByte();
        String startText = useMultiByte ? "<" : "(";
        String endText = useMultiByte ? "> " : ") ";
        StringBuffer pdf = new StringBuffer();
        pdf.append(startText);
        String s = word.getWord();
        this.escapeText(s, font, useMultiByte, pdf);
        pdf.append(endText);
        this.currentStream.add(pdf.toString());
        super.renderWord(word);
    }

    public void renderSpace(SpaceArea space) {
        Font font = this.getFontFromArea(space.getParentArea());
        Typeface tf = (Typeface)this.fontInfo.getFonts().get(font.getFontName());
        boolean useMultiByte = tf.isMultiByte();
        String startText = useMultiByte ? "<" : "(";
        String endText = useMultiByte ? "> " : ") ";
        StringBuffer pdf = new StringBuffer();
        pdf.append(startText);
        String s = space.getSpace();
        this.escapeText(s, font, useMultiByte, pdf);
        pdf.append(endText);
        if (useMultiByte) {
            float tws = -((float)((TextArea)space.getParentArea()).getTextWordSpaceAdjust() / ((float)font.getFontSize() / 1000.0f));
            pdf.append(PDFRenderer.format(tws) + " ");
        }
        this.currentStream.add(pdf.toString());
        super.renderSpace(space);
    }

    public void escapeText(String s, Font fs, boolean useMultiByte, StringBuffer pdf) {
        String startText = useMultiByte ? "<" : "(";
        String endText = useMultiByte ? "> " : ") ";
        boolean kerningAvailable = false;
        Map kerning = fs.getKerning();
        if (kerning != null && !kerning.isEmpty()) {
            log.warn((Object)"Kerning support is disabled until it is supported by the layout engine!");
        }
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            char ch = fs.mapChar(s.charAt(i));
            if (!useMultiByte) {
                if (ch > '\u007f') {
                    pdf.append("\\");
                    pdf.append(Integer.toOctalString(ch));
                } else {
                    switch (ch) {
                        case '(': 
                        case ')': 
                        case '\\': {
                            pdf.append("\\");
                        }
                    }
                    pdf.append(ch);
                }
            } else {
                pdf.append(PDFText.toUnicodeHex(ch));
            }
            if (!kerningAvailable || i + 1 >= l) continue;
            this.addKerning(pdf, new Integer(ch), new Integer(fs.mapChar(s.charAt(i + 1))), kerning, startText, endText);
        }
    }

    private void addKerning(StringBuffer buf, Integer ch1, Integer ch2, Map kerning, String startText, String endText) {
        Integer width;
        Map kernPair = (Map)kerning.get(ch1);
        if (kernPair != null && (width = (Integer)kernPair.get(ch2)) != null) {
            buf.append(endText).append(-width.intValue());
            buf.append(' ').append(startText);
        }
    }

    protected void closeText() {
        if (this.textOpen) {
            this.currentStream.add("] TJ\n");
            this.textOpen = false;
            this.prevWordX = 0;
            this.prevWordY = 0;
            this.currentFontName = "";
        }
    }

    protected void setColor(Color col, boolean fill, StringBuffer pdf) {
        PDFColor color = new PDFColor(col);
        this.closeText();
        if (pdf != null) {
            pdf.append(color.getColorSpaceOut(fill));
        } else {
            this.currentStream.add(color.getColorSpaceOut(fill));
        }
    }

    private void updateColor(ColorType col, boolean fill, StringBuffer pdf) {
        if (col == null) {
            return;
        }
        Color newCol = this.toColor(col);
        boolean update = false;
        update = fill ? this.currentState.setBackColor(newCol) : this.currentState.setColor(newCol);
        if (update) {
            this.setColor(newCol, fill, pdf);
        }
    }

    protected void updateColor(ColorType col, boolean fill) {
        this.updateColor(col, fill, null);
    }

    private void updateFont(String name, int size, StringBuffer pdf) {
        if (!name.equals(this.currentFontName) || size != this.currentFontSize) {
            this.closeText();
            this.currentFontName = name;
            this.currentFontSize = size;
            pdf = pdf.append("/" + name + " " + PDFRenderer.format((float)size / 1000.0f) + " Tf\n");
        }
    }

    public void renderImage(Image image, Rectangle2D pos) {
        this.endTextObject();
        String url = image.getURL();
        this.putImage(url, pos);
    }

    protected void drawImage(String url, Rectangle2D pos) {
        this.endTextObject();
        this.putImage(url, pos);
    }

    protected void putImage(String url, Rectangle2D pos) {
        PDFXObject xobject = this.pdfDoc.getImage(url);
        if (xobject != null) {
            float w = (float)pos.getWidth() / 1000.0f;
            float h = (float)pos.getHeight() / 1000.0f;
            this.placeImage((float)pos.getX() / 1000.0f, (float)pos.getY() / 1000.0f, w, h, xobject.getXNumber());
            return;
        }
        url = ImageFactory.getURL(url);
        ImageFactory fact = ImageFactory.getInstance();
        FopImage fopimage = fact.getImage(url, this.userAgent);
        if (fopimage == null) {
            return;
        }
        if (!fopimage.load(1)) {
            return;
        }
        String mime = fopimage.getMimeType();
        if ("text/xml".equals(mime)) {
            if (!fopimage.load(2)) {
                return;
            }
            Document doc = ((XMLImage)fopimage).getDocument();
            String ns = ((XMLImage)fopimage).getNameSpace();
            this.renderDocument(doc, ns, pos);
        } else if ("image/svg+xml".equals(mime)) {
            if (!fopimage.load(2)) {
                return;
            }
            Document doc = ((XMLImage)fopimage).getDocument();
            String ns = ((XMLImage)fopimage).getNameSpace();
            this.renderDocument(doc, ns, pos);
        } else if ("image/eps".equals(mime)) {
            FopPDFImage pdfimage = new FopPDFImage(fopimage, url);
            int xobj = this.pdfDoc.addImage(this.currentContext, pdfimage).getXNumber();
            fact.releaseImage(url, this.userAgent);
        } else if ("image/jpeg".equals(mime) || "image/tiff".equals(mime)) {
            FopPDFImage pdfimage = new FopPDFImage(fopimage, url);
            int xobj = this.pdfDoc.addImage(this.currentContext, pdfimage).getXNumber();
            fact.releaseImage(url, this.userAgent);
            float w = (float)pos.getWidth() / 1000.0f;
            float h = (float)pos.getHeight() / 1000.0f;
            this.placeImage((float)pos.getX() / 1000.0f, (float)pos.getY() / 1000.0f, w, h, xobj);
        } else {
            if (!fopimage.load(4)) {
                return;
            }
            FopPDFImage pdfimage = new FopPDFImage(fopimage, url);
            int xobj = this.pdfDoc.addImage(this.currentContext, pdfimage).getXNumber();
            fact.releaseImage(url, this.userAgent);
            float w = (float)pos.getWidth() / 1000.0f;
            float h = (float)pos.getHeight() / 1000.0f;
            this.placeImage((float)pos.getX() / 1000.0f, (float)pos.getY() / 1000.0f, w, h, xobj);
        }
        try {
            this.pdfDoc.output(this.ostream);
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    protected void placeImage(float x, float y, float w, float h, int xobj) {
        this.saveGraphicsState();
        this.currentStream.add(PDFRenderer.format(w) + " 0 0 " + PDFRenderer.format(-h) + " " + PDFRenderer.format((float)this.currentIPPosition / 1000.0f + x) + " " + PDFRenderer.format((float)this.currentBPPosition / 1000.0f + h + y) + " cm\n" + "/Im" + xobj + " Do\n");
        this.restoreGraphicsState();
    }

    public void renderForeignObject(ForeignObject fo, Rectangle2D pos) {
        this.endTextObject();
        Document doc = fo.getDocument();
        String ns = fo.getNameSpace();
        this.renderDocument(doc, ns, pos);
    }

    public void renderDocument(Document doc, String ns, Rectangle2D pos) {
        RendererContext context = new RendererContext(this, MIME_TYPE);
        context.setUserAgent(this.userAgent);
        context.setProperty("pdfDoc", this.pdfDoc);
        context.setProperty("outputStream", this.ostream);
        context.setProperty("pageViewport", this.getCurrentPageViewport());
        context.setProperty("pdfState", this.currentState);
        context.setProperty("pdfPage", this.currentPage);
        context.setProperty("pdfContext", this.currentContext == null ? this.currentPage : this.currentContext);
        context.setProperty("pdfContext", this.currentContext);
        context.setProperty("pdfStream", this.currentStream);
        context.setProperty("xpos", new Integer(this.currentIPPosition + (int)pos.getX()));
        context.setProperty("ypos", new Integer(this.currentBPPosition + (int)pos.getY()));
        context.setProperty("fontInfo", this.fontInfo);
        context.setProperty("fontName", this.currentFontName);
        context.setProperty("fontSize", new Integer(this.currentFontSize));
        context.setProperty("width", new Integer((int)pos.getWidth()));
        context.setProperty("height", new Integer((int)pos.getHeight()));
        this.renderXML(context, doc, ns);
    }

    public void renderLeader(Leader area) {
        this.renderInlineAreaBackAndBorders(area);
        this.currentState.push();
        this.saveGraphicsState();
        int style = area.getRuleStyle();
        float startx = (float)(this.currentIPPosition + area.getBorderAndPaddingWidthStart()) / 1000.0f;
        float starty = (float)(this.currentBPPosition + area.getOffset()) / 1000.0f;
        float endx = (float)(this.currentIPPosition + area.getBorderAndPaddingWidthStart() + area.getIPD()) / 1000.0f;
        float ruleThickness = (float)area.getRuleThickness() / 1000.0f;
        ColorType col = (ColorType)area.getTrait(Trait.COLOR);
        switch (style) {
            case 31: 
            case 37: 
            case 133: {
                this.drawBorderLine(startx, starty, endx, starty + ruleThickness, true, true, style, col);
                break;
            }
            case 36: {
                this.clipRect(startx, starty, endx - startx, ruleThickness);
                this.currentStream.add("1 0 0 1 " + PDFRenderer.format(ruleThickness / 2.0f) + " 0 cm\n");
                this.drawBorderLine(startx, starty, endx, starty + ruleThickness, true, true, style, col);
                break;
            }
            case 55: 
            case 119: {
                float half = (float)area.getRuleThickness() / 2000.0f;
                this.setColor(this.lightenColor(this.toColor(col), 0.6f), true, null);
                this.currentStream.add(PDFRenderer.format(startx) + " " + PDFRenderer.format(starty) + " m\n");
                this.currentStream.add(PDFRenderer.format(endx) + " " + PDFRenderer.format(starty) + " l\n");
                this.currentStream.add(PDFRenderer.format(endx) + " " + PDFRenderer.format(starty + 2.0f * half) + " l\n");
                this.currentStream.add(PDFRenderer.format(startx) + " " + PDFRenderer.format(starty + 2.0f * half) + " l\n");
                this.currentStream.add("h\n");
                this.currentStream.add("f\n");
                this.setColor(this.toColor(col), true, null);
                if (style == 55) {
                    this.currentStream.add(PDFRenderer.format(startx) + " " + PDFRenderer.format(starty) + " m\n");
                    this.currentStream.add(PDFRenderer.format(endx) + " " + PDFRenderer.format(starty) + " l\n");
                    this.currentStream.add(PDFRenderer.format(endx) + " " + PDFRenderer.format(starty + half) + " l\n");
                    this.currentStream.add(PDFRenderer.format(startx + half) + " " + PDFRenderer.format(starty + half) + " l\n");
                    this.currentStream.add(PDFRenderer.format(startx) + " " + PDFRenderer.format(starty + 2.0f * half) + " l\n");
                } else {
                    this.currentStream.add(PDFRenderer.format(endx) + " " + PDFRenderer.format(starty) + " m\n");
                    this.currentStream.add(PDFRenderer.format(endx) + " " + PDFRenderer.format(starty + 2.0f * half) + " l\n");
                    this.currentStream.add(PDFRenderer.format(startx) + " " + PDFRenderer.format(starty + 2.0f * half) + " l\n");
                    this.currentStream.add(PDFRenderer.format(startx) + " " + PDFRenderer.format(starty + half) + " l\n");
                    this.currentStream.add(PDFRenderer.format(endx - half) + " " + PDFRenderer.format(starty + half) + " l\n");
                }
                this.currentStream.add("h\n");
                this.currentStream.add("f\n");
                break;
            }
            default: {
                throw new UnsupportedOperationException("rule style not supported");
            }
        }
        this.restoreGraphicsState();
        this.currentState.pop();
        this.beginTextObject();
        super.renderLeader(area);
    }

    public String getMimeType() {
        return MIME_TYPE;
    }
}

